VERSION 5.00
Begin VB.Form SAMPLE100 
   Caption         =   "MCU-G3 TOOLSET:  Sample100-Demo-Programm"
   ClientHeight    =   3615
   ClientLeft      =   4860
   ClientTop       =   3225
   ClientWidth     =   6990
   LinkTopic       =   "Form1"
   ScaleHeight     =   3615
   ScaleWidth      =   6990
   Begin VB.CommandButton SpoolerTest 
      Caption         =   "Spooler Test"
      Height          =   375
      Left            =   5280
      TabIndex        =   15
      Top             =   3120
      Width           =   1575
   End
   Begin VB.CommandButton OpenLoop 
      Caption         =   "Open Loop"
      Height          =   375
      Left            =   1920
      TabIndex        =   14
      Top             =   720
      Width           =   1215
   End
   Begin VB.Frame FrameSystemStatus 
      Caption         =   "System Status"
      Height          =   1095
      Left            =   240
      TabIndex        =   10
      Top             =   1200
      Width           =   6615
      Begin VB.Label SR 
         Caption         =   ".............."
         Height          =   255
         Left            =   120
         TabIndex        =   13
         Top             =   480
         Width           =   6255
      End
      Begin VB.Label BR 
         Caption         =   ".............."
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   240
         Width           =   6375
      End
      Begin VB.Label IR 
         Caption         =   ".............."
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   720
         Width           =   6375
      End
   End
   Begin VB.Frame FrameActVals 
      Caption         =   "Actual Values"
      Height          =   975
      Left            =   240
      TabIndex        =   5
      Top             =   2520
      Width           =   4335
      Begin VB.Label rp0 
         Caption         =   "Real Position Axis 1"
         Height          =   255
         Left            =   1680
         TabIndex        =   9
         Top             =   360
         Width           =   1815
      End
      Begin VB.Label rp1 
         Caption         =   "Real Position Axis 3"
         Height          =   255
         Left            =   1680
         TabIndex        =   8
         Top             =   600
         Width           =   2535
      End
      Begin VB.Label axst0 
         Caption         =   "Axis Status Axis 1"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   360
         Width           =   1455
      End
      Begin VB.Label axst1 
         Caption         =   "Axis Status Axis 3"
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   600
         Width           =   1335
      End
   End
   Begin VB.CommandButton LedOff 
      Caption         =   "Leds Off"
      Height          =   375
      Left            =   5640
      TabIndex        =   4
      Top             =   720
      Width           =   1215
   End
   Begin VB.CommandButton LedOn 
      Caption         =   "Leds On"
      Height          =   375
      Left            =   5640
      TabIndex        =   3
      Top             =   240
      Width           =   1215
   End
   Begin VB.CommandButton Jog 
      Caption         =   "Jog"
      Height          =   375
      Left            =   3240
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
   Begin VB.CommandButton CloseLoop 
      Caption         =   "Close Loop"
      Height          =   375
      Left            =   1920
      TabIndex        =   1
      Top             =   240
      Width           =   1215
   End
   Begin VB.Timer Timer1 
      Interval        =   50
      Left            =   6360
      Top             =   2640
   End
   Begin VB.CommandButton Boot 
      Caption         =   "Boot"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   975
   End
End
Attribute VB_Name = "SAMPLE100"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' +-----------------------------------------------------------------------+
' | (C) Roesch & Walter Industrie-Elektronik GmbH                         |
' | Im Heidenwinkel 5            D-77963 Schwanau                         |
' +-------------------------------+---------------------------------------+
' | Tel : +49 (0) 7824/6628-0     | email    : support@rw-gmbh.de         |
' | Fax : +49 (0) 7824/6628-29    | Internet : http://www.rw-gmbh.de      |
' +-------------------------------+---------------------------------------+
' | Project     : MCUG3 TOOLSET   | Compiler : Microsoft Visual Basic     |
' |                               |                                       |
' | Module name : sample100.bas   | Operating System:                     |
' |                               |            - Windows 95/98/Me         |
' |                               |            - Windows NT 4.0           |
' |                               |            - Windows NT Embedded 4.0  |
' |                               |            - Windows 2000             |
' +-------------------------------+---------------------------------------+
' | Author : Roesch R.               Date :22/06/2001                     |
' |          Walter M.                                                    |
' +-----------------------------------------------------------------------+
' | Description   : Sample Program File for the                           |
' |                 High-Performance Motion-Control Family Generation 3   |
' |                                                                       |
' |                 Currently supported G3-Controllers:                   |
' |                         MCU-3000, APCI-8001, MCU-6000 and APCI-8401   |
' |                                                                       |
' |                                                                       |
' +-----------------------------------------------------------------------+
'
'   revision History:
'   -----------------
'   04/03/2002  V2-50   rr  String SYSFILENAME changed
'   22/06/2001  V2-50   rr  More comments
'
'
'   !!! Attention !!!:
'   -----------------
'
'   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
'   you must setup below -  SYSFILENAME and BOOTFILENAME
'   according your requirements
'   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



Dim tsrp_(0 To MAXAXIS - 1) As TSRP
Dim rosi_ As ROSI
Dim FBoardType As BOARDTYPE

Dim bootresult As Long
Dim initresult As Long
Dim TempString As String
Dim SBoardType As String
Dim I As Integer
Dim lasel As ASEL
Dim llmp As lmp
Dim ltru As tru



Const ba = 0
' !!! Please change BOOTFILENAME and SYSFILENAME below according your setup!!!
Const BOOTFILENAME = "C:\cvswork\mcug3\rwmos\mcu3000\standard\rwmos.elf"
Const SYSFILENAME = "C:\mcu\sysdat\system.dat"

Private Sub InitMcuSample()
    'Important: InitMcuSystem2 or InitMcuSystem3 must be the first function after boot
    initresult = InitMcuSystem3(tsrp_(0), rosi_, ba, SYSFILENAME + Chr$(0), FBoardType)
    
    TempString = ""
    If (initresult = 0) Then
        I = 0
        While rosi_.revision(I) <> 0
            TempString = TempString + Chr(rosi_.revision(I))
            I = I + 1
        Wend
    Else
        ' show the error in a message box
        InitMcuErrorReport (initresult)
    End If
        
    If ((FBoardType <= UNKNOWNBOARD) Or (FBoardType > MCU6000)) Then
    SBoardType = "Unknown Board"
    Else
    SBoardType = Switch(FBoardType = MCU3000, "MCU-3000, APCI-8001", _
                        FBoardType = MCU6000, "MCU-6000, APCI-8401")
    End If
    
    IR.Caption = "Init-Result = " + CStr(initresult) + ", " + TempString _
                + ", " + SBoardType
    
    SR.Caption = "System-File = " + SYSFILENAME
    
    Refresh

End Sub

Private Sub Boot_Click()
    BR.Caption = "Booting: " + BOOTFILENAME
    Refresh
    
    ' booting the MCU-G3
    bootresult = BootFile(BOOTFILENAME + Chr$(0), ba)
    BR.Caption = "Boot-Result = " + CStr(bootresult)
    
    If bootresult = 0 Then
        Call InitMcuSample
    Else
        Call BootErrorReport(BOOTFILENAME + Chr$(0), bootresult)
    End If
End Sub

Private Sub CloseLoop_Click()
    ' activate position control for axes 1 and 3
    If (initresult = 0) Then
        lasel.unoa = 2
        lasel.san(0) = 0
        lasel.san(1) = 2
        Call cl(lasel)
    End If
End Sub

Private Sub Form_Load()
    initresult = -1
    Call InitMcuSample
End Sub

Private Sub Form_Unload(Cancel As Integer)
    ' McuClose must be called!
    Call McuClose
End Sub

Private Sub Jog_Click()
    If (initresult = 0) Then
        ' start a motion profile with axis 1
        lasel.unoa = 1
        lasel.san(0) = 0
        tsrp_(0).tp = 100
        Call jr(lasel, tsrp_(0))
    
        ' start a motion profile with axis 3
        lasel.unoa = 1
        lasel.san(0) = 2
        tsrp_(2).tp = 200
        Call jr(lasel, tsrp_(0))
    End If
End Sub

Private Sub LedOff_Click()
    If (initresult = 0) Then
        Call wrledrd(False)
        Call wrledgn(False)
        Call wrledyl(False)
    End If
End Sub

Private Sub LedOn_Click()
    If (initresult = 0) Then
        Call wrledrd(True)
        Call wrledgn(True)
        Call wrledyl(True)
    End If
End Sub

Private Sub OpenLoop_Click()
    ' deactivate position control for axes 1 and 3
    If (initresult = 0) Then
        lasel.unoa = 2
        lasel.san(0) = 0
        lasel.san(1) = 2
        Call ol(lasel)
    End If
End Sub

Private Sub SpoolerTest_Click()
    If (initresult = 0) Then
        ' use all available axis (build ASEL)
        lasel.unoa = rosi_.number_axis
        For I = 0 To lasel.unoa
            lasel.san(I) = I
        Next I
        
        Call ra(lasel)  ' reset axis
        Call cl(lasel)  ' close loop
        
        ' if you are working with move commands call ctru() before using first time
        ltru.pu = MM
        ltru.tu = SEC
        Call ctru(ltru)
        
        ' select trajectory parameters
        llmp.ac = 500#
        llmp.tvl = 200#
        llmp.vl = 200#  ' select target velocity

        ' set start points
        For I = 0 To lasel.unoa
            llmp.dtm(I) = 0#
        Next I
        
        
        Beep
        ' fill spooler
        For j = 0 To 4999
            For I = 0 To lasel.unoa
                ' calc. next postions
                llmp.dtm(I) = llmp.dtm(I) + 0.1
            Next I
            ' spool motion linear absolute
            Call smla(lasel, llmp)
        Next j
     
       
        ' select target velocity 0 for last motion profile
        llmp.tvl = 0#
        For I = 0 To lasel.unoa
           llmp.dtm(I) = llmp.dtm(I) + 100#
        Next I
        Call smla(lasel, llmp)
        
        Call ssms(lasel)    ' start the spooler of all axis

        Beep
        
        
    End If
End Sub

Private Sub Timer1_Timer()
    If (initresult = 0) Then
        ' display desired position of axis 1 and 3
        ' the real postition you can get with rdrp()
        Call rddp(tsrp_(0))
        rp0.Caption = CDbl(tsrp_(0).dp)
        Call rddp(tsrp_(2))
        rp1.Caption = CDbl(tsrp_(2).dp)
        ' display axsi status of axis 1 and 3
        ' the axis status you can get with rdaxst()
        Call rdaxst(tsrp_(0))
        axst0.Caption = Hex(tsrp_(0).axst)
        Call rdaxst(tsrp_(2))
        axst1.Caption = Hex(tsrp_(2).axst)
    End If
End Sub

