//-------------------------------------------------------------------
// Include-File for MCU-G3 Scanner-Functions
// SAP-Programming language
// Last change: 28.05.2008
//-------------------------------------------------------------------

const ScannerBus 		= 1100;
const	ScanFunction	= 0;

// Scanner Command registers ..........
// release old MCU-G3 Resource handles
var 	FScannerClean_w:  		integer AT %QDScannerBus.ScanFunction.1.0;	
// initiliase scanner (ensure all other paramteres have been setup before)
var 	FScannerInit_w:  			integer AT %QDScannerBus.ScanFunction.2.0;	
// Start (setting 1) or Stop (setting 0) the scanner
var 	FScannerStartStop_w: 		integer AT %QDScannerBus.ScanFunction.3.0;	
// set the global Scan Time Factor (a value of 1 means: scan every sample time)
var	FScannerSTimeFactor_w:	  	integer AT %QDScannerBus.ScanFunction.6.0;	
// specify the number of records to scan
var	FScannerRecordsToScan_w:  	integer AT %QDScannerBus.ScanFunction.7.0;	
// Register for Hardware Scan Enable
var	FScannerHwScanStrobe_w:  	integer AT %QDScannerBus.ScanFunction.11.0;	

// Scanner Status registers .............
var	FScannerStartStop_r:	  	integer AT %IDScannerBus.ScanFunction.3.0;	
// Bitcoded status / error register
var	FScannerStatus_r:	 	 	integer AT %IDScannerBus.ScanFunction.4.0;	
	// Status flags 0 .. 7
	// empty 		- Bit 0: currently no data in scan buffer
	// full		- Bit 1: scan buffer is full
	// inprocess	- Bit 2: scan buffer is active
	// endless		- Bit 3: endless scan
	//			- Bit 4 .. 7 (currently not used)
	// Error flags 0 .. 15
	// norecords	- Bit 8: no record available (no resource scan list defined)
	// overrun		- Bit 9: the scan buffer has been overrun

// Size of scan buffer (bytes) can be set with environment variable (up to max. 30 MBytes)
var	FScannerSizeBuffer_r:	 	integer AT %IDScannerBus.ScanFunction.5.0;	
// see *_w
var	FScannerTimeFactor_r:	  	integer AT %IDScannerBus.ScanFunction.6.0;	
// see *_w
var	FScannerRecordsToScan_r:  	integer AT %IDScannerBus.ScanFunction.7.0;	
// Number of records scanned up to now
var	FScannerRecordsScanned_r:	integer AT %IDScannerBus.ScanFunction.8.0;	
// see *_w
var	FScannerSizeofRecord_r:  	integer AT %IDScannerBus.ScanFunction.9.0;	
// Left scanner memory (bytes)
var	FScannerLsm_r:  			integer AT %IDScannerBus.ScanFunction.10.0;	
// Register for Hardware Scan Enable
var	FScannerHwScanStrobe_r:  	integer AT %IDScannerBus.ScanFunction.11.0;	

// Register for Hardware Scan Syncronisation Output
var	FScannerSyncPulseOut_r:  	integer AT %IDScannerBus.ScanFunction.64.0;	
var	FScannerSyncPulseOut_w:  	integer AT %QDScannerBus.ScanFunction.64.0;	

