/*

  +-----------------------------------------------------------------------+
  | (C) Roesch & Walter Industrie-Elektronik GmbH                         |
  | Woertelweg 2 b/c             D-77963 Schwanau                         |
  +-------------------------------+---------------------------------------+
  | Tel : +49 (0) 7824/6628-0     | email    : support@rw-gmbh.de         |
  | Fax : +49 (0) 7824/6628-29    | Internet : http://www.rw-gmbh.de      |
  +-------------------------------+---------------------------------------+
  | Project     : MCUG3 TOOLSET   | Compiler : BORLAND C++ Builder        |
  |                               |            MICROSOFT Visual C++       |
  | Module name : mcug3.h         | Operating System:                     |
  |                               |            - Windows 95/98/Me         |
  |                               |            - Windows NT 4.0           |
  |                               |            - Windows NT Embedded 4.0  |
  |                               |            - Windows 2000             |
  |                               |            - Windows XP               |
  |                               |            - Windows Vista            |
  |                               |            - Windows 7.0              |
  |                               |            - Windows 8.0              |
  +-------------------------------+---------------------------------------+
  | Author : Roesch R.               Date :12/01/2015                     |
  |          Walter M.                                                    |
  +-----------------------------------------------------------------------+
  | Description   : Driver Interface for                                  |
  |                 High-Performance Motion-Control Family Generation 3   |
  |                                                                       |
  |                 Currently supported G3-Controllers:                   |
  |                         MCU-3000 and APCI-8001                        |
  |                         MCU-6000 and APCI-8401                        |
  |                         MCU-3100 and APCI-8008                        |
  |                         MCU-3106 and APCI-8008-STP-EVAI               |
  |                                                                       |
  |                 This file contains all prototypes, definitions and    |
  |                 structures to build a Win32-based application program |
  |                                                                       |
  +-----------------------------------------------------------------------+

    Revision History:
	-----------------
	25.01.2024 	V2-53-138 mw new function ec_chk_option
	21.11.2022	V2-53-135 mw new function rdECdiag
	03.08.2021	V2-53-133 mw new functions wrFilename, wrFile, edFileToRead, ReqSendFileBlock and rdDmesg
	04.08.2020  V2-53-130 mw new function ClearCI added
	17.06.2020 	V2-53-130 mw new function CleanServiceUsers (void)
	30.04.2019	V2-53-121 mw new function CheckRwmosBusy (only for additional diag.)
    08.03.2019	V2-53-120 mw new fuction HeaderToAOut (only for special application)
	09.05.2018 	V2-53-119 mw new functions rdSysVarInt, rdSysVarDbl, wrSysVarInt, wrSysVarDbl,
	                                       rdAxVarInt, rdAxVarDbl, wrAxVarInt, wrAxVarDbl
	31.08.2017	V2-53-115 mw new functions rdPcapIndex, VelToAOut, SelectTable
	25.07.2016	V2-53-113 mw new function: sstvl
	22.04.2016	V2-53-112 mw new functions: spda, spdr
	17.03.2016	V2-53-111 mw new functions: rdShortProfile, wrShortProfile
							 threshold Profile length for NoTriangle (default 5.0)
	26.11.2015  V2-53-109 mw new functions: rdVBError, wrVBError for Velocity-Blending
	22.04.2015 	V2-53-108 mw new function: wrtrac, wrtrvl, wrtrtvl, rdtrac, rdtrvl, rdtrtvl
	10.02.2015	V2-53-105 mw DLLAccessConflict endgltig entfernt
    15.01.2015  V2-53-105 rr new function InitMcuSystem4, cleanups
    10.11.2014  V2-53-100 mw new function SendReqScannerBuffer
                             requires rwmos V2.5.3.123
    31.10.2013  V2-53-90 mw new function rdpeaux requires rwmos V2.5.3.117
    11.06.2012  V2-53-85 rr new AT-DataType ATDataBoolean
                            ECBUS, TcBus and CotBus added
    21.04.2011  V2-53-80 mw new prototype for rddigof
                            command can be used as fast alternative for rddigo
                            but is working only for the first axis of every axis group
                            eg. MCU-3000 axis index must be 0, 3 or 6
    15.03.2011  V2-53-79 mw new function RPtoDP
    08.04.2009  V2-53-68 mw new function ssfi
    06.03.2009  V2-53-64 mw new function smlai and smlri
    20.02.2009  V2-53-63 mw new functions wrci_ and ClearCI99 added
    05.01.2009  V2-53-62 mw new function rddvoffset und wrdvoffset added
    22.01.2008  V2-53-58 mw new functions rdaxstf and rdauxf
                            Fast access per direct memory read
                            attention: rdaxstf only use for display,
                            not for control directly after movement commands
    16.01.2008  V2-53-57 mw function rdUsTimer24b for time measuring opened
    04.01.2008  V2-53-57 mw new functions rdgfaux and wrgfaux
    12.12.2007  V2-53-56 mw rdifs now returns zero, if function sucessfully has been executed
                            up to now the function hasn't any return value
    10.12.2007  V2-53-56 mw New Functions wrtrovrst, rdrtrovrst added
                            for handling of trovr settling time
    10/10/2007  V2-53-54 mw new function: rdSampleTimeExpansion + wrSampleTimeExpansion
    14/09/2007  V2-53-51 mw new functions rdDLLAccessConflicts() resDLLAccessConflicts()
                            and SelectedCard() 
    31/08/2007  V2-53-51 mw functions for Trace Handling added
    01/08/2007  V2-53-49 mw wrMcug3Handshake new
    23/03/2007  V2-53-46 mw parameter changed at functions
                            rdrv, getcnctsrclinenr, getmsgstr, getcnctfh, burnaplpar, gettimers, cm
                            Attention: incompatibillity is possible
    12.02.2007  V2-53-43 mw new functions: wrElCamTable32 and wrElCamTable64
                            for direct loading ElCAM-Tables
    10/01/2007  V2-53-42 mw new AT-DataType ATDataBlock
    14/12/2006  V2-53-42 mw new function: ssfn - Definition of axis per AS-structure
    07/10/2006  V2-53-41 mw new functions: rdSplineBlockSize and wrSplineBlockSize
    18/10/2005  V2-53-34 mw new function: rdptp, rdpir, rddtv
    13/10/2005  V2-53-33 mw new functions: rdtrjerk, wrtrjerk
    07/10/2005  V2-53-33 mw new function: rdZeroOffset
    26/07/2005  V2-53-30 mw new functions rddpoffset and wrdpoffset
    04/07/2005  V2-53-28 mw declaration of rdOsVersion has been changed
                            function rdNumDigIO added
!!! 22/06/2005  V2-53-26 mw declaration of gettskstr changed
    24/05/2005  V2-53-26 mw new function gettskinfo()
    19/05/2005  V2-53-26 mw new function gettskstr()
    31/03/2005  V2-53-25 mw new function getEnvStr()
    30/03/2005  V2-53-25 mw new function accstop()
    03/01/2005  V2-53-23 mw new functions rdslsp() and wrslsp()
    17/12/2004  V2-53-22 mw function prototype for ssf() has been wrong
    16/06/2004  V2-53-16 mw new function rdlmcpr(), for reading latched mcp
                            registers added
    15/06/2004  V2-53-15 mw new functions rdOsVersion(), rdControllerFlags()
                            and wrControllerFlags() added
    01/06/2004  V2-53-14 mw functions rdnfrax(), wrnfrax() added
    21/05/2004  V2-53-12 mw Bit ref in AXST new
    17/05/2004  V2-53-11 mw Structure for reading Grapic Analyze Data
                            GRFFILEDATA added
    30/04/2004  V2-53-10 mw new functions: rdDriverVersion, allocPhysMem, freePhysMem
    30/01/2004  V2-53   mw  new functions: rdrv, clv
    30/10/2003  V2-53   mw  new functions: wrErrorReg, rdErrorReg
    22/09/2003  V2-52   mw  New functions: rdJerk, wrJerk
    08/09/2003  V2-52   mw  new functions: wrEffRadius, rdEffRadius
                            for rotatoric Axis
    13/08/2003  V2-52   mw  New possibility to select a Card in a system with more than
                            one cards with CardSelect
    18/07/2003  V2-52   mw  new functions: wrGCR, rdGCR, wrSpecFunc, rdSpecFunc
    16/07/2003  V2-52   mw  function rdPE renamed to rdPosErr
    30/04/2003  V2-52   mw  new functions: wrMaxAcc, rdMaxAcc
    10/03/2003  V2-52   rr  new function: rdPldVersion
    10/03/2003  V2-52   mw  New function: MsgToScreen - possibility to supress
                            Screen-Messages (Message Boxes)
    17/02/2003  V2-52   mw  new functions: wrMaxVel, rdMaxVel
    04/12/2002  V2-52   mw  commands and types for 3D-Circular-Moves added
    07/10/2002  V2-52   mw  szpa and szpr new (set zero Position absolut / relativ)
    08/08/2002  V2-52   mw  enumerations of data-types for OptionDescriptorObject
    23/04/2002  V2-51   mw  new functions: rdPE, rdMCiS
                            to read Position-Error and Move-Commands-in-Spooler added
    16/04/2002  V2-51   mw  new functions: rdModeReg, wrModeReg, wrMDVel, rdMDVel
                            for LookAhead and velocity-skip feautures added
    05/03/2001  V2-51   rr  MCU3400 (new CompactPCI controller) enumeration added
    11/12/2001  V2-51   rr  - wrOption(), rdOption() 
                              renamed to wrOptionInt(), rdOptionInt()
                            - wrOptionDbl(), rdOptionDbl() added
    03/12/2001  V2-51   rr  - struct OptionDescriptorObject, 
                              wrOption(), rdOption() and freeOptionHandle() added
                            - Scanner functions:
                                rdScannerBufferSize(), rdScannerStatus(),
                                rdScannerLsm() and rdScannerBuffer() added
    31/08/2001  V2-50   mw  Spline functions
                            LdSSplineA, LdSSplineR, ExeSSpline added
    02/07/2001  V2-50   rr  removed stepcnct2
    15/03/2001  V2-50   rr  MCUG3CALLBACK Macro added.
                            Functions: MCUG3_SetBoardIntRoutine(),
                            MCUG3_ResetBoardIntRoutine()
                            and MCUG3_SetIntMask() added.
    09/03/2001  V2-50   rr  BootErrorReport() added
    07/03/2001  V2-50   rr  client and application specific structures added
    06/03/2001  V2-50   rr  language specific macros modified
    02/03/2001  V2-50   rr  created from MCU-G2 TOOLSET

*/


#ifndef mcug3H
#define mcug3H

/*
  +-----------------------------------------------------------------------+
  | Language specific macro definitions ...                               |
  +-----------------------------------------------------------------------+
*/
#ifndef dllfuncH
    #ifdef __cplusplus
        #define DLLFUNCW32  extern "C"
        #define DLLFUNC     _stdcall
    #else
        #define DLLFUNCW32
        #define DLLFUNC     _stdcall
    #endif


#endif
#if defined(__BORLANDC__) || (_MSC_VER >= 800) || defined (_CVI_) || defined(_STDCALL_SUPPORTED)
    #define MCUG3CALLBACK __stdcall
#endif


/*
  +-----------------------------------------------------------------------+
  | Definitions, structures, unions and enumerations ...                  |
  +-----------------------------------------------------------------------+
*/

#define MAXAXIS         18      /* currently maximum supplied number of axis, do not change !!! */
#define SIZE_STRREV     40      /* String-Size definition */
#define SIZE_CIBUF      1000    /* Number of elements in common integer buffer */
#define SIZE_CDBUF      1000    /* Number of elements in common double buffer */
#define BSIZE           1024    /* Size of System File Header and CNC File Header */
#define SIZE_FILENAMES  256     /* Max. (char) Size for Filenames */
#define SIZE_TIME       32      /* Size (char) of System time information */
#define SCPSZ_R         15      /* row size for CTRLRPARAMS */
#define SCPSZ_C         15      /* colomn size for CTRLRPARAMS*/
#define SPD2D_S         10      /* size of SPD2D datas */

/* Enumeration for Position units */
typedef enum    {MM, INCH, M, REV, DEG,
                 RAD, COUNTS, STEPS, LAST_PU   } PUS;
/* Enumeration for Time units */
typedef enum    {SEC, MIN, TSAMPLE, LAST_TU    } TUS;

/* Enumeration for MCU-G3 Board Types */
typedef enum
{
    UNKNOWNBOARD = 0x0,         /* unknown board type */
    MCU3000      = 0x4,         /* G3-Controller MCU-3000 */
    APCI8001     = 0x4,         /* G3-Controller APCI-8001 */
    MCU6000      = 0x8,         /* G3-Controller MCU-6000 */
    APCI8401     = 0x8,         /* G3-Controller APCI-8401 */
    MCU3400      = 0x10,        /* G3-Controller MCU-3400 (Compact PCI) */
    CPCI8001     = 0x10,        /* G3-Controller CPCI8001 */
    MCU3100      = 0x20,        /* G3-Controller MCU-3100 */
    APCI8008     = 0x20         /* G3-Controller APCI-8008 */
} BOARDTYPE;

#pragma pack(4)
union AXST
{
    int status_word;
    struct {
        /* axst: Error- & Status-Bits */
        unsigned toasm  : 1;    /* Bit 0:  MCU-6000, APCI-8401 only, MCU-3000 / APCI-8001 = 0 */
        unsigned eo     : 1;    /* Bit 1:  Emergency out */
        unsigned dnr    : 1;    /* Bit 2:  Drive not ready */
        unsigned lslh   : 1;    /* Bit 3:  Limit switch left hardware */
        unsigned lsrh   : 1;    /* Bit 4:  Limit switch right hardware */
        unsigned lsls   : 1;    /* Bit 5:  Limit switch left software */
        unsigned lsrs   : 1;    /* Bit 6:  Limit switch right software */
        unsigned mpe    : 1;    /* Bit 7:  Maximum Position Error */
        unsigned dhef   : 1;    /* Bit 8:  data handling error flag */
        unsigned cef    : 1;    /* Bit 9:  configuration error flag */
        unsigned nc     : 2;    /* Bit 10..11: currently not used */

        /* Status-Bits */
        unsigned pe     : 1;    /* Bit 12: Profile end */
        unsigned cl     : 1;    /* Bit 13: Closed loop */
        unsigned ip     : 1;    /* Bit 14: In Position */
        unsigned ui     : 1;    /* Bit 15: user input */
        unsigned lpsf   : 1;    /* Bit 16: latched position synchronous flag */
        unsigned ref    : 1;    /* Bit 17: Axis is referenced (per SHP) */
        unsigned refhw  : 1;    /* Bit 18: REF HW Input is active */
        unsigned saf    : 1;    /* Bit 19: Spooler asyncronous flag */
		unsigned piins 	: 1;	/* Bit 20: PcapIndex In not sequential 10:0000 */
		unsigned pions 	: 1;	/* Bit 21: PcapIndex Out not sequential 20:0000 */
        unsigned temp2  : 8;   /* Bit 20..29: currently not used */
        
        unsigned        : 2;    /* Bit 30..31: for internal use only */
    } bit;
};

struct TSRP
{
    /* Common-Data for DLL-interface-driver MCUG3.DLL and PC-Application-Program(s) */
    int     an;             /* Axis-Number */
    double      kp;             /* PIDF filter parameter kp */
    double      ki;             /* PIDF filter parameter ki */
    double      kd;             /* PIDF filter parameter kd */
    double      kpl;            /* PIDF filter parameter kpl */
    double      kfca;           /* PIDF forward compensation acceleration */
    double      kfcv;           /* PIDF forward compensation velocity */
    double      jac;            /* jog acceleration */
    double      jvl;            /* jog velocity */
    double      jtvl;           /* target velocity */
    double      jovr;           /* jog override */
    double      hac;            /* home acceleration */
    double      hvl;            /* home velocity */
    double      rp;             /* real position */
    double      dp;             /* desired position */
    double      tp;             /* target position */
    double      dv;             /* desired velocity */
    double      lp;             /* latched postion */
    double      aux;            /* auxilary value */
    double      sll;            /* software limit left */
    double      slr;            /* software limit right */
    double      ipw;            /* in position window */
    double      mpe;            /* maximum position error */
    double      sdec;           /* stop deceleration */
    double      gf;             /* gear factor */
    int         mcp;            /* motor command port */
    union AXST  axst;           /* axis status  */
    int         lsm;            /* left spool memory */
    
    int         epc;            /* eeprom programming cycle */
    int         digi;           /* dig. inputs = asmi (MCU-6000, APCI-8401) */
    int         digo;           /* dig outputs = asmo (MCU-6000, APCI-8401)*/
    int         ifs;            /* interface status = asms (MCU-6000, APCI-8401) */
        
    int         scratch[4];     /* reserved space don't delete!! */
};

struct AS {
    /* Axis-Selection */
    int         unoa;           /* Number of used axis */
    int         san[MAXAXIS];   /* Axis Numbers */
};                              
    
struct TRU {                    
    /* Trajectory Units */      
    int         pu;             /* position unit, see enumeration PUS above */
    int         tu;             /* time unit, see enumeration TUS above */
};

struct LMP {
    /* Linear Motion Profile parameters */
    double      ac;             /* trajectory acceleration  */
    double      vl;             /* trajectory velocity */
    double      tvl;            /* trajectory target velocity */
    double      dtm[MAXAXIS];   /* distance to move */
};

struct CMP {
    /* Circular Motion Profile parameters */
    double      ac;             /* trajectory acceleration  */
    double      vl;             /* trajectory velocity */
    double      tvl;            /* trajectory target velocity */
    double      phi;            /* angel phi */
    double      dtca1;          /* center point of axis 1 */
    double      dtca2;          /* center point of axis 2 */
};

struct HMP {
    /* Helical Motion Profile parameters */
    double      ac;             /* trajectory acceleration  */
    double      vl;             /* trajectory velocity */
    double      tvl;            /* trajectory target velocity */
    double      phi;            /* angel phi */
    double      dtca1;          /* center point of axis 1 */
    double      dtca2;          /* center point of axis 2 */
    double      dtm[MAXAXIS];   /* distance to move axis 3..n */
};

struct HMP3D {
    /* 3D Circular and Helical Motion Profile parameters */
    double      ac;         /* trajectory acceleration  */
    double      vl;         /* trajectory velocity */
    double      tvl;            /* trajectory target velocity */
    double      phi;            /* angel phi */
    double      dtca1;          /* center point of axis 1 */
    double      dtca2;          /* center point of axis 2 */
    double      dtca3;          /* center point of axis 3 */
    double      pn1;            /* area perpendicular of axis 1 (Flchen-Normale A1) */
    double      pn2;            /* area perpendicular of axis 2 (Flchen-Normale A2) */
    double      pn3;            /* area perpendicular of axis 3 (Flchen-Normale A3) */
    double      dtma[MAXAXIS];          /* distance to move axis 3..n */
};

struct CNCTS {
    /* CNC-Task Status variables */
    int         ErrNum;         /* error number */
    int         ErrLine;        /* error line */
    int         StackFree;      /* stack bytes free */
    int         Running;        /* nc task running status */
    int         csrcline;       /* current (processed) source line number */
};

struct ROSI
{
    /* RISC Operating System Informations */
    char        revision[SIZE_STRREV];  
                                /* software-revision-string */
    int         Number_Axis;    /* number of supplied axis */
    int         SysFile_Loaded; /* status flag for sysfile already loaded */
};

struct CIBUF
{
    /* Buffer definition for common integer variables */
    int         civals[SIZE_CIBUF]; 
};

struct CDBUF
{
    /* Buffer definition for common double variables */
    double      cdvals[SIZE_CDBUF]; 
};

struct CBCNCT
{
    /* Common CNC-Task buffer */
    int         TaskNr;         /* Task Number 0..3 */
    int         size;           /* size of Buffer [bytes] */
    char        *Buffer;        /* pointer to user allocated buffer */
};

struct SPDBUF
{
    /* position data to spool */
    double      dtm;            /* distance to move */
};

struct SPVTDBUF
{
    /* position, velocity, time datas to spool */
    double      dtm;            /* distance to move */
    double      vl;             /* velocity */
    double      t;              /* time */
};

struct CTRLRPARAMS {
    /* Controller specific data fields (application specicfic) */
    double      val[SCPSZ_R][SCPSZ_C];
};

struct SPD2DPARAMS
{
    int         size;           /* size */
    int         san[2];         /* selected axis numbers */
    double      dtma1[SPD2D_S]; /* distance(s) to move axis 1 */
    double      dtma2[SPD2D_S]; /* ditsance(s) to move axis 2 */
};

struct LATCH_INFOS
{
    /* parameter set for latching position datas */
    int         san;            /* selected axis number */
    double      lst;            /* latch start time (e.g. 0) */
    double      let;            /* latch end time (e.g. 1) */
    int         pu;             /* position unit (see enum PUS) */
    int         tu;             /* time unit (see enum TUS) */
};

/* Datenstruktur zum einlesen der Grafikanalyse */
struct GRFFILEDATA {
    char Header[256];
    int  EndOfFile;
    struct LATCH_INFOS  li;

    double RPBuffer[1000];
    double DPBuffer[1000];
};

struct OLSR_INFOS {
    /* parameter set for open loop system response */
    int         san;            /* selected axis number */
    double      delay;          /* delay [s] */
    double      mcp;            /* motor command value [V] */
};

struct FILEHEADER
{
    /* CNC Task File Header Information */
    int         TaskNr;         /* NC-File runs in task 'TaskNr' 0..3 */
    char        SrcFileName[SIZE_FILENAMES];    
                                /* CNC Source File Name */
    char        CncFileName[SIZE_FILENAMES];    
                                /* CNC pseudo code file name */
    char        RevNr[SIZE_STRREV];             
                                /* revision number */
    char        DateTime[SIZE_TIME];            
                                /* build date and time information */
};

struct OptionDescriptorObject
{
    unsigned    Handle;         /* do not change that! */
    unsigned    AccessType;     /* Read, Write, Flag */
    unsigned    DataType;       /* Byte, Word, Double Word, Real, ... */
    unsigned    BusNumber;      /* Interbus, Canbus, G3-Resourcebus, Scannerbus ... */
    unsigned    DeviceNumber;   /* depends on Bus Type */
    unsigned    Index;          /* depends on Bus Type */
    unsigned    SubIndex;       /* depends on Bus Type */
}; 

enum ATAccessType {ATAccessNone, ATAccessInput, ATAccessOutput, ATAccessInputOutput};
enum ATDataType   {ATDataNone,   ATDataByte,    ATDataWord,     ATDataDoubleWord, ATDataReal, ATDataSingle, ATDataBlock, ATDataBoolean, ATDataBuffer, ATDataInt64};
enum ATBusNr {
    PciBusIO        = 100,
    PciBusMEM       = 200,
    CanOpenBus      = 400,
    InterBus        = 500,
    ECBus           = 600,
    ResourcenBus    = 1000,
    ScannerBus      = 1100,
    ElCamBus        = 1200,
    TcBus           = 1300,
    CotBus          = 2000
};

#pragma pack()

/*
  +-----------------------------------------------------------------------+
  | Prototypes standard functions,                                        |
  | functions are described in MCU-G3 Programming Manual                  |
  +-----------------------------------------------------------------------+
*/

DLLFUNCW32 void DLLFUNC uf                  (struct TSRP *tsrp);                /* update filter */
DLLFUNCW32 void DLLFUNC ctru                (struct TRU  *tru);                 /* change trajectory units */
DLLFUNCW32 void DLLFUNC wrjac               (struct TSRP *tsrp);                /* write jog acceleration */
DLLFUNCW32 void DLLFUNC wrjvl               (struct TSRP *tsrp);                /* write jog velocity */
DLLFUNCW32 void DLLFUNC wrjtvl              (struct TSRP *tsrp);                /* write jog target velocity */
DLLFUNCW32 void DLLFUNC wrhac               (struct TSRP *tsrp);                /* write home acceleration */
DLLFUNCW32 void DLLFUNC wrhvl               (struct TSRP *tsrp);                /* write home velocity */
DLLFUNCW32 void DLLFUNC wrrp                (struct TSRP *tsrp);                /* write real position */
DLLFUNCW32 void DLLFUNC wrdp                (struct TSRP *tsrp);                /* write desired position */
DLLFUNCW32 void DLLFUNC wrlp                (struct TSRP *tsrp);                /* write latched position */
DLLFUNCW32 void DLLFUNC wraux               (struct TSRP *tsrp);                /* write auxiliary value */
DLLFUNCW32 void DLLFUNC shp                 (struct TSRP *tsrp);                /* set home position */
DLLFUNCW32 void DLLFUNC wrdigo              (struct TSRP *tsrp);                /* MCU-3000, APCI-8001 only: write digital outputs */
DLLFUNCW32 void DLLFUNC wrdigob             (int an, int bitnr, int value);     /* MCU-3000, APCI-8001 only: write digital output bit */
DLLFUNCW32 void DLLFUNC wrasmo              (struct TSRP *tsrp);                /* MCU-6000, APCI-8401 only: write ASM digital outputs */
DLLFUNCW32 void DLLFUNC wrasmob             (int an, int bitnr, int value);     /* MCU-6000, APCI-8401 only: write ASM digital output bit */
DLLFUNCW32 void DLLFUNC rdrp                (struct TSRP *tsrp);                /* read real position */
DLLFUNCW32 void DLLFUNC rddp                (struct TSRP *tsrp);                /* read desired position */
DLLFUNCW32 void DLLFUNC rdtp                (struct TSRP *tsrp);                /* read target position */
DLLFUNCW32 void DLLFUNC rddv                (struct TSRP *tsrp);                /* read desired velocity */
DLLFUNCW32 void DLLFUNC rdlp                (struct TSRP *tsrp);                /* read latched position */
DLLFUNCW32 void DLLFUNC rdaux               (struct TSRP *tsrp);                /* read auxiliary value */
DLLFUNCW32 void DLLFUNC rdauxf              (struct TSRP *tsrp);                /* read auxiliary value fast */
DLLFUNCW32 void DLLFUNC rddigi              (struct TSRP *tsrp);                /* MCU-3000, APCI-8001 only: read digital inputs */
DLLFUNCW32 int  DLLFUNC rddigib             (int an, int bitnr);                /* MCU-3000, APCI-8001 only: read digital input bit */
DLLFUNCW32 int  DLLFUNC rdifs               (struct TSRP *tsrp);                /* MCU-3000, APCI-8001 only: read interface status */
DLLFUNCW32 int  DLLFUNC rdifsb              (int an, int bitnr);                /* MCU-3000, APCI-8001 only: read interface status bit */
DLLFUNCW32 void DLLFUNC rddigo              (struct TSRP *tsrp);                /* MCU-3000, APCI-8001 only: read digital outputs */
DLLFUNCW32 void DLLFUNC rddigof             (struct TSRP *tsrp);                /* MCU-3000, APCI-8001 only: read digital outputs direct: respect comment in header */
DLLFUNCW32 int  DLLFUNC rddigob             (int an, int bitnr);                /* MCU-3000, APCI-8001 only: read digital output bit */
DLLFUNCW32 void DLLFUNC rdasmi              (struct TSRP *tsrp);                /* MCU-6000, APCI-8401 only: read ASM digital inputs */
DLLFUNCW32 int  DLLFUNC rdasmib             (int an, int bitnr);                /* MCU-6000, APCI-8401 only: read ASM digital input bit */
DLLFUNCW32 void DLLFUNC rdasms              (struct TSRP *tsrp);                /* MCU-6000, APCI-8401 only: read ASM status */
DLLFUNCW32 int  DLLFUNC rdasmsb             (int an, int bitnr);                /* MCU-6000, APCI-8401 only: read ASM status bit */
DLLFUNCW32 void DLLFUNC rdepc               (struct TSRP *tsrp);                /* MCU-6000, APCI-8401 only: read eeprom programming cycle */
DLLFUNCW32 void DLLFUNC rdasmepc            (struct TSRP *tsrp);                /* MCU-6000, APCI-8401 only: read ASM eeprom programming cycle */
DLLFUNCW32 void DLLFUNC rdasmo              (struct TSRP *tsrp);                /* MCU-6000, APCI-8401 only: read ASM digital outputs */
DLLFUNCW32 int  DLLFUNC rdasmob             (int an, int bitnr);                /* MCU-6000, APCI-8401 only: read ASM digital output bit */
DLLFUNCW32 void DLLFUNC rdlsm               (struct TSRP *tsrp);                /* read left spool memory */
DLLFUNCW32 void DLLFUNC rdaxst              (struct TSRP *tsrp);                /* read axis status */
DLLFUNCW32 void DLLFUNC rdaxstf             (struct TSRP *tsrp);                /* read axis status fast */
DLLFUNCW32 int  DLLFUNC rdaxstb             (int an, int bitnr);                /* read axis status bit */
DLLFUNCW32 void DLLFUNC rdjac               (struct TSRP *tsrp);                /* read jog acceleration */
DLLFUNCW32 void DLLFUNC rdjvl               (struct TSRP *tsrp);                /* read jog velocity */
DLLFUNCW32 void DLLFUNC rdjtvl              (struct TSRP *tsrp);                /* read jog target velocity */
DLLFUNCW32 void DLLFUNC rdhac               (struct TSRP *tsrp);                /* read home acceleration */
DLLFUNCW32 void DLLFUNC rdhvl               (struct TSRP *tsrp);                /* read home velocity */
DLLFUNCW32 void DLLFUNC cl                  (struct AS *as);                    /* close loop */
DLLFUNCW32 void DLLFUNC clv                 (struct AS *as);                    /* close loop velocity */
DLLFUNCW32 void DLLFUNC ol                  (struct AS *as);                    /* open loop */
DLLFUNCW32 void DLLFUNC ra                  (struct AS *as);                    /* reset axis */
DLLFUNCW32 void DLLFUNC rifs                (struct TSRP *tsrp);                /* MCU-3000, APCI-8001 only: reset interface status flags */
DLLFUNCW32 void DLLFUNC rasms               (struct TSRP *tsrp);                /* MCU-6000, APCI-8401 only: reset ASM status flags */
DLLFUNCW32 void DLLFUNC rs                  (void);                             /* reset system */
DLLFUNCW32 void DLLFUNC azo                 (int set);                          /* activate zero offset */
DLLFUNCW32 void DLLFUNC jr                  (struct AS *as, struct TSRP *tsrp); /* jog relative */
DLLFUNCW32 void DLLFUNC ja                  (struct AS *as, struct TSRP *tsrp); /* jog absolute */
DLLFUNCW32 void DLLFUNC jhl                 (struct AS *as);                    /* jog home left */
DLLFUNCW32 void DLLFUNC jhr                 (struct AS *as);                    /* jog home right */
DLLFUNCW32 void DLLFUNC jhi                 (struct AS *as, struct TSRP *tsrp); /* jog relative (to) index */
DLLFUNCW32 void DLLFUNC mlr                 (struct AS *as, struct LMP *lmp);   /* move linear relative */
DLLFUNCW32 void DLLFUNC mla                 (struct AS *as, struct LMP *lmp);   /* move linear absolute */
DLLFUNCW32 void DLLFUNC mcr                 (struct AS *as, struct CMP *cmp);   /* move circular relative */
DLLFUNCW32 void DLLFUNC mca                 (struct AS *as, struct CMP *cmp);   /* move circular absolute */
DLLFUNCW32 void DLLFUNC mhr                 (struct AS *as, struct HMP *hmp);   /* move helix relative */
DLLFUNCW32 void DLLFUNC mha                 (struct AS *as, struct HMP *hmp);   /* move helix absolute */
DLLFUNCW32 void DLLFUNC mca3d               (struct AS *as, struct HMP3D *hmp3d); /* move 3D-circular-absolute */
DLLFUNCW32 void DLLFUNC mcr3d               (struct AS *as, struct HMP3D *hmp3d); /* move 3D-circular-relative */
DLLFUNCW32 void DLLFUNC smca3d              (struct AS *as, struct HMP3D *hmp3d); /* move spooled 3D-circular-absolute */
DLLFUNCW32 void DLLFUNC smcr3d              (struct AS *as, struct HMP3D *hmp3d); /* move spooled 3D-circular-relative */

DLLFUNCW32 void DLLFUNC smlr                (struct AS *as, struct LMP *lmp);   /* spool motion linear relative */
DLLFUNCW32 void DLLFUNC smlri               (struct AS *as, struct LMP *lmp, int PcapIndex);
                                                                                /* spool motion linear relative indicated */
DLLFUNCW32 void DLLFUNC smla                (struct AS *as, struct LMP *lmp);   /* spool motion linear absolute */
DLLFUNCW32 void DLLFUNC smlai               (struct AS *as, struct LMP *lmp, int PcapIndex);
                                                                                /* spool motion linear absolute indicated */
DLLFUNCW32 void DLLFUNC smcr                (struct AS *as, struct CMP *cmp);   /* spool motion circular relative */
DLLFUNCW32 void DLLFUNC smca                (struct AS *as, struct CMP *cmp);   /* spool motion circular absolute */
DLLFUNCW32 void DLLFUNC smhr                (struct AS *as, struct HMP *hmp);   /* spool motion helix relative */
DLLFUNCW32 void DLLFUNC smha                (struct AS *as, struct HMP *hmp);   /* spool motion helix absolute */
DLLFUNCW32 void DLLFUNC ssms                (struct AS *as);                    /* start spooled motions synchronous */
DLLFUNCW32 void DLLFUNC sstps               (struct AS *as);                    /* stop spooled motions synchronous */
DLLFUNCW32 void DLLFUNC sdels               (struct AS *as);                    /* delete spooled motions synchronous */
DLLFUNCW32 int  DLLFUNC txbf                (char *filename);                   /* transmit binary file */
DLLFUNCW32 int  DLLFUNC txbf2               (char *filename);                   /* transmit binary file, 2nd method */
DLLFUNCW32 void DLLFUNC startcnct           (int TaskNr);                       /* start cnc task */
DLLFUNCW32 void DLLFUNC stopcnct            (int TaskNr);                       /* stop cnc task */
DLLFUNCW32 void DLLFUNC contcnct            (int TaskNr);                       /* continue cnc task */
DLLFUNCW32 void DLLFUNC stepcnct            (int TaskNr);                       /* step cnc task */
DLLFUNCW32 void DLLFUNC rdcncts             (int TaskNr, struct CNCTS *cncts);  /* read cnc task status */
DLLFUNCW32 int  DLLFUNC rdcbcnct            (struct CBCNCT *cbcnct);            /* read cnc task spec. common buffer */
DLLFUNCW32 int  DLLFUNC wrcbcnct            (struct CBCNCT *cbcnct);            /* write cnc task spec. common buffer */
DLLFUNCW32 void DLLFUNC rdci                (int ndx, struct CIBUF *cibuf);     /* read common integer */
DLLFUNCW32 void DLLFUNC rdcd                (int ndx, struct CDBUF *cdbuf);     /* read common double */
DLLFUNCW32 void DLLFUNC wrci                (int ndx, struct CIBUF *cibuf);     /* write common integer variables */
DLLFUNCW32 void DLLFUNC wrci_               (int ndx, struct CIBUF *cibuf);     /* write common integer variables per Communication (slower) */
DLLFUNCW32 void DLLFUNC wrcd                (int ndx, struct CDBUF *cdbuf);     /* write common double variables */
DLLFUNCW32 void DLLFUNC rdmcp               (struct TSRP *tsrp);                /* read motor command port */
DLLFUNCW32 void DLLFUNC wrmcp               (struct TSRP *tsrp);                /* write motor command port */
DLLFUNCW32 void DLLFUNC wrledrd             (int value);                        /* write led red */
DLLFUNCW32 void DLLFUNC wrledyl             (int value);                        /* write led yellow */
DLLFUNCW32 void DLLFUNC wrledgn             (int value);                        /* write led green */
DLLFUNCW32 int  DLLFUNC rdledrd             (void);                             /* read led red */
DLLFUNCW32 int  DLLFUNC rdledyl             (void);                             /* read led yellow */
DLLFUNCW32 int  DLLFUNC rdledgn             (void);                             /* read led green */
DLLFUNCW32 int  DLLFUNC rdirqpc             (void);                             /* read irq pc */
DLLFUNCW32 int  DLLFUNC mcuinit             (struct ROSI *rosi);                /* MCU-G3 initialisition */
DLLFUNCW32 int  DLLFUNC mcuinit2            (struct ROSI *rosi, int TpuBaseAddress);
                                                                                /* MCU-G3 initialisition, 2nd method */
DLLFUNCW32 void DLLFUNC wrjovr              (struct TSRP *tsrp);                /* write jog override */
DLLFUNCW32 void DLLFUNC rdjovr              (struct TSRP *tsrp);                /* read jog override */
DLLFUNCW32 void DLLFUNC wrtrovr             (double *value);                    /* write trajectory override */
DLLFUNCW32 void DLLFUNC rdtrovr             (double *value);                    /* read trajectory override */
DLLFUNCW32 int  DLLFUNC wrtrovrst           (double *value);                    /* write trajectory override settling time */
DLLFUNCW32 int  DLLFUNC rdtrovrst           (double *value);                    /* read trajectory override settling time */
DLLFUNCW32 int  DLLFUNC wrShortProfile      (double *value);                    /* write System Var ShortProfile - threshold profile length for NoTriangle */
DLLFUNCW32 int  DLLFUNC rdShortProfile      (double *value);                    /* read System Var ShortProfile - threshold profile length for NoTriangle */
DLLFUNCW32 void DLLFUNC utrovr              (struct AS *as);                    /* update trajectory override */
DLLFUNCW32 void DLLFUNC rdf                 (struct TSRP *tsrp);                /* read filter */
DLLFUNCW32 void DLLFUNC rdap                (struct TSRP *tsrp);                /* read axis parameters */
DLLFUNCW32 void DLLFUNC rdsll               (struct TSRP *tsrp);                /* read software limit left */
DLLFUNCW32 void DLLFUNC wrsll               (struct TSRP *tsrp);                /* write software limit left */
DLLFUNCW32 void DLLFUNC rdslr               (struct TSRP *tsrp);                /* read software limit right */
DLLFUNCW32 void DLLFUNC wrslr               (struct TSRP *tsrp);                /* write software limit right */
DLLFUNCW32 void DLLFUNC rdipw               (struct TSRP *tsrp);                /* read in position window */
DLLFUNCW32 void DLLFUNC wripw               (struct TSRP *tsrp);                /* write in position window */
DLLFUNCW32 void DLLFUNC rdmpe               (struct TSRP *tsrp);                /* read maximum position error */
DLLFUNCW32 void DLLFUNC wrmpe               (struct TSRP *tsrp);                /* write maximum position error */
DLLFUNCW32 void DLLFUNC rdsdec              (struct TSRP *tsrp);                /* read stop deceleration */
DLLFUNCW32 void DLLFUNC wrsdec              (struct TSRP *tsrp);                /* write stop deceleration */
DLLFUNCW32 void DLLFUNC spd                 (int an, int size, struct SPDBUF *spdbuf);			/* spool position data */
DLLFUNCW32 void DLLFUNC spda(int an, int size, struct SPDBUF *spdbuf, long PcapIndex);		/* spool position data absolut indicated */
DLLFUNCW32 void DLLFUNC spdr(int an, int size, struct SPDBUF *spdbuf, long PcapIndex);     /* spool position data relative indicated */
DLLFUNCW32 void DLLFUNC sstvl                (struct AS *as, double tvl);       /* spooler set target velocity */


DLLFUNCW32 void DLLFUNC wrgf                (struct TSRP *tsrp);                /* write gear factor */
DLLFUNCW32 void DLLFUNC rdgf                (struct TSRP *tsrp);                /* read gear factor */
DLLFUNCW32 void DLLFUNC spvtd               (int an, int size, struct SPVTDBUF *spvtdbuf);
                                                                                /* spool position, veloctiy, time data */
DLLFUNCW32 void DLLFUNC ms                  (struct AS *as);                    /* motion stop */
DLLFUNCW32 void DLLFUNC js                  (struct AS *as);                    /* jog stop */
DLLFUNCW32 void DLLFUNC lps                 (int an, int mst);                  /* latch position synchronous */
DLLFUNCW32 void DLLFUNC rdigi               (struct TSRP *tsrp);                /* MCU-3000, APCI-8001 only: reset digital inputs */
DLLFUNCW32 void DLLFUNC rdlpndx             (struct TSRP *tsrp);                /* MCU-3000, APCI-8001 only: read latched position index */
DLLFUNCW32 void DLLFUNC wrlpndx             (struct TSRP *tsrp);                /* MCU-3000, APCI-8001 only: write latched position index */
DLLFUNCW32 void DLLFUNC ssf                 (int an, int command, double value);/* Spooler-Special-Function-Command */
DLLFUNCW32 void DLLFUNC ssfn                (struct AS *as, long command, double value);
                                                                                /* SSF fr mehr als eine Achse */
DLLFUNCW32 void DLLFUNC ssfi                (int an, int command, double value, int PcapIndex);
                                                                                /* Spooler-Special-Function-Command indicated */
DLLFUNCW32 void DLLFUNC ssfni               (struct AS *as, long command, double value, int PcapIndex);
                                                                                /* SSF fr mehr als eine Achse indicated */

DLLFUNCW32 int  DLLFUNC InitMcuSystem       (struct TSRP *tsrp);                /* initialisation function first method, (you should not use this function, instead use InitMcuSystem2() or even better InitMcuSystem3()) */
DLLFUNCW32 int  DLLFUNC InitMcuSystem2      (struct TSRP *tsrp, int TpuBaseAddress, char *SystemFileName);
                                                                                /* initialisation function, 2nd method*/
DLLFUNCW32 int  DLLFUNC InitMcuSystem3      (struct TSRP *tsrp, struct ROSI *rosi, int TpuBaseAddress, char *SystemFileName, int *BoardType);
                                                                                /* initialisation function, 3rd method*/
DLLFUNCW32 int  DLLFUNC InitMcuSystem4      (struct TSRP *tsrp, struct ROSI *rosi, int TpuBaseAddress, char *SystemFileName, int *BoardType, int *NrCards);
                                                                                /* initialisation function, 4th method (method 3 with additional number of cards result) */
DLLFUNCW32 void DLLFUNC InitMcuErrorReport  (int error);                        /* detailed initialisation error report function */
DLLFUNCW32 void DLLFUNC txbfErrorReport     (char *filename, int error);        /* detailed load error report function */
DLLFUNCW32 void DLLFUNC BootErrorReport     (char *filename, int error);        /* detailed boot error report function */
DLLFUNCW32 void DLLFUNC McuClose            (void);                             /* close driver function, must be called at end of program !*/
DLLFUNCW32 int  DLLFUNC BootFile            (char *BootFileName, int TpuBaseAddress);
DLLFUNCW32 int  DLLFUNC BootFileNPC         (char *BootFileName, int TpuBaseAddress); /* BootFile No Platform Check - because Platform check fails at some compilers */
                                                                                /* Send Bootfile (i.e. rwmos.elf) to controller board */
DLLFUNCW32 void DLLFUNC LdSSplineA          (struct AS *as, struct LMP *lmp);   /* Load Spool Spline Data Absolut */
DLLFUNCW32 void DLLFUNC LdSSplineR          (struct AS *as, struct LMP *lmp);   /* Load Spool Spline Data Relativ */
DLLFUNCW32 void DLLFUNC ExeSSpline          (struct AS *as, struct LMP *lmp);   /* Execute Spool Spline */

DLLFUNCW32 int  DLLFUNC wrOptionInt         (struct OptionDescriptorObject *odesc, int *val);
                                                                                /* Option Object write integer function */
DLLFUNCW32 int  DLLFUNC rdOptionInt         (struct OptionDescriptorObject *odesc, int *val);
                                                                                /* Option Object read integer function */
DLLFUNCW32 int  DLLFUNC wrOptionDbl         (struct OptionDescriptorObject *odesc, double *val);
                                                                                /* Option Object write double function */
DLLFUNCW32 int  DLLFUNC rdOptionDbl         (struct OptionDescriptorObject *odesc, double *val);
                                                                                /* Option Object read double function */
DLLFUNCW32 int  DLLFUNC wrOptionBuf         (struct OptionDescriptorObject *odesc, void *val);
																				/* Option Object write Buffer function */
DLLFUNCW32 int  DLLFUNC rdOptionBuf         (struct OptionDescriptorObject *odesc, void *val);
																				/* Option Object read Buffer function */
DLLFUNCW32 int  DLLFUNC freeOptionHandle    (struct OptionDescriptorObject *odesc);
                                                                                /* Option Object free handle */

DLLFUNCW32 int  DLLFUNC rdScannerBufferSize (void);                             /* Read size of scan buffer */
DLLFUNCW32 int  DLLFUNC rdScannerStatus     (void);                             /* read scanner status register */
DLLFUNCW32 int  DLLFUNC rdScannerLsm        (void);                             /* read scanner left spool memory */
DLLFUNCW32 int  DLLFUNC rdScannerBuffer     (char *buffer, int size);           /* read scanner buffer */
DLLFUNCW32 int  DLLFUNC SendReqScannerBuffer (char *buffer, int size);          /* read scanner buffer per Send Request */
DLLFUNCW32 void DLLFUNC CleanServiceData (void);								/* freeing PhysMem in rwPhysMemService (optional) */
DLLFUNCW32 int  DLLFUNC CleanServiceUsers (void);							    /* Reset Number of Users rwPhysMemService */

DLLFUNCW32 void DLLFUNC wrModeReg(long *value);                                 /* write ModeRegister */
DLLFUNCW32 void DLLFUNC rdModeReg(long *value);                                 /* read  ModeRegister */
DLLFUNCW32 void DLLFUNC wrnfrax  (long *value);                                 /* write No-Feed-Rate-Axis */
DLLFUNCW32 void DLLFUNC rdnfrax  (long *value);                                 /* read  No-Feed-Rate-Axis */
DLLFUNCW32 void DLLFUNC wrMDVel(long an, double *value);                        /* write Maximum Delta Velocity */
DLLFUNCW32 void DLLFUNC rdMDVel(long an, double *value);                        /* read  Maximum Delta Velocity */
DLLFUNCW32 void DLLFUNC wrMaxVel(long an, double *value);                       /* write Maximum Axis Velocity */
DLLFUNCW32 void DLLFUNC rdMaxVel(long an, double *value);                       /* read  Maximum Axis Velocity */
DLLFUNCW32 void DLLFUNC wrMaxAcc(long an, double *value);                       /* write Maximum Axis Acceleration */
DLLFUNCW32 void DLLFUNC rdMaxAcc(long an, double *value);                       /* read  Maximum Axis Acceleration */
DLLFUNCW32 void DLLFUNC wrEffRadius(long an, double *value);                    /* write Effective Radius for rotatoric Axis */
DLLFUNCW32 void DLLFUNC rdEffRadius(long an, double *value);                    /* read  Effective Radius for rotatoric Axis */
DLLFUNCW32 void DLLFUNC rdPosErr(long an, double *value);                       /* read  Position Error */
DLLFUNCW32 void DLLFUNC rdMCiS(long an, long *value);                           /* read  Move-Commands-in-Spooler */
DLLFUNCW32 int  DLLFUNC rdZeroOffset(int an, double *value);                    /* read  absolute Value of actual set Zero Offset */
DLLFUNCW32 int  DLLFUNC rdptp(int an, double *value);                           /* read  profile target position */
DLLFUNCW32 int  DLLFUNC rdpir(int *value);                                      /* read  Profile Information Register */
DLLFUNCW32 int  DLLFUNC rddtv(double *value);                                   /* read  desired trajectory velocity */
DLLFUNCW32 int  DLLFUNC rdSampleTimeExpansion(int *value);                      /* read  SampleTimeExpansion Register */
DLLFUNCW32 int  DLLFUNC wrSampleTimeExpansion(int *value);                      /* write  SampleTimeExpansion Register */
DLLFUNCW32 void DLLFUNC RPtoDP (struct AS *as);                                 /* Real Position To Desired Position */
DLLFUNCW32 int  DLLFUNC rdpeaux (int an, double *value);                        /* read difference rp - aux in [UU] */
DLLFUNCW32 int  DLLFUNC wrVBError(int an, double *value);                      /* write Velocity-Blending-Error */
DLLFUNCW32 int  DLLFUNC rdVBError(int an, double *value);                      /* read  Velocity-Blending-Error */
/*
  +---------------------------------------------------------------------------------+
  |    Prototypes for client and application specific functions,                    | 
  |    do not use that functions if you have no information                         |
  |    about the individual functions !!!                                           | 
  |    (normaly you should not need that functions)                                 | 
  +---------------------------------------------------------------------------------+
*/

DLLFUNCW32 void DLLFUNC wrBlk               (char *buffer);                     /* Common Write Command without return value (internal function) */
DLLFUNCW32 int  DLLFUNC rdBlk               (char *buffer);                     /* Common Read Command */
DLLFUNCW32 void DLLFUNC wrtp                (struct TSRP *tsrp);                /* write target position */
DLLFUNCW32 void DLLFUNC rdrpd               (struct TSRP *tsrp);                /* read real position display */
DLLFUNCW32 void DLLFUNC rddpd               (struct TSRP *tsrp);                /* read desired position display */
DLLFUNCW32 void DLLFUNC rdtpd               (struct TSRP *tsrp);                /* read target position display */
DLLFUNCW32 void DLLFUNC scp                 (int an, struct CTRLRPARAMS *ctrlrparams);
                                                                                /* set controller parameters */
DLLFUNCW32 void DLLFUNC rdrv                (int an, double *value);            /* read actual velocity */
DLLFUNCW32 void DLLFUNC cm                  (int an, int *value);               /* change mode */
DLLFUNCW32 void DLLFUNC spd2d               (struct SPD2DPARAMS *);             /* spool position datas 2D */
DLLFUNCW32 void DLLFUNC rdlrpr              (struct LATCH_INFOS *latch_infos, double *buffer);
                                                                                /* read latched real pos. registers */
DLLFUNCW32 void DLLFUNC rdldpr              (struct LATCH_INFOS *latch_infos, double *buffer);
                                                                                /* read latched desired pos. registers */
DLLFUNCW32 void DLLFUNC rdlmcpr             (struct LATCH_INFOS *latch_infos, double *buffer);
                                                                                /* read latched mcp registers */
DLLFUNCW32 void DLLFUNC getcnctsrclinenr    (int TaskNr, int *LineNr);          /* read in current linenumber beeing processed of selected cnc task */
DLLFUNCW32 int  DLLFUNC getmsgstr           (int an, char *result);             /* read in internal MCU-G3 debug-string */
DLLFUNCW32 int  DLLFUNC gettskstr           (int TaskNr, char *buffer, int szbuffer);
                                                                                /* read in internal MCU-G3 Task-string */
DLLFUNCW32 void DLLFUNC getcnctfh           (int TaskNr, struct FILEHEADER *fh);
                                                                                /* read in CNC-task-fileheader of selected cnc task */
DLLFUNCW32 void DLLFUNC burnaplpar          (int an);                           /* burn appliance parameters */
DLLFUNCW32 void DLLFUNC gettimers           (struct TSRP *tsrp, int an);        /* read in several debug-timers of high-prior task */
DLLFUNCW32 void DLLFUNC lpr                 (struct LATCH_INFOS *latch_infos);  /* latch position registers */
DLLFUNCW32 void DLLFUNC lprs                (struct AS *as, struct LATCH_INFOS *latch_infos);
                                                                                /* latch position registers synchronous on several axis */
DLLFUNCW32 void DLLFUNC olsr                (struct OLSR_INFOS *olsr);          /* open loop system response */
DLLFUNCW32 void DLLFUNC rdasmecs            (struct TSRP *tsrp);                /* MCU-6000, APCI-8401 only: read in ASM eprom checksum of firmware */
DLLFUNCW32 void DLLFUNC ReadLinkStatus      (int *fae, int *ba);                /* read current link stati */
DLLFUNCW32 int  DLLFUNC rdAin               (int an, int channel);              /* MCU-3000, APCI-8001 only: read Analog Inputs from OPMF-3001 */
DLLFUNCW32 void DLLFUNC szpa                (int an, double Position);          /* Set Zero Position absolut (virtual zero Point) */
DLLFUNCW32 void DLLFUNC szpr                (int an, double Position);          /* Set Zero Position relativ (virtual zero Point) */

DLLFUNCW32 void DLLFUNC rdMcuStatus(char *buffer, int size);                    /* read in MCU G3 status registers */
DLLFUNCW32 void DLLFUNC rdAsmSecureParams(int an, char *buffer);                /* MCU-6000, APCI-8401 only: read ASM-EEPROM parameters (firmware data) */
DLLFUNCW32 void DLLFUNC wrAsmSecureParams(int an, char *buffer);                /* MCU-6000, APCI-8401 only: write ASM-EEPROM parameters (firmware data) */


typedef void (MCUG3CALLBACK* InterruptRoutine)(int i_IRQLineBits);              /* Callback-Prototyp for User-Interrupt-Handler */
DLLFUNCW32 int DLLFUNC MCUG3_SetBoardIntRoutine(InterruptRoutine func);         /* Install User Interrupt Handler Routine */
DLLFUNCW32 int DLLFUNC MCUG3_ResetBoardIntRoutine(void);                        /* Deinstall User Interrupt Handler Routine */
DLLFUNCW32 int DLLFUNC MCUG3_SetIntMask(int i_IRQMaskBits);                     /* Set Interrupt Mask Register */

DLLFUNCW32 void DLLFUNC MsgToScreen (long Enable);                              /* enable / disable screen messages */
DLLFUNCW32 int  DLLFUNC rdPldVersion(int *value);                               /* read PLD version number */
DLLFUNCW32 int  DLLFUNC rdOsVersion(int *value);                                /* read Operation System version number */
DLLFUNCW32 int DLLFUNC wrCmdLine(char *cmdline);								/* transferring Linux Cmd over rwmos */
DLLFUNCW32 int DLLFUNC wrCmdLineX(char *cmdline);

DLLFUNCW32 void DLLFUNC wrGCR(long an, long *value);                            /* write  GCR-Register */
DLLFUNCW32 void DLLFUNC rdGCR(long an, long *value);                            /* read  GCR-Register */
DLLFUNCW32 void DLLFUNC wrSpecFunc(long an, long *value);                       /* write  Special-Function-Register */
DLLFUNCW32 void DLLFUNC rdSpecFunc(long an, long *value);                       /* read  Special-Function-Register */
DLLFUNCW32 void DLLFUNC wrControllerFlags(long an, long *value);                /* write Controller-Flags */
DLLFUNCW32 void DLLFUNC rdControllerFlags(long an, long *value);                /* read Controller-Flags */
DLLFUNCW32 int  DLLFUNC CardSelect (int CardNumber);                            /* Selection with more than one cards in PC */
DLLFUNCW32 void DLLFUNC wrJerkRel (long an, double *value);                     /* write Jerk-Faktor 0..1 */
DLLFUNCW32 void DLLFUNC rdJerkRel (long an, double *value);                     /* read  Jerk-Faktor 0..1 */
DLLFUNCW32 void DLLFUNC wrJerk (long an, double *value);                        /* write Jerk-Value [UU / (TU*TU*TU)] */
DLLFUNCW32 void DLLFUNC rdJerk (long an, double *value);                        /* read  Jerk-Value [UU / (TU*TU*TU)] */
DLLFUNCW32 void DLLFUNC wrErrorReg(long *value);                                /* write ErrorRegister */
DLLFUNCW32 void DLLFUNC rdErrorReg(long *value);                                /* read  ErrorRegister */
DLLFUNCW32 int  DLLFUNC rdSampleTime(long *SampleTime);                         /* read SampleTime from Card in s */
DLLFUNCW32 void DLLFUNC wrslsp(long an, double *value);                         /* write Slits-or-Step-Pulses */
DLLFUNCW32 int  DLLFUNC rdslsp(long an, double *value);                         /* read  Slits-or-Step-Pulses */

DLLFUNCW32 unsigned DLLFUNC rdDriverVersion(void);                              /* rnw Customer Driver Version read */
DLLFUNCW32 unsigned DLLFUNC allocPhysMem (void **VirtualAdr, unsigned *PhysAdr, unsigned size);
                                                                                /* allocate physical Memory */
DLLFUNCW32 unsigned DLLFUNC freePhysMem (void *VirtualAdr);                     /* free physical Memory */
DLLFUNCW32 int DLLFUNC accstop(struct AS *as);                                  /* acceleration stop in JOG-S-Profiles */
DLLFUNCW32 int DLLFUNC getEnvStr(char *EnvStr);                                 /* Read Environment String */
DLLFUNCW32 int DLLFUNC gettskinfo(int TaskNr, int *info);                       /* Read CNC-Task Text Info */
DLLFUNCW32 int DLLFUNC rdNumDigIO(unsigned int *value);                         /* Dummy Funktion for mcfg */
DLLFUNCW32 int DLLFUNC rddpoffset(int an, double *value);                       /* read dpoffset */
DLLFUNCW32 int DLLFUNC wrdpoffset(int an, double *value);                       /* write dpoffset */
DLLFUNCW32 int DLLFUNC rddvoffset(int an, double *value);                       /* read dvoffset */
DLLFUNCW32 int DLLFUNC wrdvoffset(int an, double *value);                       /* write dvoffset */
DLLFUNCW32 int DLLFUNC wrtrjerk  (double *value);                               /* write trajectory jerk */
DLLFUNCW32 int DLLFUNC rdtrjerk  (double *value);                               /* read trajectory jerk */
DLLFUNCW32 int DLLFUNC wrtrac	 (double *value);								/* write trajectory acceleration */
DLLFUNCW32 int DLLFUNC rdtrac    (double *value);								/* read trajectory acceleration */
DLLFUNCW32 int DLLFUNC wrtrvl    (double *value);								/* write trajectory velocity */
DLLFUNCW32 int DLLFUNC rdtrvl    (double *value);								/* read trajectory velocity */
DLLFUNCW32 int DLLFUNC wrtrtvl   (double *value);								/* write trajectory target velocity */
DLLFUNCW32 int DLLFUNC rdtrtvl   (double *value);								/* read trajectory target velocity */
DLLFUNCW32 int DLLFUNC wrSplineBlockSize(long *value);                          /* write SplineBlockSize */
DLLFUNCW32 int DLLFUNC rdSplineBlockSize(long *value);                          /* read  SplineBlockSize */

DLLFUNCW32 int DLLFUNC wrElCamTable64(char *buffer, int size, int ElCamTableNr);
DLLFUNCW32 int DLLFUNC wrElCamTable32(char *buffer, int size, int ElCamTableNr);
DLLFUNCW32 int DLLFUNC wrMcug3Handshake(unsigned *data);

DLLFUNCW32 int DLLFUNC SetOfflineTrace(void);                                   /* Activate Offline Trace */
DLLFUNCW32 int DLLFUNC StopTrace(void);                                         /* stop Tracing in RWMOS.ELF */

DLLFUNCW32 int DLLFUNC SelectedCard(void);                                      /* derzeit selektierte Achskarte abfragen */

DLLFUNCW32 int DLLFUNC rdgfaux(int an, double *value);                          /* read Gear-Factor Auxiliary */
DLLFUNCW32 int DLLFUNC wrgfaux(int an, double *value);                          /* write Gear-Factor Auxiliary */

DLLFUNCW32 int DLLFUNC rdUsTimer24b(void);                                      /* read MicroSecond Timer 24bit wide */

DLLFUNCW32 void DLLFUNC rdrpsync                (struct TSRP *tsrp);            /* read real position + sync aux */
DLLFUNCW32 void DLLFUNC rdauxsync               (struct TSRP *tsrp);            /* read aux syncronized */

DLLFUNCW32 void DLLFUNC ClearCI99               (void);                         /* Clear CI99 (for SSF 1025) */
DLLFUNCW32 void DLLFUNC ClearCI               	(long ndx);                     /* Clear CI?? (for SSF 1026) */
DLLFUNCW32 int  DLLFUNC RW_readmem              (char *dest, void *source, unsigned size, unsigned offset);
DLLFUNCW32 void DLLFUNC CpuSoftReset			(void);

DLLFUNCW32 int DLLFUNC VelToAOut 				(long an, long TabSize, long NumTab, double *Vmax, void *table);	/* OL Kommando Trajectory Velocity to Analog Out */
DLLFUNCW32 int DLLFUNC HeaderToAOut 			(long an, int NumberOfTables, int Size, void *HeaderInfos);
DLLFUNCW32 int DLLFUNC SelectTable				(long an, long TableNdx);		/* Select OL Cmd Table */
DLLFUNCW32 int DLLFUNC rdPcapIndex				(long an, long *value);			/* Read PcapIndex */

DLLFUNCW32 int DLLFUNC rdSysVarInt				(long cmd, long *value);		/* Access to Sys- / Ax-Var */
DLLFUNCW32 int DLLFUNC rdSysVarDbl				(long cmd, double *value);
DLLFUNCW32 int DLLFUNC wrSysVarInt				(long cmd, long *value);		/* Access to Sys- / Ax-Var */
DLLFUNCW32 int DLLFUNC wrSysVarDbl				(long cmd, double *value);
DLLFUNCW32 int DLLFUNC rdAxVarInt				(long cmd, long axndx, long *value);
DLLFUNCW32 int DLLFUNC rdAxVarDbl				(long cmd, long axndx, double *value);
DLLFUNCW32 int DLLFUNC wrAxVarInt				(long cmd, long axndx, long *value);
DLLFUNCW32 int DLLFUNC wrAxVarDbl				(long cmd, long axndx, double *value);
DLLFUNCW32 int DLLFUNC CheckRwmosBusy			(void);		/* prfen ob RWMOS gerade in Kommandoausfhrung ist / Hilfsfunktion fr Optimierung des Programmablaufs */
DLLFUNCW32 int DLLFUNC wrFilename				(char *filename);
DLLFUNCW32 int DLLFUNC ecFileToRead				(char *filename);
DLLFUNCW32 int DLLFUNC ReqSendFileBlock			(char *filename);
DLLFUNCW32 int DLLFUNC rdDmesg					(char *filename);	/* generating DMESG protocol and Transfer to Windows */
DLLFUNCW32 int DLLFUNC rdECdiag					(char *filename);	/* generating "ethercat diag -v" protocol and Transfer to Windows */
DLLFUNCW32 int DLLFUNC wrFile					(char *filename);
DLLFUNCW32 int DLLFUNC ec_chk_option     		(void);             /* check for EC Option */

#endif  /* #indef mcug3H */
