/*

  +-----------------------------------------------------------------------+
  | (C) Roesch & Walter Industrie-Elektronik GmbH                         |
  | Im Heidenwinkel 5            D-77963 Schwanau                         |
  +-------------------------------+---------------------------------------+
  | Tel : +49 (0) 7824/6628-0     | email    : support@rw-gmbh.de         |
  | Fax : +49 (0) 7824/6628-29    | Internet : http://www.rw-gmbh.de      |
  +-------------------------------+---------------------------------------+
  | Project     : MCUG3 TOOLSET   | Compiler : BORLAND C++ Builder        |
  |                               |            MICROSOFT Visual C++       |
  | Module name : mcug3.h         | Operating System:                     |
  |                               |            - Windows 95/98/Me         |
  |                               |            - Windows NT 4.0           |
  |                               |            - Windows NT Embedded 4.0  |
  |                               |            - Windows 2000             |
  +-------------------------------+---------------------------------------+
  | Author : Roesch R.               Date :02/03/2001                     |
  |          Walter M.                                                    |
  +-----------------------------------------------------------------------+
  | Description   : Driver Interface for                                  |
  |                 High-Performance Motion-Control Family Generation 3   |
  |                                                                       |
  |                 Currently supported G3-Controllers:                   |
  |                         MCU-3000, APCI-8001, MCU-6000 and APCI-8401   |
  |                                                                       |
  |                 This file contains all prototypes, definitions and    |
  |                 structures to build a Win32-based application program |
  |                                                                       |
  +-----------------------------------------------------------------------+

	Revision History:
	-----------------
	23.04.2002	V2-51	mw  new functions: rdPE, rdMCiS
							to read Position-Error and Move-Commands-in-Spooler added
	16.04.2002	V2-51	mw	new functions: rdModeReg, rdModeReg, wrMDVel, rdMDVel
							for LookAhead and velocity-skip feautures added
	05/03/2001	V2-51	rr	MCU3400 (new CompactPCI controller) enumeration added
	11/12/2001	V2-51	rr	- wrOption(), rdOption() 
							  renamed to wrOptionInt(), rdOptionInt()
							- wrOptionDbl(), rdOptionDbl() added
    03/12/2001	V2-51	rr	- struct OptionDescriptorObject, 
							  wrOption(), rdOption() and freeOptionHandle() added
							- Scanner functions:
								rdScannerBufferSize(), rdScannerStatus(),
								rdScannerLsm() and rdScannerBuffer() added
	31/08/2001	V2-50	mw	Spline functions
    						LdSSplineA, LdSSplineR, ExeSSpline added
    02/07/2001	V2-50	rr	removed stepcnct2
	15/03/2001	V2-50	rr	MCUG3CALLBACK Macro added.
							Functions: MCUG3_SetBoardIntRoutine(),
							MUG3_ResetBoardIntRoutine()
							and MCUG3_SetIntMask() added.
    09/03/2001	V2-50	rr	BootErrorReport() added
	07/03/2001	V2-50	rr	client and application specific structures added
	06/03/2001	V2-50	rr	language specific macros modified
	02/03/2001	V2-50	rr	created from MCU-G2 TOOLSET

*/


#ifndef mcug3H
#define mcug3H

/*
  +-----------------------------------------------------------------------+
  | Language specific macro definitions ...                               |
  +-----------------------------------------------------------------------+
*/

#ifdef __cplusplus
    #define DLLFUNCW32 	extern "C"
    #define DLLFUNC 	_stdcall
#else
    #define DLLFUNCW32
    #define DLLFUNC 	_stdcall
#endif


#if defined(__BORLANDC__) || (_MSC_VER >= 800) || defined (_CVI_) || defined(_STDCALL_SUPPORTED)
	#define MCUG3CALLBACK __stdcall
#endif


/*
  +-----------------------------------------------------------------------+
  | Definitions, structures, unions and enumerations ...                  |
  +-----------------------------------------------------------------------+
*/

#define MAXAXIS			18	 	/* currently maximum supplied number of axis, do not change !!! */
#define SIZE_STRREV		40		/* String-Size definition */
#define	SIZE_CIBUF		1000	/* Number of elements in common integer buffer */
#define	SIZE_CDBUF		1000	/* Number of elements in common double buffer */
#define BSIZE			1024	/* Size of System File Header and CNC File Header */
#define SIZE_FILENAMES	256		/* Max. (char) Size for Filenames */
#define SIZE_TIME		32		/* Size (char) of System time information */
#define SCPSZ_R			15		/* row size for CTRLRPARAMS */
#define SCPSZ_C			15		/* colomn size for CTRLRPARAMS*/
#define SPD2D_S			10		/* size of SPD2D datas */

/* Enumeration for Position units */
typedef enum	{MM, INCH, M, REV, DEG,
				 RAD, COUNTS, STEPS, LAST_PU   } PUS;
/* Enumeration for Time units */
typedef enum	{SEC, MIN, TSAMPLE, LAST_TU    } TUS;

/* Enumeration for MCU-G3 Board Types */
typedef enum
{
	UNKNOWNBOARD = 0x0,   		/* unknown board type */
    MCU3000 	 = 0x4,    		/* G3-Controller MCU-3000 */
	APCI8001	 = 0x4,    		/* G3-Controller APCI-8001 */  
    MCU6000 	 = 0x8,    		/* G3-Controller MCU-6000 */   
    APCI8401 	 = 0x8,    		/* G3-Controller APCI-8401 */ 
	MCU3400		 = 0x10,     	/* G3-Controller MCU-3400 (Compact PCI) */
	CPCI8001	 = 0x10     	/* G3-Controller CPCI8001 */
} BOARDTYPE;

#pragma pack(4)
union AXST
{
	int	status_word;
	struct {
		/* axst: Error- & Status-Bits */
		unsigned toasm  : 1;	/* Bit 0:  MCU-6000, APCI-8401 only, MCU-3000 / APCI-8001 = 0 */
		unsigned eo     : 1;	/* Bit 1:  Emergency out */
		unsigned dnr    : 1;	/* Bit 2:  Drive not ready */
		unsigned lslh	: 1;	/* Bit 3:  Limit switch left hardware */
		unsigned lsrh	: 1;	/* Bit 4:  Limit switch right hardware */
		unsigned lsls   : 1;	/* Bit 5:  Limit switch left software */
		unsigned lsrs   : 1;	/* Bit 6:  Limit switch right software */
		unsigned mpe	: 1; 	/* Bit 7:  Maximum Position Error */
		unsigned dhef	: 1;	/* Bit 8:  data handling error flag */
		unsigned cef	: 1;	/* Bit 9:  configuration error flag */
		unsigned nc	    : 2;	/* Bit 10..11: currently not used */

		/* Status-Bits */
		unsigned pe	    : 1;	/* Bit 12: Profile end */
		unsigned cl	    : 1;	/* Bit 13: Closed loop */
		unsigned ip	    : 1;	/* Bit 14: In Position */
		unsigned ui	    : 1;	/* Bit 15: user input */
		unsigned lpsf	: 1;	/* Bit 16: latched position synchronous flag */
		unsigned temp2	: 13;   /* Bit 17..29: currently not used */
        
		unsigned 		: 2;	/* Bit 30..31: for internal use only */
	} bit;
};

struct TSRP
{
	/* Common-Data for DLL-interface-driver MCUG3.DLL and PC-Application-Program(s) */
	int		an;				/* Axis-Number */
	double		kp;				/* PIDF filter parameter kp */
	double		ki;				/* PIDF filter parameter ki */
	double		kd;				/* PIDF filter parameter kd */
	double		kpl;			/* PIDF filter parameter kpl */
	double		kfca;			/* PIDF forward compensation acceleration */
	double		kfcv;			/* PIDF forward compensation velocity */
	double		jac;			/* jog acceleration */
	double		jvl;			/* jog velocity */
	double 		jtvl;			/* target velocity */
	double 		jovr;			/* jog override */
	double		hac;			/* home acceleration */
	double		hvl;			/* home velocity */
    double		rp;				/* real position */
	double		dp;				/* desired position */
	double		tp;				/* target position */
	double		dv; 			/* desired velocity */
	double		lp;				/* latched postion */
	double		aux;			/* auxilary value */
	double		sll;			/* software limit left */
	double		slr;			/* software limit right */
	double		ipw;			/* in position window */
	double		mpe;			/* maximum position error */
	double		sdec;			/* stop deceleration */
	double		gf;				/* gear factor */
	int			mcp;	   		/* motor command port */
	union AXST	axst;			/* axis status  */
	int 		lsm;			/* left spool memory */
	
	int			epc;			/* eeprom programming cycle */
	int			digi;			/* dig. inputs = asmi (MCU-6000, APCI-8401) */
	int			digo;			/* dig outputs = asmo (MCU-6000, APCI-8401)*/
	int			ifs;			/* interface status = asms (MCU-6000, APCI-8401) */
		
	int			scratch[4];		/* reserved space don't delete!! */
};

struct AS {
	/* Axis-Selection */
	int			unoa;	   		/* Number of used axis */
	int			san[MAXAXIS];	/* Axis Numbers */
};                          	
	
struct TRU {                	
	/* Trajectory Units */  	
	int			pu;			 	/* position unit, see enumeration PUS above */
	int			tu;			 	/* time unit, see enumeration TUS above */
};

struct LMP {
	/* Linear Motion Profile parameters */
	double 		ac;				/* trajectory acceleration  */
	double 		vl;				/* trajectory velocity */
	double 		tvl;			/* trajectory target velocity */
	double 		dtm[MAXAXIS];	/* distance to move */
};

struct CMP {
	/* Circular Motion Profile parameters */
	double 		ac;				/* trajectory acceleration  */
	double 		vl;				/* trajectory velocity */
	double 		tvl;			/* trajectory target velocity */
	double 		phi;			/* angel phi */
	double 		dtca1;			/* center point of axis 1 */
	double		dtca2;			/* center point of axis 2 */
};

struct HMP {
	/* Helical Motion Profile parameters */
	double 		ac;				/* trajectory acceleration  */
	double 		vl;				/* trajectory velocity */
	double 		tvl;			/* trajectory target velocity */
	double 		phi;			/* angel phi */
	double 		dtca1;			/* center point of axis 1 */
	double		dtca2;			/* center point of axis 2 */
	double 		dtm[MAXAXIS];	/* distance to move axis 3..n */
};

struct CNCTS {
	/* CNC-Task Status variables */
	int			ErrNum;			/* error number */
	int			ErrLine;		/* error line */
	int			StackFree;		/* stack bytes free */
	int			Running;		/* nc task running status */
	int			csrcline;		/* current (processed) source line number */
};

struct ROSI
{
	/* RISC Operating System Informations */
	char		revision[SIZE_STRREV];	
								/* software-revision-string */
	int			Number_Axis;   	/* number of supplied axis */
	int			SysFile_Loaded;	/* status flag for sysfile already loaded */
};

struct CIBUF
{
	/* Buffer definition for common integer variables */
	int			civals[SIZE_CIBUF];	
};

struct CDBUF
{
	/* Buffer definition for common double variables */
	double		cdvals[SIZE_CDBUF];	
};

struct CBCNCT
{
	/* Common CNC-Task buffer */
	int			TaskNr;			/* Task Number 0..3 */
	int			size;			/* size of Buffer [bytes] */
	char		*Buffer;		/* pointer to user allocated buffer */
};

struct SPDBUF
{
	/* position data to spool */
	double		dtm;			/* distance to move */
};

struct SPVTDBUF
{
	/* position, velocity, time datas to spool */
	double		dtm;			/* distance to move */
	double		vl;				/* velocity */
	double		t;				/* time */
};

struct CTRLRPARAMS {
	/* Controller specific data fields (application specicfic) */
	double 		val[SCPSZ_R][SCPSZ_C];
};

struct SPD2DPARAMS
{
	int			size;			/* size */
	int			san[2];			/* selected axis numbers */
	double		dtma1[SPD2D_S];	/* distance(s) to move axis 1 */
	double		dtma2[SPD2D_S];	/* ditsance(s) to move axis 2 */
};

struct LATCH_INFOS
{
	/* parameter set for latching position datas */
	int			san;			/* selected axis number */
	double		lst;			/* latch start time */
	double		let;			/* latch end time */
	int			pu;				/* position unit */                  
	int			tu;				/* time unit */
};

struct OLSR_INFOS {
	/* parameter set for open loop system response */
	int			san;			/* selected axis number */
	double		delay;			/* delay [s] */
	double		mcp;			/* motor command value [V] */
};

struct FILEHEADER
{
	/* CNC Task File Header Information */
	int			TaskNr;         /* NC-File runs in task 'TaskNr' 0..3 */
	char		SrcFileName[SIZE_FILENAMES];	
								/* CNC Source File Name */
	char		CncFileName[SIZE_FILENAMES];	
								/* CNC pseudo code file name */
	char		RevNr[SIZE_STRREV];				
								/* revision number */
	char		DateTime[SIZE_TIME];			
								/* build date and time information */
};

struct OptionDescriptorObject
{
    unsigned    Handle;         // do not change that!
    unsigned    AccessType;     // Read, Write, Flag
	unsigned    DataType;       // Byte, Word, Double Word, Real, ...
    unsigned    BusNumber;      // Interbus, Canbus, G3-Resourcebus, Scannerbus ...
    unsigned    DeviceNumber;   // depends on Bus Type
    unsigned    Index;          // depends on Bus Type
    unsigned    SubIndex;       // depends on Bus Type
}; 

#pragma pack()

/*
  +-----------------------------------------------------------------------+
  | Prototypes standard functions,                                        |
  | functions are described in MCU-G3 Programming Manual                  |
  +-----------------------------------------------------------------------+
*/

DLLFUNCW32 void DLLFUNC	uf					(struct TSRP *tsrp);				/* update filter */
DLLFUNCW32 void DLLFUNC	ctru				(struct TRU  *tru);					/* change trajectory units */
DLLFUNCW32 void DLLFUNC	wrjac				(struct TSRP *tsrp);				/* write jog acceleration */
DLLFUNCW32 void DLLFUNC	wrjvl				(struct TSRP *tsrp);				/* write jog velocity */
DLLFUNCW32 void DLLFUNC	wrjtvl				(struct TSRP *tsrp);				/* write jog target velocity */
DLLFUNCW32 void DLLFUNC	wrhac				(struct TSRP *tsrp);				/* write home acceleration */
DLLFUNCW32 void DLLFUNC	wrhvl				(struct TSRP *tsrp);				/* write home velocity */
DLLFUNCW32 void DLLFUNC	wrrp				(struct TSRP *tsrp);				/* write real position */
DLLFUNCW32 void DLLFUNC	wrdp				(struct TSRP *tsrp);				/* write desired position */
DLLFUNCW32 void DLLFUNC	wrlp				(struct TSRP *tsrp);				/* write latched position */
DLLFUNCW32 void DLLFUNC	wraux				(struct TSRP *tsrp);				/* write auxiliary value */
DLLFUNCW32 void DLLFUNC	shp					(struct TSRP *tsrp);				/* set home position */
DLLFUNCW32 void DLLFUNC	wrdigo				(struct TSRP *tsrp);				/* MCU-3000, APCI-8001 only: write digital outputs */
DLLFUNCW32 void DLLFUNC	wrdigob				(int an, int bitnr, int value);		/* MCU-3000, APCI-8001 only: write digital output bit */
DLLFUNCW32 void DLLFUNC	wrasmo				(struct TSRP *tsrp);				/* MCU-6000, APCI-8401 only: write ASM digital outputs */
DLLFUNCW32 void DLLFUNC	wrasmob				(int an, int bitnr, int value);		/* MCU-6000, APCI-8401 only: write ASM digital output bit */
DLLFUNCW32 void DLLFUNC	rdrp				(struct TSRP *tsrp);				/* read real position */
DLLFUNCW32 void DLLFUNC	rddp				(struct TSRP *tsrp);				/* read desired position */
DLLFUNCW32 void DLLFUNC	rdtp				(struct TSRP *tsrp);				/* read target position */
DLLFUNCW32 void DLLFUNC	rddv				(struct TSRP *tsrp);				/* read desired velocity */
DLLFUNCW32 void DLLFUNC	rdlp				(struct TSRP *tsrp);				/* read latched position */
DLLFUNCW32 void DLLFUNC	rdaux				(struct TSRP *tsrp);				/* read auxiliary value */
DLLFUNCW32 void DLLFUNC	rddigi				(struct TSRP *tsrp);				/* MCU-3000, APCI-8001 only: read digital inputs */
DLLFUNCW32 int  DLLFUNC	rddigib				(int an, int bitnr);				/* MCU-3000, APCI-8001 only: read digital input bit */
DLLFUNCW32 void DLLFUNC	rdifs				(struct TSRP *tsrp);				/* MCU-3000, APCI-8001 only: read interface status */
DLLFUNCW32 int  DLLFUNC	rdifsb				(int an, int bitnr);				/* MCU-3000, APCI-8001 only: read interface status bit */
DLLFUNCW32 void DLLFUNC	rddigo				(struct TSRP *tsrp);				/* MCU-3000, APCI-8001 only: read digital outputs */
DLLFUNCW32 int  DLLFUNC	rddigob				(int an, int bitnr);				/* MCU-3000, APCI-8001 only: read digital output bit */
DLLFUNCW32 void DLLFUNC rdasmi				(struct TSRP *tsrp);				/* MCU-6000, APCI-8401 only: read ASM digital inputs */
DLLFUNCW32 int  DLLFUNC rdasmib				(int an, int bitnr);				/* MCU-6000, APCI-8401 only: read ASM digital input bit */
DLLFUNCW32 void DLLFUNC rdasms				(struct TSRP *tsrp);				/* MCU-6000, APCI-8401 only: read ASM status */
DLLFUNCW32 int  DLLFUNC rdasmsb				(int an, int bitnr);				/* MCU-6000, APCI-8401 only: read ASM status bit */
DLLFUNCW32 void DLLFUNC	rdepc				(struct TSRP *tsrp);				/* MCU-6000, APCI-8401 only: read eeprom programming cycle */
DLLFUNCW32 void DLLFUNC rdasmepc			(struct TSRP *tsrp);				/* MCU-6000, APCI-8401 only: read ASM eeprom programming cycle */
DLLFUNCW32 void DLLFUNC rdasmo				(struct TSRP *tsrp);				/* MCU-6000, APCI-8401 only: read ASM digital outputs */
DLLFUNCW32 int  DLLFUNC rdasmob				(int an, int bitnr);				/* MCU-6000, APCI-8401 only: read ASM digital output bit */
DLLFUNCW32 void DLLFUNC	rdlsm				(struct TSRP *tsrp);				/* read left spool memory */
DLLFUNCW32 void DLLFUNC	rdaxst				(struct TSRP *tsrp);				/* read axis status */
DLLFUNCW32 int  DLLFUNC	rdaxstb				(int an, int bitnr);				/* read axis status bit */
DLLFUNCW32 void DLLFUNC	rdjac				(struct TSRP *tsrp);				/* read jog acceleration */
DLLFUNCW32 void DLLFUNC	rdjvl				(struct TSRP *tsrp);				/* read jog velocity */
DLLFUNCW32 void DLLFUNC	rdjtvl				(struct TSRP *tsrp);				/* read jog target velocity */
DLLFUNCW32 void DLLFUNC	rdhac				(struct TSRP *tsrp);				/* read home acceleration */
DLLFUNCW32 void DLLFUNC	rdhvl				(struct TSRP *tsrp);				/* read home velocity */
DLLFUNCW32 void DLLFUNC	cl					(struct AS *as);					/* close loop */
DLLFUNCW32 void DLLFUNC	ol					(struct AS *as);					/* open loop */
DLLFUNCW32 void DLLFUNC	ra					(struct AS *as);					/* reset axis */
DLLFUNCW32 void DLLFUNC	rifs				(struct TSRP *tsrp);				/* MCU-3000, APCI-8001 only: reset interface status flags */
DLLFUNCW32 void DLLFUNC rasms				(struct TSRP *tsrp);				/* MCU-6000, APCI-8401 only: reset ASM status flags */
DLLFUNCW32 void DLLFUNC	rs					(void);								/* reset system */
DLLFUNCW32 void DLLFUNC	azo					(int set);							/* activate zero offset */
DLLFUNCW32 void DLLFUNC	jr					(struct AS *as, struct TSRP *tsrp);	/* jog relative */
DLLFUNCW32 void DLLFUNC	ja					(struct AS *as, struct TSRP *tsrp);	/* jog absolute */
DLLFUNCW32 void DLLFUNC	jhl					(struct AS *as);					/* jog home left */
DLLFUNCW32 void DLLFUNC	jhr					(struct AS *as);					/* jog home right */
DLLFUNCW32 void DLLFUNC	jhi					(struct AS *as, struct TSRP *tsrp);	/* jog relative (to) index */
DLLFUNCW32 void DLLFUNC	mlr					(struct AS *as, struct LMP *lmp);	/* move linear relative */
DLLFUNCW32 void DLLFUNC	mla					(struct AS *as, struct LMP *lmp);	/* move linear absolute */
DLLFUNCW32 void DLLFUNC	mcr					(struct AS *as, struct CMP *cmp);	/* move circular relative */
DLLFUNCW32 void DLLFUNC	mca					(struct AS *as, struct CMP *cmp);	/* move circular absolute */
DLLFUNCW32 void DLLFUNC	mhr					(struct AS *as, struct HMP *hmp);	/* move helix relative */
DLLFUNCW32 void DLLFUNC	mha					(struct AS *as, struct HMP *hmp);	/* move helix absolute */
DLLFUNCW32 void DLLFUNC	smlr				(struct AS *as, struct LMP *lmp);	/* spool motion linear relative */
DLLFUNCW32 void DLLFUNC	smla				(struct AS *as, struct LMP *lmp);	/* spool motion linear absolute */
DLLFUNCW32 void DLLFUNC	smcr				(struct AS *as, struct CMP *cmp);	/* spool motion circular relative */
DLLFUNCW32 void DLLFUNC	smca				(struct AS *as, struct CMP *cmp);	/* spool motion circular absolute */
DLLFUNCW32 void DLLFUNC	smhr				(struct AS *as, struct HMP *hmp);	/* spool motion helix relative */
DLLFUNCW32 void DLLFUNC	smha				(struct AS *as, struct HMP *hmp);	/* spool motion helix absolute */
DLLFUNCW32 void DLLFUNC	ssms				(struct AS *as);					/* start spooled motions synchronous */
DLLFUNCW32 void DLLFUNC	sstps				(struct AS *as);					/* stop spooled motions synchronous */
DLLFUNCW32 void DLLFUNC	sdels				(struct AS *as);					/* delete spooled motions synchronous */
DLLFUNCW32 int  DLLFUNC	txbf				(char *filename);					/* transmit binary file */
DLLFUNCW32 int  DLLFUNC	txbf2				(char *filename);					/* transmit binary file, 2nd method */
DLLFUNCW32 void DLLFUNC	startcnct			(int TaskNr);						/* start cnc task */
DLLFUNCW32 void DLLFUNC	stopcnct			(int TaskNr);						/* stop cnc task */
DLLFUNCW32 void DLLFUNC	contcnct			(int TaskNr);						/* continue cnc task */
DLLFUNCW32 void DLLFUNC	stepcnct			(int TaskNr);						/* step cnc task */
DLLFUNCW32 void DLLFUNC	rdcncts				(int TaskNr, struct CNCTS *cncts);	/* read cnc task status */
DLLFUNCW32 int  DLLFUNC	rdcbcnct			(struct CBCNCT *cbcnct);			/* read cnc task spec. common buffer */
DLLFUNCW32 int  DLLFUNC	wrcbcnct			(struct CBCNCT *cbcnct);			/* write cnc task spec. common buffer */
DLLFUNCW32 void DLLFUNC	rdci				(int ndx, struct CIBUF *cibuf);		/* read common integer */
DLLFUNCW32 void DLLFUNC	rdcd				(int ndx, struct CDBUF *cdbuf);		/* read common double */
DLLFUNCW32 void DLLFUNC	wrci				(int ndx, struct CIBUF *cibuf);		/* write common integer variables */
DLLFUNCW32 void DLLFUNC	wrcd				(int ndx, struct CDBUF *cdbuf);		/* write common double variables */
DLLFUNCW32 void DLLFUNC	rdmcp				(struct TSRP *tsrp);				/* read motor command port */
DLLFUNCW32 void DLLFUNC	wrmcp				(struct TSRP *tsrp);				/* write motor command port */
DLLFUNCW32 void DLLFUNC	wrledrd				(int value);						/* write led red */
DLLFUNCW32 void DLLFUNC	wrledyl				(int value);						/* write led yellow */
DLLFUNCW32 void DLLFUNC	wrledgn				(int value);						/* write led green */
DLLFUNCW32 int  DLLFUNC	rdledrd				(void);								/* read led red */
DLLFUNCW32 int  DLLFUNC	rdledyl				(void);								/* read led yellow */
DLLFUNCW32 int  DLLFUNC	rdledgn				(void);								/* read led green */
DLLFUNCW32 int  DLLFUNC	rdirqpc				(void);								/* read irq pc */
DLLFUNCW32 int  DLLFUNC	mcuinit				(struct ROSI *rosi);				/* MCU-G3 initialisition */
DLLFUNCW32 int  DLLFUNC	mcuinit2			(struct ROSI *rosi, int TpuBaseAddress); 
																				/* MCU-G3 initialisition, 2nd method */
DLLFUNCW32 void DLLFUNC	wrjovr				(struct TSRP *tsrp);				/* write jog override */
DLLFUNCW32 void DLLFUNC	rdjovr				(struct TSRP *tsrp);				/* read jog override */
DLLFUNCW32 void DLLFUNC	wrtrovr				(double *value);					/* write trajectory override */
DLLFUNCW32 void DLLFUNC	rdtrovr				(double *value);					/* read trajectory override */
DLLFUNCW32 void DLLFUNC	utrovr				(struct AS *as);					/* update trajectory override */
DLLFUNCW32 void DLLFUNC	rdf					(struct TSRP *tsrp);				/* read filter */
DLLFUNCW32 void DLLFUNC	rdap				(struct TSRP *tsrp);				/* read axis parameters */
DLLFUNCW32 void DLLFUNC	rdsll				(struct TSRP *tsrp);				/* read software limit left */
DLLFUNCW32 void DLLFUNC	wrsll				(struct TSRP *tsrp);				/* write software limit left */
DLLFUNCW32 void DLLFUNC	rdslr				(struct TSRP *tsrp);				/* read software limit right */
DLLFUNCW32 void DLLFUNC	wrslr				(struct TSRP *tsrp);				/* write software limit right */
DLLFUNCW32 void DLLFUNC	rdipw				(struct TSRP *tsrp);				/* read in position window */
DLLFUNCW32 void DLLFUNC	wripw				(struct TSRP *tsrp);				/* write in position window */
DLLFUNCW32 void DLLFUNC	rdmpe				(struct TSRP *tsrp);				/* read maximum position error */
DLLFUNCW32 void DLLFUNC	wrmpe				(struct TSRP *tsrp);				/* write maximum position error */
DLLFUNCW32 void DLLFUNC	rdsdec				(struct TSRP *tsrp);				/* read stop deceleration */
DLLFUNCW32 void DLLFUNC	wrsdec				(struct TSRP *tsrp);				/* write stop deceleration */
DLLFUNCW32 void DLLFUNC	spd					(int an, int size, struct SPDBUF *spdbuf);	
																				/* spool position data */
DLLFUNCW32 void DLLFUNC	wrgf				(struct TSRP *tsrp);				/* write gear factor */
DLLFUNCW32 void DLLFUNC	rdgf				(struct TSRP *tsrp);				/* read gear factor */
DLLFUNCW32 void DLLFUNC	spvtd				(int an, int size, struct SPVTDBUF *spvtdbuf);	
																				/* spool position, veloctiy, time data */
DLLFUNCW32 void DLLFUNC	ms					(struct AS *as);					/* motion stop */
DLLFUNCW32 void DLLFUNC	js					(struct AS *as);					/* jog stop */
DLLFUNCW32 void DLLFUNC	lps					(int an, int mst);					/* latch position synchronous */
DLLFUNCW32 void DLLFUNC	rdigi				(struct TSRP *tsrp);				/* MCU-3000, APCI-8001 only: reset digital inputs */
DLLFUNCW32 void DLLFUNC	rdlpndx				(struct TSRP *tsrp);				/* MCU-3000, APCI-8001 only: read latched position index */
DLLFUNCW32 void DLLFUNC	wrlpndx				(struct TSRP *tsrp);				/* MCU-3000, APCI-8001 only: write latched position index */
DLLFUNCW32 void DLLFUNC ssf					(int an, int command, int value);	/* Spooler-Special-Function-Command */

DLLFUNCW32 int  DLLFUNC	InitMcuSystem		(struct TSRP *tsrp);				/* initialisation function first method, (you should not use this function, instead use InitMcuSystem2() or even better InitMcuSystem3()) */
DLLFUNCW32 int  DLLFUNC	InitMcuSystem2		(struct TSRP *tsrp, int TpuBaseAddress, char *SystemFileName); 
																				/* initialisation function, 2nd method*/
DLLFUNCW32 int  DLLFUNC InitMcuSystem3  	(struct TSRP *tsrp, struct ROSI *rosi, int TpuBaseAddress, char *SystemFileName, int *BoardType); 
																				/* initialisation function, 3rd method*/
DLLFUNCW32 void DLLFUNC	InitMcuErrorReport	(int error);						/* detailed initialisation error report function */
DLLFUNCW32 void DLLFUNC	txbfErrorReport		(char *filename, int error);		/* detailed load error report function */
DLLFUNCW32 void DLLFUNC BootErrorReport		(char *filename, int error);		/* detailed boot error report function */
DLLFUNCW32 void DLLFUNC McuClose			(void);                             /* close driver function, must be called at end of program !*/
DLLFUNCW32 int  DLLFUNC BootFile			(char *BootFileName, int TpuBaseAddress); 
																				/* Send Bootfile (i.e. rwmos.elf) to controller board */
DLLFUNCW32 void DLLFUNC	LdSSplineA 			(struct AS *as, struct LMP *lmp);	/* Load Spool Spline Data Absolut */
DLLFUNCW32 void DLLFUNC	LdSSplineR 			(struct AS *as, struct LMP *lmp);	/* Load Spool Spline Data Relativ */
DLLFUNCW32 void DLLFUNC	ExeSSpline 			(struct AS *as, struct LMP *lmp);	/* Execute Spool Spline */

DLLFUNCW32 int  DLLFUNC wrOptionInt			(struct OptionDescriptorObject *odesc, int *val);
																				/* Option Object write integer function */
DLLFUNCW32 int  DLLFUNC rdOptionInt			(struct OptionDescriptorObject *odesc, int *val);
																				/* Option Object read integer function */
DLLFUNCW32 int  DLLFUNC wrOptionDbl			(struct OptionDescriptorObject *odesc, double *val);
																				/* Option Object write double function */
DLLFUNCW32 int  DLLFUNC rdOptionDbl			(struct OptionDescriptorObject *odesc, double *val);
																				/* Option Object read double function */
DLLFUNCW32 int  DLLFUNC freeOptionHandle	(struct OptionDescriptorObject *odesc);	
																				/* Option Object free handle */

DLLFUNCW32 int  DLLFUNC rdScannerBufferSize	(void);                     		/* Read size of scan buffer */
DLLFUNCW32 int  DLLFUNC rdScannerStatus		(void);                     		/* read scanner status register */
DLLFUNCW32 int  DLLFUNC rdScannerLsm		(void);                            	/* read scanner left spool memory */
DLLFUNCW32 int  DLLFUNC rdScannerBuffer		(char *buffer, int size);         	/* read scanner buffer */

DLLFUNCW32 void DLLFUNC wrModeReg(long *value);									/* write ModeRegister */
DLLFUNCW32 void DLLFUNC rdModeReg(long *value);                         		/* read  ModeRegister */
DLLFUNCW32 void DLLFUNC wrMDVel(long an, double *value);                		/* write Maximum Delta Velocity */
DLLFUNCW32 void DLLFUNC rdMDVel(long an, double *value);                		/* read  Maximum Delta Velocity */
DLLFUNCW32 void DLLFUNC rdPE(long an, double *value);                   		/* read  Position Error */
DLLFUNCW32 void DLLFUNC rdMCiS(long an, long *value);                   		/* read  Move-Commands-in-Spooler */

/*
  +---------------------------------------------------------------------------------+
  |    Prototypes for client and application specific functions,                    | 
  |    do not use that functions if you have no information 						|
  |    about the individual functions !!!                                           | 
  |    (normaly you should not need that functions)                                 | 
  +---------------------------------------------------------------------------------+
*/

DLLFUNCW32 void DLLFUNC wrBlk				(char *buffer);						/* Common Write Command without return value (internal function) */
DLLFUNCW32 int  DLLFUNC rdBlk				(char *buffer);						/* Common Read Command */
DLLFUNCW32 void DLLFUNC wrtp				(struct TSRP *tsrp);				/* write target position */
DLLFUNCW32 void DLLFUNC rdrpd				(struct TSRP *tsrp);                /* read real position display */
DLLFUNCW32 void DLLFUNC rddpd				(struct TSRP *tsrp);                /* read desired position display */
DLLFUNCW32 void DLLFUNC rdtpd				(struct TSRP *tsrp);                /* read target position display */
DLLFUNCW32 void DLLFUNC	scp					(int an, struct CTRLRPARAMS *ctrlrparams);	
																				/* set controller parameters */
DLLFUNCW32 void DLLFUNC	wrcv				(int *an, double *value);          	/* write command velocity */
DLLFUNCW32 void DLLFUNC	rdcv				(int *an, double *value);          	/* read command velocity */
DLLFUNCW32 void DLLFUNC	cm					(int *an, int *value);             	/* change mode */
DLLFUNCW32 void DLLFUNC	spd2d				(struct SPD2DPARAMS *);             /* spool position datas 2D */
DLLFUNCW32 void DLLFUNC	rdlrpr				(struct LATCH_INFOS *latch_infos, double *buffer);
																				/* read latched real pos. registers */
DLLFUNCW32 void DLLFUNC	rdldpr				(struct LATCH_INFOS *latch_infos, double *buffer);
																				/* read latched desired pos. registers */
DLLFUNCW32 void DLLFUNC	getcnctsrclinenr	(int *TaskNr, int *LineNr);			/* read in current linenumber beeing processed of selected cnc task */
DLLFUNCW32 int  DLLFUNC	getmsgstr			(int *an, char *result);	        /* read in internal MCU-G3 debug-string */
DLLFUNCW32 void DLLFUNC	getcnctfh			(int *TaskNr, struct FILEHEADER *fh);
																				/* read in CNC-task-fileheader of selected cnc task */
DLLFUNCW32 void DLLFUNC	burnaplpar			(int *an);							/* burn appliance parameters */
DLLFUNCW32 void DLLFUNC	gettimers			(struct TSRP *tsrp, int *an);		/* read in several debug-timers of high-prior task */
DLLFUNCW32 void DLLFUNC	lpr					(struct LATCH_INFOS *latch_infos);	/* latch position registers */
DLLFUNCW32 void DLLFUNC lprs				(struct AS *as, struct LATCH_INFOS *latch_infos);
																				/* latch position registers synchronous on several axis */
DLLFUNCW32 void DLLFUNC olsr				(struct OLSR_INFOS *olsr);			/* open loop system response */
DLLFUNCW32 void DLLFUNC	rdasmecs			(struct TSRP *tsrp, int *an);		/* MCU-6000, APCI-8401 only: read in ASM eprom checksum of firmware */
DLLFUNCW32 void DLLFUNC ReadLinkStatus		(int *fae, int *ba);				/* read current link stati */
DLLFUNCW32 int  DLLFUNC rdAin				(int an, int channel);				/* MCU-3000, APCI-8001 only: read Analog Inputs from OPMF-3001 */
DLLFUNCW32 void DLLFUNC szp					(int an, double Position);			/* Set Zero Position */

DLLFUNCW32 void DLLFUNC rdMcuStatus(char *buffer, int size);					/* read in MCU G3 status registers */
DLLFUNCW32 void DLLFUNC rdAsmSecureParams(int an, char *buffer);				/* MCU-6000, APCI-8401 only: read ASM-EEPROM parameters (firmware data) */
DLLFUNCW32 void DLLFUNC wrAsmSecureParams(int an, char *buffer); 				/* MCU-6000, APCI-8401 only: write ASM-EEPROM parameters (firmware data) */


typedef void (MCUG3CALLBACK* InterruptRoutine)(int i_IRQLineBits);				/* Callback-Prototyp for User-Interrupt-Handler */
DLLFUNCW32 int DLLFUNC MCUG3_SetBoardIntRoutine(InterruptRoutine func);			/* Install User Interrupt Handler Routine */
DLLFUNCW32 int DLLFUNC MCUG3_ResetBoardIntRoutine(void);						/* Deinstall User Interrupt Handler Routine */
DLLFUNCW32 int DLLFUNC MCUG3_SetIntMask(int i_IRQMaskBits);						/* Set Interrupt Mask Register */

#endif	/* #indef mcug3H */
