Attribute VB_Name = "MCUG3API"
'  +-----------------------------------------------------------------------+
'  | (C) Roesch & Walter Industrie-Elektronik GmbH                         |
'  | Im Heidenwinkel 5            D-77963 Schwanau                         |
'  +-------------------------------+---------------------------------------+
'  | Tel : +49 (0) 7824/6628-0     | email    : support@rw-gmbh.de         |
'  | Fax : +49 (0) 7824/6628-29    | Internet : http://www.rw-gmbh.de      |
'  +-------------------------------+---------------------------------------+
'  | Project     : MCUG3 TOOLSET   | Compiler : MICROSOFT Visual Basic     |
'  |                               |                                       |
'  | Module name : mcug3.bas       | Operating System:                     |
'  |                               |            - Windows 95/98/Me         |
'  |                               |            - Windows NT 4.0           |
'  |                               |            - Windows NT Embedded 4.0  |
'  |                               |            - Windows 2000             |
'  +-------------------------------+---------------------------------------+
'  | Author : Roesch R.               Date :07/03/2001                     |
'  |          Walter M.                                                    |
'  +-----------------------------------------------------------------------+
'  | Description   : Driver Interface for                                  |
'  |                 High-Performance Motion-Control Family Generation 3   |
'  |                                                                       |
'  |                 Currently supported G3-Controllers:                   |
'  |                         MCU-3000, APCI-8001, MCU-6000 and APCI-8401   |
'  |                                                                       |
'  |                 This file contains all prototypes, definitions and    |
'  |                 structures to build a Win32-based application program |
'  |                                                                       |
'  +-----------------------------------------------------------------------+
    
'    Revision History:
'    -----------------
'    09/05/2003  V2-52   mw  new commands:
'                               rdMaxAcc,  wrMaxAcc added
'    10.03.2003  V2-52   mw  New function: MsgToScreen - possibility to supress
'                            Screen-Messages (Message Boxes)
'    18/02/2003  V2-52   mw  new commands:
'                               wrModeReg, rdModeReg,
'                               wrMDVel,   rdMDVel,
'                               rdMaxVel,  wrMaxVel added
'    04/12/2002  V2-52   mw  commands and types for 3D-Circular-Moves added
'    07/10/2002  V2-52   mw  commands for virtual zero point added
'                            szpa, szpr
'    10/01/2002  V2-51   mw  Paramter value in ssf changed from Long to Double
'    11/12/2001  V2-51   rr  - wrOption(), rdOption()
'                              renamed to wrOptionInt(), rdOptionInt()
'                            - wrOptionDbl(), rdOptionDbl() added
'    03/12/2001  V2-51   rr  - struct OptionDescriptorObject,
'                              wrOption(), rdOption() and freeOptionHandle() added
'                            - Scanner functions:
'                                rdScannerBufferSize(), rdScannerStatus(),
'                                rdScannerLsm() and rdScannerBuffer() added
'    31/08/2001  V2-50   mw  Spline functions
'                            LdSSplineA, LdSSplineR, ExeSSpline added
'    02/07/2001  V2-50   rr  removed stepcnct2
'    07/03/2001  V2-50   rr  created from MCU-G2 / MCU-G3 TOOLSET
'                            updated according "C-Source" mcug3.h

Global Const MAXAXIS = 18              ' currently maximum supplied axis
Global Const SIZE_STRREV = 40          ' String-Size definition
Global Const SIZE_CIBUF = 1000         ' Number of elements in common (long) integer buffer
Global Const SIZE_CDBUF = 1000         ' Number of elements in common double buffer
Global Const BSIZE = 1024              ' Size of System File Header and CNC File Header
Global Const SIZE_FILENAMES = 256      ' Max. (char) Size for Filenames
Global Const SIZE_TIME = 32            ' Size (char) of System time information
Global Const SCPSZ_R = 15              ' row size for CTRLRPARAMS
Global Const SCPSZ_C = 15              ' colomn size for CTRLRPARAMS
Global Const SPD2D_S = 10              ' size of SPD2D
' Bit-Locations for Status-und Error-Flags in axst '
' error flags ...
Global Const BITLOC_to = &H1           ' Bit 0:  MCU-6000, APCI-8401 only, MCU-3000 / APCI-8001 = 0
Global Const BITLOC_eo = &H2           ' Emergency Out
Global Const BITLOC_dnr = &H4          ' Drive not ready
Global Const BITLOC_lslh = &H8         ' Limit switch left hardware
Global Const BITLOC_lsrh = &H10        ' Limit switch right hardware
Global Const BITLOC_lsls = &H20        ' Limit switch left software
Global Const BITLOC_lsrs = &H40        ' Limit switch right software
Global Const BITLOC_mpe = &H80         ' Maximum position error
Global Const BITLOC_dhef = &H100       ' Data handling error flag
Global Const BITLOC_cef = &H200        ' Configuration error flag
                                       ' Bit 10..11: currently not used
' status flags ...
Global Const BITLOC_pe = &H1000        ' Profile end
Global Const BITLOC_cl = &H2000        ' Closed loop
Global Const BITLOC_ip = &H4000        ' In position
Global Const BITLOC_ui = &H8000        ' user input
Global Const BITLOC_lpsf = &H10000     ' latched position synchronous flag
                                       ' Bit 17..29: currently not used
                                       ' Bit 30..31: for internal use only

' Enumeration for Position units
Enum PUS
    MM
    INCH
    M
    REV
    DEG
    RAD
    COUNTS
    STEPS
End Enum

' Enumeration for Time units
Enum TUS
    SEC
    Min
    TSAMPLE
End Enum

' Enumeration for MCU-G3 Board Types
Enum BOARDTYPE
    UNKNOWNBOARD = &H0                 'unknown board type
    MCU3000 = &H4                      'G3-Controller MCU-3000
    APCI8001 = &H4                     'G3-Controller APCI-8001
    MCU6000 = &H8                      'G3-Controller MCU-6000
    APCI8401 = &H8                     'G3-Controller APCI-8401
End Enum

Type TSRP
    ' Common-Data for DLL-interface-driver MCUG3.DLL and PC-Application-Program(s)
    an   As Long                       'Axis-Number
    kp   As Double                     'PIDF filter parameter kp
    ki   As Double                     'PIDF filter parameter ki
    kd   As Double                     'PIDF filter parameter kd
    kpl  As Double                     'PIDF filter parameter kpl
    kfca As Double                     'PIDF forward compensation acceleration
    kfcv As Double                     'PIDF forward compensation velocity
    jac  As Double                     'jog acceleration
    jvl  As Double                     'jog velocity
    jtvl As Double                     'target velocity
    jovr As Double                     'jog override
    hac  As Double                     'home acceleration
    hvl  As Double                     'home velocity
    rp   As Double                     'real position
    dp   As Double                     'desired position
    tp   As Double                     'target position
    dv   As Double                     'desired velocity
    lp   As Double                     'latched position
    aux  As Double                     'auxiliary value
    sll  As Double                     'software limit left
    slr  As Double                     'software limit right
    ipw  As Double                     'in position window
    mpe  As Double                     'maximum position error
    sdec As Double                     'stop deceleration
    gf   As Double                     'gear factor
    mcp  As Long                       'motor command port
    axst As Long                       'axis status
    lsm  As Long                       'left spool memory
                                       
    epc  As Long                       'eeprom programming cycle
    digi As Long                       'dig. inputs = asmi (MCU-6000, APCI-8401)
    digo As Long                       'dig. outputs = asmo (MCU-6000, APCI-8401)
    ifs  As Long                       'interface status = asms (MCU-6000, APCI-8401)

    scratch(0 To 3) As Long            'reserved space don't delete!!
End Type

Type ASEL
    ' Axis-Selection
    unoa As Long                       ' Number of used axis
    san(0 To MAXAXIS - 1) As Long      ' Axis Numbers
End Type

Type tru
    ' Trajectory Units
    pu   As Long                       ' position unit, see enumeration PUS above
    tu   As Long                       ' time unit, see enumeration PUS above
End Type

Type lmp
    ' Linear Motion Profile parameters
    ac   As Double                     ' trajectory acceleration
    vl   As Double                     ' trajectory velocity
    tvl  As Double                     ' trajectory target velocity
    dtm(0 To MAXAXIS - 1) As Double    ' distance to move
End Type

Type CMP
    ' Circular Motion Profile parameters
    ac    As Double                    ' trajectory acceleration
    vl    As Double                    ' trajectory velocity
    tvl   As Double                    ' trajectory target velocity
    phi   As Double                    ' angel phi
    dtca1 As Double                    ' center point of axis 1
    dtca2 As Double                    ' center point of axis 2
End Type

Type HMP
    'Helical Motion Profile parameters
    ac    As Double                    ' trajectory acceleration
    vl    As Double                    ' trajectory velocity
    tvl   As Double                    ' trajectory target velocity
    phi   As Double                    ' angel phi
    dtca1 As Double                    ' center point of axis 1
    dtca2 As Double                    ' center point of axis 2
    dtm(0 To MAXAXIS - 1) As Double    ' distance to move axis 3..n
End Type

Type HMP3D
    '3D Helical Motion Profile parameters
    ac    As Double                    ' trajectory acceleration
    vl    As Double                    ' trajectory velocity
    tvl   As Double                    ' trajectory target velocity
    phi   As Double                    ' angel phi
    dtca1 As Double                    ' center point of axis 1
    dtca2 As Double                    ' center point of axis 2
    dtca3 As Double                    ' center point of axis 3
    pn1   As Double                    ' area perpendicular of axis 1 (Flchen-Normale A1)
    pn2   As Double                    ' area perpendicular of axis 2 (Flchen-Normale A2)
    pn3   As Double                    ' area perpendicular of axis 3 (Flchen-Normale A3)
    dtm(0 To MAXAXIS - 1) As Double    ' distance to move axis 3..n
End Type

Type CNCTS
    ' CNC-Task Status variables
    errnum    As Long                  ' error number
    errline   As Long                  ' error line
    stackfree As Long                  ' stack bytes free
    running   As Long                  ' nc task running status
    csrcline  As Long                  ' current (processed) source line number
End Type

Type ROSI
    ' RISC Operating System Informations
    revision(0 To SIZE_STRREV - 1) As Byte
                                       ' software-revision-string
    number_axis    As Long             ' number of supplied axis
    sysfile_loaded As Long             ' status flag for sysfile already loaded
End Type

Type CIBUF
    ' Buffer definition for common (long) integer variables
    civals(0 To SIZE_CIBUF - 1) As Long
End Type

Type CDBUF
    ' Buffer definition for common double variables
    cdvals(0 To SIZE_CDBUF - 1) As Double
End Type

Type CBCNCT
    ' Common CNC-Task buffer
    TaskNr    As Long                  ' Task Number 0..3
    size      As Long                  ' size of Buffer [bytes]
    BuffPtr() As Long                  ' pointer to user allocated buffer
End Type

Type SPDBUF
    ' position data to spool
    dtm As Double                      ' distance to move
End Type


Type SPVTDBUF
    ' position, velocity, time datas to spool
    dtm As Double                      ' distance to move
    vl  As Double                      ' velocity
    t   As Double                      ' time
End Type

Type CTRLRPARAMS
    ' Controller specific data fields (application specicfic)
    val(0 To SCPSZ_R - 1, 0 To SCPSZ_C - 1) As Double
End Type

Type SPD2DPARAMS
    size As Long                       ' size
    san(0 To 1) As Long                ' selected axis numbers
    dtma1(0 To SPD2D_S - 1) As Double  ' distance to move axis 1
    dtma2(0 To SPD2D_S - 1) As Double  ' distance to move axis 2
End Type
    
Type LATCH_INFOS
    ' parameter set for latching position datas
    san As Long                        ' selected axis number
    lst As Double                      ' latch start time
    let As Double                      ' latch end time
    pu  As Long                        ' position unit
    tu  As Long                        ' time unit
End Type

Type OLSR_INFOS
    ' parameter set for open loop system response
    san   As Long                      ' selected axis number
    delay As Double                    ' delay [s]
    mcp   As Double                    ' motor command value [V]
End Type

Type FILEHEADER
    ' CNC Task File Header Information
    TaskNr As Long                     ' NC-File runs in task 'TaskNr' 0..3
    SrcFileName(0 To SIZE_FILENAMES - 1) As Byte
                                       ' CNC Source File Name
    CncFileName(0 To SIZE_FILENAMES - 1) As Byte
                                       ' CNC pseudo code file name
    RevNr(0 To SIZE_STRREV - 1) As Byte
                                       ' revision number
    DateTimearray(0 To SIZE_TIME - 1) As Byte
                                       ' build date and time information
End Type

Type OptionDescriptorObject
    Handle As Long                     ' do not change that!
    AccesType As Long                  ' Read, Write, Flag
    DataType As Long                   ' Byte, Word, Double Word, Real, ...
    BusNumber As Long                  ' Interbus, Canbus, G3-Resourcebus, Scannerbus ...
    DeviceNumber As Long               ' depends on Bus Type
    Index As Long                      ' depends on Bus Type
    SubIndex As Long                   ' depends on Bus Type
End Type


'  +-----------------------------------------------------------------------+
'  | Prototypes standard functions,                                        |
'  | functions are described in MCU-G3 Programming Manual                  |
'  +-----------------------------------------------------------------------+

Declare Sub uf Lib "MCUG3.DLL" (DTSRP As TSRP)      'update filter
Declare Sub ctru Lib "MCUG3.DLL" (DTRU As tru)      'change trajectory parameters
Declare Sub wrjac Lib "MCUG3.DLL" (DTSRP As TSRP)   'write jog acceleration
Declare Sub wrjvl Lib "MCUG3.DLL" (DTSRP As TSRP)   'write jog velocity
Declare Sub wrjtvl Lib "MCUG3.DLL" (DTSRP As TSRP)  'write jog target velocity
Declare Sub wrhac Lib "MCUG3.DLL" (DTSRP As TSRP)   'write home acceleration
Declare Sub wrhvl Lib "MCUG3.DLL" (DTSRP As TSRP)   'write home velocity
Declare Sub wrrp Lib "MCUG3.DLL" (DTSRP As TSRP)    'write real position
Declare Sub wrdp Lib "MCUG3.DLL" (DTSRP As TSRP)    'write desired position
Declare Sub wrlp Lib "MCUG3.DLL" (DTSRP As TSRP)    'write latched position
Declare Sub wraux Lib "MCUG3.DLL" (DTSRP As TSRP)   'write auxiliary value
Declare Sub shp Lib "MCUG3.DLL" (DTSRP As TSRP)     'set home position
Declare Sub wrdigo Lib "MCUG3.DLL" (DTSRP As TSRP)  'MCU-3000, APCI-8001 only: write digital outputs
Declare Sub wrdigob Lib "MCUG3.DLL" (ByVal an As Long, ByVal bitnr As Long, ByVal value As Long)
                                                    'MCU-3000, APCI-8001 only: write digital output bit
Declare Sub wrasmo Lib "MCUG3.DLL" (DTSRP As TSRP)  'MCU-6000, APCI-8401 only: write ASM digital outputs
Declare Sub wrasmob Lib "MCUG3.DLL" (ByVal an As Long, ByVal bitnr As Long, ByVal value As Long)
                                                    'MCU-6000, APCI-8401 only: write ASM digital output bit
Declare Sub rdrp Lib "MCUG3.DLL" (DTSRP As TSRP)    'read real position
Declare Sub rddp Lib "MCUG3.DLL" (DTSRP As TSRP)    'read desired position
Declare Sub rdtp Lib "MCUG3.DLL" (DTSRP As TSRP)    'read target position
Declare Sub rddv Lib "MCUG3.DLL" (DTSRP As TSRP)    'read desired velocity
Declare Sub rdlp Lib "MCUG3.DLL" (DTSRP As TSRP)    'read latched position
Declare Sub rdaux Lib "MCUG3.DLL" (DTSRP As TSRP)   'read auxiliary value
Declare Sub rddigi Lib "MCUG3.DLL" (DTSRP As TSRP)  'MCU-3000, APCI-8001 only: read digital inputs
Declare Function rddigib Lib "MCUG3.DLL" (ByVal an As Long, ByVal bitnr As Long) As Long
                                                    'MCU-3000, APCI-8001 only: read digital input bit
Declare Sub rdifs Lib "MCUG3.DLL" (DTSRP As TSRP)   'MCU-3000, APCI-8001 only: read interface status
Declare Function rdifsb Lib "MCUG3.DLL" (ByVal an As Long, ByVal bitnr As Long) As Long
                                                    'MCU-3000, APCI-8001 only: read interface status bit
Declare Sub rddigo Lib "MCUG3.DLL" (DTSRP As TSRP)  'MCU-3000, APCI-8001 only: read digital outputs
Declare Function rddigob Lib "MCUG3.DLL" (ByVal an As Long, ByVal bitnr As Long) As Long
                                                    'MCU-3000, APCI-8001 only: read digital output bit
Declare Sub rdasmi Lib "MCUG3.DLL" (DTSRP As TSRP)  'MCU-6000, APCI-8401 only: read ASM digital inputs
Declare Function rdasmib Lib "MCUG3.DLL" (ByVal an As Long, ByVal bitnr As Long) As Long
                                                    'MCU-6000, APCI-8401 only: read ASM digital input bit
Declare Sub rdasms Lib "MCUG3.DLL" (DTSRP As TSRP)  'MCU-6000, APCI-8401 only: read ASM status
Declare Function rasmsb Lib "MCUG3.DLL" (ByVal an As Long, ByVal bitnr As Long) As Long
                                                    'MCU-6000, APCI-8401 only: read ASM status bit
Declare Sub rdepc Lib "MCUG3.DLL" (DTSRP As TSRP)   'MCU-6000, APCI-8401 only: read eeprom programming cycle
Declare Sub rdasmepc Lib "MCUG3.DLL" (DTSRP As TSRP)
                                                    'MCU-6000, APCI-8401 only: read ASM eeprom programming cycle
Declare Sub rdasmo Lib "MCUG3.DLL" (DTSRP As TSRP)  'MCU-6000, APCI-8401 only: read ASM digital outputs
Declare Function rdasmob Lib "MCUG3.DLL" (ByVal an As Long, ByVal bitnr As Long) As Long
                                                    'MCU-6000, APCI-8401 only: read ASM digital output bit
Declare Sub rdlsm Lib "MCUG3.DLL" (DTSRP As TSRP)   'read left spool memory
Declare Sub rdaxst Lib "MCUG3.DLL" (DTSRP As TSRP)  'read axis status
Declare Function rdaxstb Lib "MCUG3.DLL" (ByVal an As Long, ByVal bitnr As Long) As Long
                                                    'read axis status bit
Declare Sub rdjac Lib "MCUG3.DLL" (DTSRP As TSRP)   'read jog acceleration
Declare Sub rdjvl Lib "MCUG3.DLL" (DTSRP As TSRP)   'read jog velocity
Declare Sub rdjtvl Lib "MCUG3.DLL" (DTSRP As TSRP)  'read jog target velocity
Declare Sub rdhac Lib "MCUG3.DLL" (DTSRP As TSRP)   'read home acceleration
Declare Sub rdhvl Lib "MCUG3.DLL" (DTSRP As TSRP)   'read home velocity
Declare Sub cl Lib "MCUG3.DLL" (DASEL As ASEL)      'close loop
Declare Sub ol Lib "MCUG3.DLL" (DASEL As ASEL)      'open loop
Declare Sub ra Lib "MCUG3.DLL" (DASEL As ASEL)      'reset axis
Declare Sub rifs Lib "MCUG3.DLL" (DTSRP As TSRP)    'MCU-3000, APCI-8001 only: reset interface status flags
Declare Sub rasms Lib "MCUG3.DLL" (DTSRP As TSRP)   'MCU-6000, APCI-8401 only: reset ASM status flags
Declare Sub rs Lib "MCUG3.DLL" ()                   'reset system
Declare Sub azo Lib "MCUG3.DLL" (ByVal set_ As Long)
                                                    'activate zero offset
Declare Sub jr Lib "MCUG3.DLL" (DASEL As ASEL, DTSRP As TSRP)
                                                    'jog relative
Declare Sub ja Lib "MCUG3.DLL" (DASEL As ASEL, DTSRP As TSRP)
                                                    'jog absolute
Declare Sub jhl Lib "MCUG3.DLL" (DASEL As ASEL)     'jog home left
Declare Sub jhr Lib "MCUG3.DLL" (DASEL As ASEL)     'jog home right
Declare Sub jhi Lib "MCUG3.DLL" (DASEL As ASEL, TSRP As TSRP)
                                                    'jog relative (to) index
Declare Sub mlr Lib "MCUG3.DLL" (DASEL As ASEL, lmp As lmp)
                                                    'move linear relative
Declare Sub mla Lib "MCUG3.DLL" (DASEL As ASEL, lmp As lmp)
                                                    'move linear absolute
Declare Sub mcr Lib "MCUG3.DLL" (DASEL As ASEL, CMP As CMP)
                                                    'move circular relative
Declare Sub mca Lib "MCUG3.DLL" (DASEL As ASEL, CMP As CMP)
                                                    'move circular absolute
Declare Sub mhr Lib "MCUG3.DLL" (DASEL As ASEL, HMP As HMP)
                                                    'move helix relative
Declare Sub mha Lib "MCUG3.DLL" (DASEL As ASEL, HMP As HMP)
                                                    'move helix absolute
Declare Sub mca3d Lib "MCUG3.DLL" (DASEL As ASEL, HMP3D As HMP3D)
                                                    'move circular 3d absolute
Declare Sub mcr3d Lib "MCUG3.DLL" (DASEL As ASEL, HMP3D As HMP3D)
                                                    'move circular 3d relativ
Declare Sub smlr Lib "MCUG3.DLL" (DASEL As ASEL, lmp As lmp)
                                                    'spool motion linear relative
Declare Sub smla Lib "MCUG3.DLL" (DASEL As ASEL, lmp As lmp)
                                                    'spool motion linear absolute
Declare Sub smcr Lib "MCUG3.DLL" (DASEL As ASEL, CMP As CMP)
                                                    'spool motion circular relative
Declare Sub smca Lib "MCUG3.DLL" (DASEL As ASEL, CMP As CMP)
                                                    'spool motion circular absolute
Declare Sub smhr Lib "MCUG3.DLL" (DASEL As ASEL, HMP As HMP)
                                                    'spool motion helix relative
Declare Sub smha Lib "MCUG3.DLL" (DASEL As ASEL, HMP As HMP)
                                                    'spool motion helix absolute
Declare Sub smca3d Lib "MCUG3.DLL" (DASEL As ASEL, HMP3D As HMP3D)
                                                    'spooled move circular 3d absolute
Declare Sub smcr3d Lib "MCUG3.DLL" (DASEL As ASEL, HMP3D As HMP3D)
                                                    'spooled move circular 3d relativ
Declare Sub ssms Lib "MCUG3.DLL" (DASEL As ASEL)    'start spooled motions synchronous
Declare Sub sstps Lib "MCUG3.DLL" (DASEL As ASEL)   'stop spooled motions synchronous
Declare Sub sdels Lib "MCUG3.DLL" (DASEL As ASEL)   'delete spooled motions synchronous
Declare Function txbf Lib "MCUG3.DLL" (ByVal filename As String) As Long
                                                    'transmit binary file
Declare Function txbf2 Lib "MCUG3.DLL" (ByVal filename As String) As Long
                                                    'transmit binary file, 2nd method
Declare Sub startcnct Lib "MCUG3.DLL" (ByVal TaskNr As Long)
                                                    'start cnc task
Declare Sub stopcnct Lib "MCUG3.DLL" (ByVal TaskNr As Long)
                                                    'stop cnc task
Declare Sub contcnct Lib "MCUG3.DLL" (ByVal TaskNr As Long)
                                                    'continue cnc task
Declare Sub stepcnct Lib "MCUG3.DLL" (ByVal TaskNr As Long)
                                                    'step cnc task
Declare Sub rdcncts Lib "MCUG3.DLL" (ByVal TaskNr As Long, CNCTS As CNCTS)
                                                    'read cnc task status
Declare Sub rdcbcnct Lib "MCUG3.DLL" (DCBCNCT As CBCNCT)
                                                    'read cnc task spec. common buffer
Declare Sub wrcbcnct Lib "MCUG3.DLL" (DCBCNCT As CBCNCT)
                                                    'write cnc task spec. common buffer
Declare Sub rdci Lib "MCUG3.DLL" (ByVal ndx As Long, CIBUF As CIBUF)
                                                    'read common integer
Declare Sub rdcd Lib "MCUG3.DLL" (ByVal ndx As Long, CDBUF As CDBUF)
                                                    'read common double
Declare Sub wrci Lib "MCUG3.DLL" (ByVal ndx As Long, CIBUF As CIBUF)
                                                    'write common integer variables
Declare Sub wrcd Lib "MCUG3.DLL" (ByVal ndx As Long, CDBUF As CDBUF)
                                                    'write common double variables
Declare Sub rdmcp Lib "MCUG3.DLL" (DTSRP As TSRP)   'read motor command port
Declare Sub wrmcp Lib "MCUG3.DLL" (DTSRP As TSRP)   'write motor command port
Declare Sub wrledrd Lib "MCUG3.DLL" (ByVal value As Long)
                                                    'write led red
Declare Sub wrledyl Lib "MCUG3.DLL" (ByVal value As Long)
                                                    'write led yellow
Declare Sub wrledgn Lib "MCUG3.DLL" (ByVal value As Long)
                                                    'read led green
Declare Function rdledrd Lib "MCUG3.DLL" () As Long 'read led red
Declare Function rdledyl Lib "MCUG3.DLL" () As Long 'read led yellow
Declare Function rdledgn Lib "MCUG3.DLL" () As Long 'read led green
Declare Function rdirqpc Lib "MCUG3.DLL" () As Long 'read irq pc
Declare Sub mcuinit Lib "MCUG3.DLL" (DROSI As ROSI) 'MCU-G3 initialisition
Declare Sub mcuinit2 Lib "MCUG3.DLL" (DROSI As ROSI, ByVal TpuBaseAddress As Long)
                                                    'MCU-G3 initialisition, 2nd method
Declare Sub wrjovr Lib "MCUG3.DLL" (DTSRP As TSRP)  'write jog override
Declare Sub rdjovr Lib "MCUG3.DLL" (DTSRP As TSRP)  'read jog override
Declare Sub wrtrovr Lib "MCUG3.DLL" (value As Double)
                                                    'write trajectory override
Declare Sub rdtrovr Lib "MCUG3.DLL" (value As Double)
                                                    'read trajectory override
Declare Sub utrovr Lib "MCUG3.DLL" (DASEL As ASEL)  'update trajectory override
Declare Sub rdf Lib "MCUG3.DLL" (DTSRP As TSRP)     'read filter
Declare Sub rdap Lib "MCUG3.DLL" (DTSRP As TSRP)    'read axis parameters
Declare Sub rdsll Lib "MCUG3.DLL" (DTSRP As TSRP)   'read software limit left
Declare Sub wrsll Lib "MCUG3.DLL" (DTSRP As TSRP)   'write software limit left
Declare Sub rdslr Lib "MCUG3.DLL" (DTSRP As TSRP)   'read software limit right
Declare Sub wrslr Lib "MCUG3.DLL" (DTSRP As TSRP)   'write software limit right
Declare Sub rdipw Lib "MCUG3.DLL" (DTSRP As TSRP)   'read in position window
Declare Sub wripw Lib "MCUG3.DLL" (DTSRP As TSRP)   'write in position window
Declare Sub rdmpe Lib "MCUG3.DLL" (DTSRP As TSRP)   'read maximum position error
Declare Sub wrmpe Lib "MCUG3.DLL" (DTSRP As TSRP)   'write maximum position error
Declare Sub rdsdec Lib "MCUG3.DLL" (DTSRP As TSRP)  'read stop deceleration
Declare Sub wrsdec Lib "MCUG3.DLL" (DTSRP As TSRP)  'write stop deceleration
Declare Sub spd Lib "MCUG3.DLL" (ByVal an As Long, ByVal size As Long, SPDBUF As SPDBUF)
                                                    'spool position data
Declare Sub wrgf Lib "MCUG3.DLL" (DTSRP As TSRP)    'write gear factor
Declare Sub rdgf Lib "MCUG3.DLL" (DTSRP As TSRP)    'read gear factor
Declare Sub spvtd Lib "MCUG3.DLL" (ByVal an As Long, ByVal size As Long, SPVTDBUF As SPVTDBUF)
                                                    'spool position, velocity, time data
Declare Sub ms Lib "MCUG3.DLL" (DASEL As ASEL)      'motion stop
Declare Sub js Lib "MCUG3.DLL" (DASEL As ASEL)      'jog stop
Declare Sub lps Lib "MCUG3.DLL" (ByVal an As Long, ByVal mst As Long)
                                                    'latch position synchronous
Declare Sub rdigi Lib "MCUG3.DLL" (DTSRP As TSRP)   'MCU-3000, APCI-8001 only: reset digital inputs
Declare Sub rdlpndx Lib "MCUG3.DLL" (DTSRP As TSRP) 'MCU-3000, APCI-8001 only: read latched position index
Declare Sub wrlpndx Lib "MCUG3.DLL" (DTSRP As TSRP) 'MCU-3000, APCI-8001 only: write latched position index
Declare Sub ssf Lib "MCUG3.DLL" (ByVal an As Long, ByVal command As Long, ByVal value As Double)
                                                        ' Spooler-Special-Function-Command

Declare Function InitMcuSystem Lib "MCUG3.DLL" (DTSRP As TSRP) As Long
                                                    'initialisation function first method, (you should not use this function, instead use InitMcuSystem2() or even better InitMcuSystem3())
Declare Function InitMcuSystem2 Lib "MCUG3.DLL" (DTSRP As TSRP, ByVal TpuBaseAddress As Long, ByVal filename As String) As Long
                                                    'initialisation function, 2nd method
Declare Function InitMcuSystem3 Lib "MCUG3.DLL" (DTSRP As TSRP, DROSI As ROSI, ByVal TpuBaseAddress As Long, ByVal filename As String, BOARDTYPE As Long) As Long
                                                    'initialisation function, 3nd method
Declare Sub InitMcuErrorReport Lib "MCUG3.DLL" (ByVal error As Long)
                                                    'detailed initialisation error report function
Declare Sub txbfErrorReport Lib "MCUG3.DLL" (ByVal filename As String, ByVal error As Long)
                                                    'detailed load error report function
Declare Sub BootErrorReport Lib "MCUG3.DLL" (ByVal filename As String, ByVal error As Long)
                                                    'detailed boot error report function
Declare Sub McuClose Lib "MCUG3.DLL" ()             'close driver function, must be called at end of program !
Declare Function BootFile Lib "MCUG3.DLL" (ByVal filename As String, ByVal TpuBaseAddress As Long) As Long
                                                    'Send Bootfile (i.e. rwmos.elf) to controller board

Declare Sub LdSSplineA Lib "MCUG3.DLL" (DASEL As ASEL, lmp As lmp)
                                                    ' Load Spool Spline Data Absolut
Declare Sub LdSSplineR Lib "MCUG3.DLL" (DASEL As ASEL, lmp As lmp)
                                                    ' Load Spool Spline Data Relativ
Declare Sub ExeSSpline Lib "MCUG3.DLL" (DASEL As ASEL, lmp As lmp)
                                                    ' Execute Spool Spline

Declare Function wrOptionInt Lib "MCUG3.DLL" (odesc As OptionDescriptorObject, val As Long) As Long
                                                    ' Option Object write integer function
Declare Function rdOptionInt Lib "MCUG3.DLL" (odesc As OptionDescriptorObject, val As Long) As Long
                                                    ' Option Object read integer function
Declare Function wrOptionDbl Lib "MCUG3.DLL" (odesc As OptionDescriptorObject, val As Double) As Long
                                                    ' Option Object write double function
Declare Function rdOptionDbl Lib "MCUG3.DLL" (odesc As OptionDescriptorObject, val As Double) As Long
                                                    ' Option Object read double function
Declare Function freeOptionHandle Lib "MCUG3.DLL" (odesc As OptionDescriptorObject) As Long
                                                    ' Option Object free handle

Declare Function rdScannerBufferSize Lib "MCUG3.DLL" () As Long
                                                    ' Read size of scan buffer
Declare Function rdScannerStatus Lib "MCUG3.DLL" () As Long
                                                    ' read scanner status register
Declare Function rdScannerLsm Lib "MCUG3.DLL" () As Long
                                                    ' read scanner left spool memory
Declare Function rdScannerBuffer Lib "MCUG3.DLL" (buffer As String, ByVal size As Long) As Long
                                                    ' read scanner buffer


'  +---------------------------------------------------------------------------------+
'  |    Prototypes for client and application specific functions,                    |
'  |    do not use when you have no information about the individual functions !!!   |
'  |    (normaly you should not need that functions)                                 |
'  +---------------------------------------------------------------------------------+

Declare Sub wrBlk Lib "MCUG3.DLL" (buffer As String)    ' Common Write Command without return value (internal function)
Declare Sub rdBlk Lib "MCUG3.DLL" (buffer As String)    ' Common Read Command
Declare Sub wrtp Lib "MCUG3.DLL" (DTSRP As TSRP)        ' write target position
Declare Sub rdrpd Lib "MCUG3.DLL" (DTSRP As TSRP)       ' read real position display
Declare Sub rddpd Lib "MCUG3.DLL" (DTSRP As TSRP)       ' read desired position display
Declare Sub rdtpd Lib "MCUG3.DLL" (DTSRP As TSRP)       ' read target position display
Declare Sub scp Lib "MCUG3.DLL" (ByVal an As Long, DCTRLRPARAMS As CTRLRPARAMS)
                                                        ' set controller parameters
Declare Sub wrcv Lib "MCUG3.DLL" (an As Long, value As Double)
                                                        ' write command velocity
Declare Sub rdcv Lib "MCUG3.DLL" (an As Long, value As Double)
                                                        ' read command velocity
Declare Sub cm Lib "MCUG3.DLL" (an As Long, value As Long)
                                                        ' change mode
Declare Sub spd2d Lib "MCUG3.DLL" (DSPD2DPARAMS As SPD2DPARAMS)
                                                        ' spool position datas 2D
Declare Sub rdlrpr Lib "MCUG3.DLL" (DLATCH_INFOS As LATCH_INFOS, buffer As String)
                                                        ' read latched real pos. registers
Declare Sub rdldpr Lib "MCUG3.DLL" (DLATCH_INFOS As LATCH_INFOS, buffer As String)
                                                        ' read latched desired pos. registers
Declare Sub getcnctsrclinenr Lib "MCUG3.DLL" (TaskNr As Long, LineNr As Long)
                                                        ' read in current linenumber beeing processed of selected cnc task
Declare Function getmsgstr Lib "MCUG3.DLL" (an As Long, result As String) As Long
                                                        ' read in internal MCU-G3 debug-string
Declare Sub getcnctfh Lib "MCUG3.DLL" (TaskNr As Long, DFILEHEADER As FILEHEADER)
                                                        ' read in CNC-task-fileheader of selected cnc task
Declare Sub burnaplpar Lib "MCUG3.DLL" (an As Long)     ' burn appliance parameters
Declare Sub gettimers Lib "MCUG3.DLL" (DTSRP As TSRP, an As Long)
                                                        ' read in several debug-timers of high-prior task
Declare Sub lpr Lib "MCUG3.DLL" (LATCH_INFOS As LATCH_INFOS)
                                                        ' latch position registers
Declare Sub lprs Lib "MCUG3.DLL" (DASEL As ASEL, DLATCH_INFOS As LATCH_INFOS)
                                                        ' latch position registers synchronous on several axis
Declare Sub olsr Lib "MCUG3.DLL" (DOLSR_INFOS As OLSR_INFOS)
                                                        ' open loop system response
Declare Sub rdasmecs Lib "MCUG3.DLL" (DTSRP As TSRP, an As Long)
                                                        ' MCU-6000, APCI-8401 only: read in ASM eprom checksum of firmware
Declare Sub ReadLinkStatus Lib "MCUG3.DLL" (fae As Long, ba As Long)
                                                        ' read current link stati
Declare Function rdAin Lib "MCUG3.DLL" (ByVal an As Long, ByVal channel As Long) As Long
                                                        ' MCU-3000, APCI-8001 only: read Analog Inputs from OPMF-3001
Declare Sub szpa Lib "MCUG3.DLL" (ByVal an As Long, ByVal Position As Double)
                                                        ' Set Zero Position relativ
Declare Sub szpr Lib "MCUG3.DLL" (ByVal an As Long, ByVal Position As Double)
                                                        ' Set Zero Position absolut
Declare Sub rdMcuStatus Lib "MCUG3.DLL" (buffer As String, ByVal size As Long)
                                                        ' read in MCU G3 status registers
Declare Sub rdAsmSecureParams Lib "MCUG3.DLL" (ByVal an As Long, buffer As String)
                                                        ' MCU-6000, APCI-8401 only: read ASM-EEPROM parameters (firmware data)
Declare Sub wrAsmSecureParams Lib "MCUG3.DLL" (ByVal an As Long, buffer As String)
                                                        ' MCU-6000, APCI-8401 only: write ASM-EEPROM parameters (firmware data)

Declare Sub wrModeReg Lib "MCUG3.DLL" (ByVal value As Long)
                                                    'write Mode Register
Declare Sub rdModeReg Lib "MCUG3.DLL" (ByVal value As Long)
                                                    'read Mode Register
Declare Sub wrMDVel Lib "MCUG3.DLL" (an As Long, ByVal value As Double)
                                                    'write Maximum Delta Velocity at axis
Declare Sub rdMDVel Lib "MCUG3.DLL" (an As Long, ByVal value As Double)
                                                    'read Maximum Delta Velocity from axis
Declare Sub wrMaxVel Lib "MCUG3.DLL" (an As Long, ByVal value As Double)
                                                    'write Maximum Axis Velocity at axis
Declare Sub rdMaxVel Lib "MCUG3.DLL" (an As Long, ByVal value As Double)
                                                    'read Maximum Axis Velocity from axis
Declare Sub wrMaxAcc Lib "MCUG3.DLL" (an As Long, ByVal value As Double)
                                                    'write Maximum Axis Acceleration at axis
Declare Sub rdMaxAcc Lib "MCUG3.DLL" (an As Long, ByVal value As Double)
                                                    'read Maximum Axis Acceleration from axis
Declare Sub MsgToScreen Lib "MCUG3.DLL" (ByVal Enable As Long)
                                                    'enable / disable screen messages

