{
  +-----------------------------------------------------------------------+
  | (C) Roesch & Walter Industrie-Elektronik GmbH                         |
  | Im Heidenwinkel 5            D-77963 Schwanau                         |
  +-------------------------------+---------------------------------------+
  | Tel : +49 (0) 7824/6628-0     | email    : support@rw-gmbh.de         |
  | Fax : +49 (0) 7824/6628-29    | Internet : http://www.rw-gmbh.de      |
  +-------------------------------+---------------------------------------+
  | Project     : MCUG3 TOOLSET   | Compiler : BORLAND Delphi 4           |
  |                               |                                       |
  | Module name : sample100.pas   | Operating System:                     |
  |                               |            - Windows 95/98/Me         |
  |                               |            - Windows NT 4.0           |
  |                               |            - Windows NT Embedded 4.0  |
  |                               |            - Windows 2000             |
  +-------------------------------+---------------------------------------+
  | Author : Roesch R.               Date :21/05/2001                     |
  |          Walter M.                                                    |
  +-----------------------------------------------------------------------+
  | Description   : Sample Program File for the                           |
  |                 High-Performance Motion-Control Family Generation 3   |
  |                                                                       |
  |                 Currently supported G3-Controllers:                   |
  |                         MCU-3000, APCI-8001, MCU-6000 and APCI-8401   |
  |                                                                       |
  |                                                                       |
  +-----------------------------------------------------------------------+

	Revision History:
	-----------------
    21/05/2001	V2-50	rr  Variable Axis Selection introduced


    !!! Attention !!!:
    -----------------

    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    you must setup below -  SYSFILENAME and BOOTFILENAME
    according your requirements
    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


}

unit sample100;


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, TabNotBk, ComCtrls,
  mcug3;

const
//   SYSFILENAME  = 'SYSTEM.DAT';     { please fill out with correct values }
//   BOOTFILENAME = 'RWTOS.BTL';      { please fill out with correct values }
     BASEADDRESS = $0;               { Currently not used, only for MCUG2 compatibilty }
                                     { Setup SYSFILENAME and BOOTFILENAME according your TOOLSET Seetup }

     SYSFILENAME  = 'L:\MCUG3\RWMOS\MCFG\SYSTEM MCU3000 Schrank.DAT';
     BOOTFILENAME = 'L:\MCUG3\RWMOS\MCU3000\RWMOS.ELF';

type
  TSample100Frm = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    JogLeft: TSpeedButton;
    JogRight: TSpeedButton;
    JogStop: TSpeedButton;
    GroupBox3: TGroupBox;
    rp: TLabel;
    dp: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    GroupBox4: TGroupBox;
    AxisSelection: TComboBox;
    GroupBox2: TGroupBox;
    LedGn: TCheckBox;
    LedYl: TCheckBox;
    LedRd: TCheckBox;
    boot: TButton;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure JogLeftClick(Sender: TObject);
    procedure JogRightClick(Sender: TObject);
    procedure JogStopClick(Sender: TObject);
    procedure AxisSelectionChange(Sender: TObject);
    procedure LedGnClick(Sender: TObject);
    procedure LedYlClick(Sender: TObject);
    procedure LedRdClick(Sender: TObject);
    procedure bootClick(Sender: TObject);
    procedure Init;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private-Deklarationen }
    McuError: integer;
    McuOk: boolean;
    tsrp_: TSRPSETS;
    SelectedAxis: integer;
    procedure UpdateLedStatus;
  public
    { Public-Deklarationen }
  end;

var
  Sample100Frm: TSample100Frm;
  buffer_x : POSBUF;
  buffer_y : POSBUF;
  buffer_z : POSBUF;

implementation

{$R *.DFM}

function	getcnctsrclinenr(var TaskNr:longint; Var LineNr:longint):longint; far; external 'MCUDLL';


procedure TSample100Frm.UpdateLedStatus;
begin
   if (McuOk) then begin
      LedGn.Checked := (rdledgn <> 0);
      LedYl.Checked := (rdledyl <> 0);
      LedRd.Checked := (rdledrd <> 0);
   end;
end;

procedure TSample100Frm.Init;
var i, boardtype : integer;
var rosi_: ROSI;
begin
   Screen.Cursor := crHourGlass;
   {MCU-Initialisation: TPU-Base-Address: $300, System-File: SYSTEM.DAT in specified directory }
   McuError := InitMcuSystem3(tsrp_, rosi_, BASEADDRESS, SYSFILENAME, boardtype);
   Screen.Cursor := crDefault;

   { Show result of Initialisation }
   Label1.caption  := 'InitMcuSystem3()-Result: ' + InttoStr(McuError);

   McuOk := (McuError = 0);

   if (not McuOk) then  rosi_.number_axis := 1;

   AxisSelection.Items.Clear();
   for i := 1 to rosi_.number_axis do
      AxisSelection.Items.Add('Axis ' + IntToStr(i));
   AxisSelection.ItemIndex := 0;

   JogLeft.Enabled  := McuOk;
   JogRight.Enabled := McuOk;
   JogStop.Enabled  := McuOk;
   JogLeft.ShowHint := McuOk;
   JogRight.ShowHint:= McuOk;
   JogStop.ShowHint := McuOk;
   LedGn.Enabled    := McuOk;
   LedYl.Enabled    := McuOk;
   LedRd.Enabled    := McuOk;
end;

procedure TSample100Frm.Timer1Timer(Sender: TObject);
begin
     { Cyclic show actual and desired position of selected axis channel }
     if (McuOk) then begin
        rdrp(tsrp_[SelectedAxis]);
        rddp(tsrp_[SelectedAxis]);
        rp.caption := FormatFloat('0.00000000E+00', tsrp_[SelectedAxis].rp);
        dp.caption := FormatFloat('0.00000000E+00', tsrp_[SelectedAxis].dp);
        UpdateLedStatus;
     end;
end;

procedure TSample100Frm.JogLeftClick(Sender: TObject);
var las_: AS_;
begin
     if (McuOk) then begin
        las_.unoa := 1;                        { Use one axis }
        las_.san[0] := SelectedAxis;           { specify selected axis channel }
        cl(las_);                              { close loop of selected axis channel }
        tsrp_[SelectedAxis].tp := -100.0;
        jr(las_, tsrp_);                    { jog 100 into left direction}
     end;
end;

procedure TSample100Frm.JogRightClick(Sender: TObject);
var las_: AS_;
begin
     if (McuOk) then begin
        las_.unoa := 1;
        las_.san[0] := SelectedAxis;
        cl(las_);
        tsrp_[SelectedAxis].tp := +100.0;
        jr(las_, tsrp_);
     end;
end;

procedure TSample100Frm.JogStopClick(Sender: TObject);
var las_: AS_;
begin
     if (McuOk) then begin
        las_.unoa := 1;
        las_.san[0] := SelectedAxis;
        js(las_);
     end;
end;

procedure TSample100Frm.AxisSelectionChange(Sender: TObject);
begin
     { Select an axis channel, currently only axis 1 and 2 are possible }
     SelectedAxis := AxisSelection.ItemIndex;
     GroupBox1.Caption := 'Axis ' + IntToStr(SelectedAxis+1) + ' Jog demo';
end;

procedure TSample100Frm.LedGnClick(Sender: TObject);
begin
     if (McuOk) then begin
          if (LedGn.Checked) then wrledgn(1)
          else wrledgn(0);
     end;
end;

procedure TSample100Frm.LedYlClick(Sender: TObject);
begin
     if (McuOk) then begin
          if (LedYl.Checked) then wrledyl(1)
          else wrledyl(0);
     end;
end;

procedure TSample100Frm.LedRdClick(Sender: TObject);
begin
     if (McuOk) then begin
          if (LedRd.Checked) then wrledrd(1)
          else wrledrd(0);
     end;
end;

procedure TSample100Frm.bootClick(Sender: TObject);
var error: integer;
begin
     Screen.Cursor := crHourglass;
     error := BootFile(BOOTFILENAME, BASEADDRESS);
     Screen.Cursor := crDefault;
     if (error <> 0) then begin
         MessageDlg('Boot Error: ' + IntToStr(error), mtError, [mbOk], 0);
     end else Init;
end;



procedure TSample100Frm.FormCreate(Sender: TObject);
begin
   Init;
   AxisSelection.ItemIndex := 0;
   AxisSelectionChange(Sender);
end;


procedure TSample100Frm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   McuClose;                       { close link }
end;



end.
