//-------------------------------------------------------------------
// Include-File for MCU-G3 TC-Functions
// SAP-Programming language
// This file contains the declarations only for one Table (Table 0)
// for additional tables index must be incremented
// Last change: 13.11.2012
// Index 0 1 2 3 refer to Tables 0..3
// 	0 = All Tables
// 	1 = Table for G17 in McuWIN
// 	2 = Table for G18 in McuWIN
// 	3 = Table for G19 in McuWIN
//-------------------------------------------------------------------

const TcBus 	= 1300;
const	TcFunction	= 0;
const	TcDevice	= 1;

// Tc-Functions
// release old MCU-G3 Tc handles
var 	FTcClean_w:  			integer AT %QDTcBus.TcFunction.1.0;	
var 	FTcXAxNr_w:  			integer AT %QDTcBus.TcFunction.2.0;	
var 	FTcYAxNr_w:  			integer AT %QDTcBus.TcFunction.2.1;	
var 	FTcZAxNr_w:  			integer AT %QDTcBus.TcFunction.2.2;	
var 	FTcXAxNr_r:  			integer AT %IDTcBus.TcFunction.2.0;	
var 	FTcYAxNr_r:  			integer AT %IDTcBus.TcFunction.2.1;	
var 	FTcZAxNr_r:  			integer AT %IDTcBus.TcFunction.2.2;	
var 	FTcPlane_w:  			integer AT %QDTcBus.TcFunction.3.0;	
var 	FTcPlane_r:  			integer AT %IDTcBus.TcFunction.3.0;	
var 	FTcInit_w:  			integer AT %QDTcBus.TcFunction.11.0;	

// Tc Parameters for different Tables
var TcError_r	:			integer  AT %IDTcBus.TcDevice.0.1;	
var TcError17_r	:			integer  AT %IDTcBus.TcDevice.1.1;	
var TcError18_r	:			integer  AT %IDTcBus.TcDevice.2.1;	
var TcError19_r	:			integer  AT %IDTcBus.TcDevice.3.1;
	
var TcError_w	:			integer  AT %QDTcBus.TcDevice.0.1;	
	
var TcReset_w	:			integer  AT %QDTcBus.TcDevice.0.2;	
var TcReset17_w	:			integer  AT %QDTcBus.TcDevice.1.2;	
var TcReset18_w	:			integer  AT %QDTcBus.TcDevice.2.2;	
var TcReset19_w	:			integer  AT %QDTcBus.TcDevice.3.2;
	
var TcMode_r	:			integer  AT %IDTcBus.TcDevice.0.3;	
var TcMode17_r	:			integer  AT %IDTcBus.TcDevice.1.3;	
var TcMode18_r	:			integer  AT %IDTcBus.TcDevice.2.3;	
var TcMode19_r	:			integer  AT %IDTcBus.TcDevice.3.3;
	
var TcMode_w	:			integer  AT %QDTcBus.TcDevice.0.3;	
var TcMode17_w	:			integer  AT %QDTcBus.TcDevice.1.3;	
var TcMode18_w	:			integer  AT %QDTcBus.TcDevice.2.3;	
var TcMode19_w	:			integer  AT %QDTcBus.TcDevice.3.3;
	
var TcXAxis_w	:			integer  AT %QDTcBus.TcDevice.0.4;	
var TcXAxis17_w	:			integer  AT %QDTcBus.TcDevice.1.4;	
var TcXAxis18_w	:			integer  AT %QDTcBus.TcDevice.2.4;	
var TcXAxis19_w	:			integer  AT %QDTcBus.TcDevice.3.4;
	
var TcYAxis_w	:			integer  AT %QDTcBus.TcDevice.0.5;	
var TcYAxis17_w	:			integer  AT %QDTcBus.TcDevice.1.5;	
var TcYAxis18_w	:			integer  AT %QDTcBus.TcDevice.2.5;	
var TcYAxis19_w	:			integer  AT %QDTcBus.TcDevice.3.5;	

var TcAxWord_r	:			integer  AT %IDTcBus.TcDevice.0.6;

var TcIndex_r	:			integer  AT %IDTcBus.TcDevice.0.8;
var TcIndex17_r	:			integer  AT %IDTcBus.TcDevice.1.8;
var TcIndex18_r	:			integer  AT %IDTcBus.TcDevice.2.8;
var TcIndex19_r	:			integer  AT %IDTcBus.TcDevice.3.8;

var TcIndex_w	:			integer  AT %QDTcBus.TcDevice.0.8;
var TcIndex17_w	:			integer  AT %QDTcBus.TcDevice.1.8;
var TcIndex18_w	:			integer  AT %QDTcBus.TcDevice.2.8;
var TcIndex19_w	:			integer  AT %QDTcBus.TcDevice.3.8;

var TcRadius_w	:			double   AT %QRTcBus.TcDevice.0.7;		// Radiuskorrektur - = links / + = rechts
var TcRadius_r	:			double   AT %IRTcBus.TcDevice.0.7;		// Radiuskorrektur - = links / + = rechts
var TcRadius17_r	:			double   AT %IRTcBus.TcDevice.1.7;		// Radiuskorrektur - = links / + = rechts

var TcLeft_w	:			integer  AT %QDTcBus.TcDevice.0.9;
var TcLeft17_w	:			integer  AT %QDTcBus.TcDevice.1.9;
var TcLeft18_w	:			integer  AT %QDTcBus.TcDevice.2.9;
var TcLeft19_w	:			integer  AT %QDTcBus.TcDevice.3.9;

var TcRight_w	:			integer  AT %QDTcBus.TcDevice.0.10;
var TcRight17_w	:			integer  AT %QDTcBus.TcDevice.1.10;
var TcRight18_w	:			integer  AT %QDTcBus.TcDevice.2.10;
var TcRight19_w	:			integer  AT %QDTcBus.TcDevice.3.10;

// Koordinate Rotation
var RotAngle_w	        :		double   AT %QRTcBus.TcFunction.20.0;           // Rotationswinkel schreiben
var RotAngle_r	        :		double   AT %IRTcBus.TcFunction.20.0;           // Rotationswinkel lesen
var RotCenterX_w	:		double   AT %QRTcBus.TcFunction.21.0;           // Rotationspunkt 1. Achse in Hauptebene schreiben
var RotCenterX_r	:		double   AT %IRTcBus.TcFunction.21.0;           // Rotationspunkt 1. Achse in Hauptebene lesen
var RotCenterY_w	:		double   AT %QRTcBus.TcFunction.22.0;           // Rotationspunkt 2. Achse in Hauptebene schreiben
var RotCenterY_r	:		double   AT %IRTcBus.TcFunction.22.0;           // Rotationspunkt 2. Achse in Hauptebene lesen

