//---------------------------------------------------------------------------------------------------------------------
// Include-File for MCU-G3 PCI-Busmaster-Functions
// SAP-Programming language

// If you need other resources 
// please contact support@rw-gmbh.de for an updated resource file.
// Last change:
// 2015-06-19	Declarations for APCI3003 added
// 2010-02-26	Declarations for APCI1032 added 
// 2008-09-10   Declarations for APCI3501 added
//---------------------------------------------------------------------------------------------------------------------


//---------------------------------------------------------------------------------------------------------------------
// generic PCI bus declarations
//---------------------------------------------------------------------------------------------------------------------
const PciBusIO				= 100;		// Pci-IO-BusNumber (local PCI bus)
									// attention: The MCU-G3 is maybe located on a remote PCI bus
const PciBusMEM				= 200;		// Pci-MEM-BusNumber (local PCI bus)
									// attention: The MCU-G3 is maybe located on a remote PCI bus
var ControlPciBus_w:  			integer AT %QDPciBusIO.$0.$100.$0;	
									// this is a command control register over PCI function


//---------------------------------------------------------------------------------------------------------------------
// APCI-1032 declarations (32 Digital Inputs)
//---------------------------------------------------------------------------------------------------------------------
const DeviceIdAPCI1032			= $15B81003;	// Vendor ID (hex 15B8) and Device ID (hex 1003) for APCI-1032
const CardNrBaseRegIOAPCI1032		= $00010001;	// MS half word is counted CardNr (first card has Nr. 1)
									// LS half word is Map-Register (first Map address register is 0)
									// Base Address Register 2 contains the MAP Base-Address
									// for accessing the I/O-Space

var APCI1032DigInputs_r: 		integer AT %IDPciBusIO.DeviceIdAPCI1032.CardNrBaseRegIOAPCI1032.0;
									// The MAP Address of APCI-1032 digital inputs 
									// has a byte offset of 0 and is a word (4byte)

//---------------------------------------------------------------------------------------------------------------------
// APCI-1016 declarations (16 Digital Inputs)
//---------------------------------------------------------------------------------------------------------------------
const DeviceIdAPCI1016			= $15B81000;	// Device ID (hex 1000) and Vendor ID (hex 15B8) for APCI-1016
const CardNrBaseRegIOAPCI1016		= $00010001;	// MS half word is counted CardNr (first card has Nr. 1)
									// LS half word is Map-Register (first Map address register is 0)
									// Base Address Register 2 contains the MAP Base-Address
									// for accessing the I/O-Space

var APCI1016DigInputs_r: 		integer AT %IWPciBusIO.DeviceIdAPCI1016.CardNrBaseRegIOAPCI1016.0;
									// The MAP Address of APCI-1016 digital inputs 
									// has a byte offset of 0 and is a half word (2byte)

//---------------------------------------------------------------------------------------------------------------------
// APCI-1500 declarations (16 Digital Inputs, 16 Digital Outputs)
//---------------------------------------------------------------------------------------------------------------------
const DeviceIdAPCI1500			= $10E880FC;	// Device ID (hex 80FC) and Vendor ID (hex 10E8) for APCI-1500
const CardNrBaseRegAPCI1500		= $00010002;	// MS half word is counted CardNr (first card has Nr. 1)
									// LS half word is Map-Register (first Map address register is 0)
									// Base Address Register 2 contains the MAP Base-Address
									// for accessing the I/O-Space

var APCI1500DigInputs_r: 		integer AT %IWPciBusIO.DeviceIdAPCI1500.CardNrBaseRegAPCI1500.0;
									// The MAP Address of digital inputs has a byte offset of 0
var APCI1500DigOutputs_w: 		integer AT %QWPciBusIO.DeviceIdAPCI1500.CardNrBaseRegAPCI1500.2;
									// The MAP Address of digital ouputs has a byte offset of 2

//---------------------------------------------------------------------------------------------------------------------
// APCI-1564 declarations (32 Digital Inputs, 32 Digital Outputs)
//---------------------------------------------------------------------------------------------------------------------
const DeviceIdAPCI1564			= $15B81006;	// Vendor ID (hex 15B8) and Device ID (hex 1006) for APCI-1564
const CardNrBaseRegAPCI1564		= $00010000;	// MS half word is counted CardNr (first card has Nr. 1)
									// LS half word is Map-Register (first Map address register is 0)
									// Base Address Register 0 contains the MAP Base-Address
									// for accessing the I/O-Space

var APCI1564DigInputs_r: 		integer AT %IDPciBusIO.DeviceIdAPCI1564.CardNrBaseRegAPCI1564.4;
									// The MAP Address of digital inputs has a byte offset of 4
var APCI1564DigOutputs_w: 		integer AT %QDPciBusIO.DeviceIdAPCI1564.CardNrBaseRegAPCI1564.24;
									// The MAP Address of digital ouputs has a byte offset of 24
var APCI1564DigOutputs_r: 		integer AT %IDPciBusIO.DeviceIdAPCI1564.CardNrBaseRegAPCI1564.24;
									// The MAP Address of digital ouputs has a byte offset of 24
var APCI1564EnaStatus_w: 		integer AT %QDPciBusIO.DeviceIdAPCI1564.CardNrBaseRegAPCI1564.28;
var APCI1564Status_r: 			integer AT %IDPciBusIO.DeviceIdAPCI1564.CardNrBaseRegAPCI1564.32;
									// Before every read the bits must be Enabled
									// Bit 0 = Vcc less than 7 V
									// Bit 1 = overcurrent or Temperature Overload

//---------------------------------------------------------------------------------------------------------------------
// APCI-3501 declarations (8 Analog Outputs 14 bit)
//---------------------------------------------------------------------------------------------------------------------
const DeviceIdAPCI3501			= $15B83001;	// Vendor ID ($15B8) and Device ID ($3001) for APCI-3501
const CardNrBaseRegAPCI3501		= $00010001;	// MS half word is counted CardNr (first card has Nr. 1)
							// LS half word is Map-Register (first Map address register is 0)
							// Base Address Register 0 contains the MAP Base-Address
							// for accessing the I/O-Space
var APCI3501AnalogOutputs_w: 		integer AT %QDPciBusIO.DeviceIdAPCI3501.CardNrBaseRegAPCI3501.4;
									// The MAP Address of Analog ouputs has a byte offset of 4
var APCI3501AnalogOutputs_r: 		integer AT %IDPciBusIO.DeviceIdAPCI3501.CardNrBaseRegAPCI3501.4;
									// The MAP Address of Analog ouputs has a byte offset of 4
var APCI3501VoltageMode_w: 		integer AT %QDPciBusIO.DeviceIdAPCI3501.CardNrBaseRegAPCI3501.0;
var APCI3501VoltageMode_r: 		integer AT %IDPciBusIO.DeviceIdAPCI3501.CardNrBaseRegAPCI3501.0;

//---------------------------------------------------------------------------------------------------------------------
// APCI-3003 declarations (14 diff Analog Inputs / 4 Digital Inputs / 4 Digital Outputs)
//---------------------------------------------------------------------------------------------------------------------
const DeviceIdAPCI3003			= $15B8300B;	// Device ID (hex 300B) and Vendor ID (hex 15B8) for APCI-3003
const CardNrBaseRegAPCI3003		= $00010002;	// MS half word is counted CardNr (first card has Nr. 1)
									// LS half word is Map-Register (first Map address register is 0)
									// Base Address Register 2 contains the MAP Base-Address
									// for accessing the I/O-Space

var APCI3003DigInputs_r: 		integer AT %IWPciBusIO.DeviceIdAPCI3003.CardNrBaseRegAPCI3003.32;
									// The MAP Address of digital inputs has a byte offset of 32
var APCI3003DigOutputs_w: 		integer AT %QWPciBusIO.DeviceIdAPCI3003.CardNrBaseRegAPCI3003.48;
									// The MAP Address of digital ouputs has a byte offset of 48
var APCI3003DigOutputs_r: 		integer AT %IWPciBusIO.DeviceIdAPCI3003.CardNrBaseRegAPCI3003.48;
									// The MAP Address of digital ouputs has a byte offset of 48



