//-------------------------------------------------------------------
// Include-File for MCU-G3 Resource-Functions
// SAP-Programming language

// If you need other resources 
// please contact support@rw-gmbh.de for an updated resource file.
//
//	29.01.2016 	new Ressources for GeoAdd Control (88 + 89)
// 	07.10.2015	new Resource EdgeBendingError
// 	24.08.2015	Mpe_HP_Timeout new
// 	06.07.2015	new Resource DISTSUMINDEX (write only)
//	28.05.2015	RTCP Register for Set # 1 added
//	16.12.2013	Register for Hardware Input Inversion readable
//	14.09.2012	APCI-3702 specific commands added (realtime scanning)
//	21.11.2008	mcpmax, mcpmin added
//	28.05.2008	FastPulseOutput commands added
//	30.08.2007	OsTrace specific commands added
//      05.07.2007      ENDAT 2.2 specific commands added, MRS codes added
//	04.05.2007	PA-3110 specific commands added (realtime scanning)
//	26.03.2007	APCI-3701 specific commands added (realtime scanning)
//	05.03.2007	Access to CNC-Task-Status added (Function 70)
//	17.11.2006	DTV[], PIR + PTP added
//	09.11.2005	APCI-3120 specific commands added (realtime scanning)
// 	02.05.2005	OPTOIO Hardware Rev. added
//	11.03.2005	Endat specific commands and defines added
//	02.08.2004	Spline Support functions added
//	24.05.2004	MaxMoveCommandsInSpooler added
//	11.05.2004	Resource for Access to AxisMirrorFlag added
//	06.05.2004	Resource for Access to ZeroOffsetTables added
//	30.04.2004	Resource for Host Memory Access added
//	13.11.2003	Resource for Sync-Mode added
//	13.03.2003	CI and CD added
//	15.10.2002	write digo added
//			GEAR constants to max. 8 Axes added
//	09.09.2002	aux added
//	11.06.2002	rv and dv (real and desired velocity) added
//	07.06.2002	digi and digo expanded from 3 to 8 Axes
//	29.04.2002	pe Position error new
//  	03.12.2001
//-------------------------------------------------------------------


const G3ResourceBus	= 1000;
const RtcpBUS		= 2100;
const APCI3120RO		= 3100;
const PA3110RO		= 3100; // by rwmos handled as APCI3120RO
const APCI3701RO		= 3200;
const APCI3702RO		= 3201;
const FuncSyncMode	= 7000;
const ResourceFunction	= 0;

// Resource: dp (desired position)
var G3R_dp_A1_r:	double  AT %IRG3ResourceBus.1.0.$0;	
var G3R_dp_A2_r:	double  AT %IRG3ResourceBus.1.1.$0;	
var G3R_dp_A3_r:	double  AT %IRG3ResourceBus.1.2.$0;	

// Resource: rp (real position)
var G3R_rp_A1_r:	double  AT %IRG3ResourceBus.2.0.$0;	
var G3R_rp_A2_r:	double  AT %IRG3ResourceBus.2.1.$0;	
var G3R_rp_A3_r:	double  AT %IRG3ResourceBus.2.2.$0;	

// Resource: pe (position error)
var G3R_pe_A1_r:	double  AT %IRG3ResourceBus.7.0.$0;	
var G3R_pe_A2_r:	double  AT %IRG3ResourceBus.7.1.$0;	
var G3R_pe_A3_r:	double  AT %IRG3ResourceBus.7.2.$0;	

// Resource: axst (axis status register)
var G3R_axst_A1_r: 	integer AT %IDG3ResourceBus.3.0.$0;	
var G3R_axst_A2_r: 	integer AT %IDG3ResourceBus.3.1.$0;	
var G3R_axst_A3_r: 	integer AT %IDG3ResourceBus.3.2.$0;	

// Resource: digi (digital inputs)
var G3R_digi_A1_r: 	integer AT %IDG3ResourceBus.4.0.$0;	
var G3R_digi_A2_r: 	integer AT %IDG3ResourceBus.4.1.$0;	
var G3R_digi_A3_r: 	integer AT %IDG3ResourceBus.4.2.$0;	
var G3R_digi_A4_r: 	integer AT %IDG3ResourceBus.4.3.$0;	
var G3R_digi_A5_r: 	integer AT %IDG3ResourceBus.4.4.$0;	
var G3R_digi_A6_r: 	integer AT %IDG3ResourceBus.4.5.$0;	
var G3R_digi_A7_r: 	integer AT %IDG3ResourceBus.4.6.$0;	
var G3R_digi_A8_r: 	integer AT %IDG3ResourceBus.4.7.$0;	

// Resource: read digo (digital outputs)
var G3R_digo_A1_r: 	integer AT %IDG3ResourceBus.6.0.$0;	
var G3R_digo_A2_r: 	integer AT %IDG3ResourceBus.6.1.$0;	
var G3R_digo_A3_r: 	integer AT %IDG3ResourceBus.6.2.$0;	
var G3R_digo_A4_r: 	integer AT %IDG3ResourceBus.6.3.$0;	
var G3R_digo_A5_r: 	integer AT %IDG3ResourceBus.6.4.$0;	
var G3R_digo_A6_r: 	integer AT %IDG3ResourceBus.6.5.$0;	
var G3R_digo_A7_r: 	integer AT %IDG3ResourceBus.6.6.$0;	
var G3R_digo_A8_r: 	integer AT %IDG3ResourceBus.6.7.$0;	

var G3R_FASTPULSEOUT_r: integer AT %IWG3ResourceBus.64.0.$0;	
var G3R_FASTPULSEOUT_w: integer AT %QWG3ResourceBus.64.0.$0;	

// Resource: write digo (digital outputs)
var G3R_digo_A1_w: 	integer AT %QDG3ResourceBus.6.0.$0;	
var G3R_digo_A2_w: 	integer AT %QDG3ResourceBus.6.1.$0;	
var G3R_digo_A3_w: 	integer AT %QDG3ResourceBus.6.2.$0;	
var G3R_digo_A4_w: 	integer AT %QDG3ResourceBus.6.3.$0;	
var G3R_digo_A5_w: 	integer AT %QDG3ResourceBus.6.4.$0;	
var G3R_digo_A6_w: 	integer AT %QDG3ResourceBus.6.5.$0;	
var G3R_digo_A7_w: 	integer AT %QDG3ResourceBus.6.6.$0;	
var G3R_digo_A8_w: 	integer AT %QDG3ResourceBus.6.7.$0;	

// Resource: scntr (sample time counter, increased every sample time)
var G3R_scntr_r: 		integer AT %IDG3ResourceBus.5.0.$0;

// Resource: actual trvl (trvl in the actual spooler command)
var G3R_trvl_A1_r:      double  AT %IRG3ResourceBus.8.0.$0;	
var G3R_trvl_A2_r: 	double  AT %IRG3ResourceBus.8.1.$0;	
var G3R_trvl_A3_r: 	double  AT %IRG3ResourceBus.8.2.$0;	
	

// Analog-Inputs
var G3R_ain_CH0_r: 	integer AT %IWG3ResourceBus.100.0.$0;	
var G3R_ain_CH1_r: 	integer AT %IWG3ResourceBus.100.1.$0;	
var G3R_ain_CH2_r: 	integer AT %IWG3ResourceBus.100.2.$0;	
var G3R_ain_CH3_r: 	integer AT %IWG3ResourceBus.100.3.$0;	
var G3R_ain_CH4_r: 	integer AT %IWG3ResourceBus.100.4.$0;	
var G3R_ain_CH5_r: 	integer AT %IWG3ResourceBus.100.5.$0;	
var G3R_ain_CH6_r: 	integer AT %IWG3ResourceBus.100.6.$0;	
var G3R_ain_CH7_r: 	integer AT %IWG3ResourceBus.100.7.$0;

// Latch-Strobes
var G3R_WTLSTRB0_r: 	integer AT %IWG3ResourceBus.101.0.$0;	
var G3R_WTLSTRB1_r: 	integer AT %IWG3ResourceBus.101.1.$0;	
var G3R_WTLSTRB2_r: 	integer AT %IWG3ResourceBus.101.2.$0;	
var G3R_WTLSTRB3_r: 	integer AT %IWG3ResourceBus.101.3.$0;	
var G3R_WTLSTRB4_r: 	integer AT %IWG3ResourceBus.101.4.$0;	
var G3R_WTLSTRB5_r: 	integer AT %IWG3ResourceBus.101.5.$0;	
var G3R_WTLSTRB6_r: 	integer AT %IWG3ResourceBus.101.6.$0;	
var G3R_WTLSTRB7_r: 	integer AT %IWG3ResourceBus.101.7.$0;

// Gear Constants
// Channel 0 - Col.0 - 8 Axis - write
var G3R_Gear_CH0_0_w: 	double AT %QRG3ResourceBus.200.0.$0;
var G3R_Gear_CH0_1_w: 	double AT %QRG3ResourceBus.200.0.$1;
var G3R_Gear_CH0_2_w: 	double AT %QRG3ResourceBus.200.0.$2;
var G3R_Gear_CH0_3_w: 	double AT %QRG3ResourceBus.200.0.$3;
var G3R_Gear_CH0_4_w: 	double AT %QRG3ResourceBus.200.0.$4;
var G3R_Gear_CH0_5_w: 	double AT %QRG3ResourceBus.200.0.$5;
var G3R_Gear_CH0_6_w: 	double AT %QRG3ResourceBus.200.0.$6;
var G3R_Gear_CH0_7_w: 	double AT %QRG3ResourceBus.200.0.$7;

// Channel 1 - Col.0 - 8 Axis - write
var G3R_Gear_CH1_0_w: 	double AT %QRG3ResourceBus.200.1.$0;
var G3R_Gear_CH1_1_w: 	double AT %QRG3ResourceBus.200.1.$1;
var G3R_Gear_CH1_2_w: 	double AT %QRG3ResourceBus.200.1.$2;
var G3R_Gear_CH1_3_w: 	double AT %QRG3ResourceBus.200.1.$3;
var G3R_Gear_CH1_4_w: 	double AT %QRG3ResourceBus.200.1.$4;
var G3R_Gear_CH1_5_w: 	double AT %QRG3ResourceBus.200.1.$5;
var G3R_Gear_CH1_6_w: 	double AT %QRG3ResourceBus.200.1.$6;
var G3R_Gear_CH1_7_w: 	double AT %QRG3ResourceBus.200.1.$7;

// Channel 2 - Col.0 - 8 Axis - write
var G3R_Gear_CH2_0_w: 	double AT %QRG3ResourceBus.200.2.$0;
var G3R_Gear_CH2_1_w: 	double AT %QRG3ResourceBus.200.2.$1;
var G3R_Gear_CH2_2_w: 	double AT %QRG3ResourceBus.200.2.$2;
var G3R_Gear_CH2_3_w: 	double AT %QRG3ResourceBus.200.2.$3;
var G3R_Gear_CH2_4_w: 	double AT %QRG3ResourceBus.200.2.$4;
var G3R_Gear_CH2_5_w: 	double AT %QRG3ResourceBus.200.2.$5;
var G3R_Gear_CH2_6_w: 	double AT %QRG3ResourceBus.200.2.$6;
var G3R_Gear_CH2_7_w: 	double AT %QRG3ResourceBus.200.2.$7;

// Channel 3 - Col.0 - 8 Axis - write
var G3R_Gear_CH3_0_w: 	double AT %QRG3ResourceBus.200.3.$0;
var G3R_Gear_CH3_1_w: 	double AT %QRG3ResourceBus.200.3.$1;
var G3R_Gear_CH3_2_w: 	double AT %QRG3ResourceBus.200.3.$2;
var G3R_Gear_CH3_3_w: 	double AT %QRG3ResourceBus.200.3.$3;
var G3R_Gear_CH3_4_w: 	double AT %QRG3ResourceBus.200.3.$4;
var G3R_Gear_CH3_5_w: 	double AT %QRG3ResourceBus.200.3.$5;
var G3R_Gear_CH3_6_w: 	double AT %QRG3ResourceBus.200.3.$6;
var G3R_Gear_CH3_7_w: 	double AT %QRG3ResourceBus.200.3.$7;

// Channel 4 - Col.0 - 8 Axis - write
var G3R_Gear_CH4_0_w: 	double AT %QRG3ResourceBus.200.4.$0;
var G3R_Gear_CH4_1_w: 	double AT %QRG3ResourceBus.200.4.$1;
var G3R_Gear_CH4_2_w: 	double AT %QRG3ResourceBus.200.4.$2;
var G3R_Gear_CH4_3_w: 	double AT %QRG3ResourceBus.200.4.$3;
var G3R_Gear_CH4_4_w: 	double AT %QRG3ResourceBus.200.4.$4;
var G3R_Gear_CH4_5_w: 	double AT %QRG3ResourceBus.200.4.$5;
var G3R_Gear_CH4_6_w: 	double AT %QRG3ResourceBus.200.4.$6;
var G3R_Gear_CH4_7_w: 	double AT %QRG3ResourceBus.200.4.$7;

// Channel 5 - Col.0 - 8 Axis - write
var G3R_Gear_CH5_0_w: 	double AT %QRG3ResourceBus.200.5.$0;
var G3R_Gear_CH5_1_w: 	double AT %QRG3ResourceBus.200.5.$1;
var G3R_Gear_CH5_2_w: 	double AT %QRG3ResourceBus.200.5.$2;
var G3R_Gear_CH5_3_w: 	double AT %QRG3ResourceBus.200.5.$3;
var G3R_Gear_CH5_4_w: 	double AT %QRG3ResourceBus.200.5.$4;
var G3R_Gear_CH5_5_w: 	double AT %QRG3ResourceBus.200.5.$5;
var G3R_Gear_CH5_6_w: 	double AT %QRG3ResourceBus.200.5.$6;
var G3R_Gear_CH5_7_w: 	double AT %QRG3ResourceBus.200.5.$7;

// Channel 6 - Col.0 - 8 Axis - write
var G3R_Gear_CH6_0_w: 	double AT %QRG3ResourceBus.200.6.$0;
var G3R_Gear_CH6_1_w: 	double AT %QRG3ResourceBus.200.6.$1;
var G3R_Gear_CH6_2_w: 	double AT %QRG3ResourceBus.200.6.$2;
var G3R_Gear_CH6_3_w: 	double AT %QRG3ResourceBus.200.6.$3;
var G3R_Gear_CH6_4_w: 	double AT %QRG3ResourceBus.200.6.$4;
var G3R_Gear_CH6_5_w: 	double AT %QRG3ResourceBus.200.6.$5;
var G3R_Gear_CH6_6_w: 	double AT %QRG3ResourceBus.200.6.$6;
var G3R_Gear_CH6_7_w: 	double AT %QRG3ResourceBus.200.6.$7;

// Channel 7 - Col.0 - 8 Axis - write
var G3R_Gear_CH7_0_w: 	double AT %QRG3ResourceBus.200.7.$0;
var G3R_Gear_CH7_1_w: 	double AT %QRG3ResourceBus.200.7.$1;
var G3R_Gear_CH7_2_w: 	double AT %QRG3ResourceBus.200.7.$2;
var G3R_Gear_CH7_3_w: 	double AT %QRG3ResourceBus.200.7.$3;
var G3R_Gear_CH7_4_w: 	double AT %QRG3ResourceBus.200.7.$4;
var G3R_Gear_CH7_5_w: 	double AT %QRG3ResourceBus.200.7.$5;
var G3R_Gear_CH7_6_w: 	double AT %QRG3ResourceBus.200.7.$6;
var G3R_Gear_CH7_7_w: 	double AT %QRG3ResourceBus.200.7.$7;

// Channel 0 - Col.0 - 8 Axis - read
var G3R_Gear_CH0_0_r: 	double AT %IRG3ResourceBus.200.0.$0;
var G3R_Gear_CH0_1_r: 	double AT %IRG3ResourceBus.200.0.$1;
var G3R_Gear_CH0_2_r: 	double AT %IRG3ResourceBus.200.0.$2;
var G3R_Gear_CH0_3_r: 	double AT %IRG3ResourceBus.200.0.$3;
var G3R_Gear_CH0_4_r: 	double AT %IRG3ResourceBus.200.0.$4;
var G3R_Gear_CH0_5_r: 	double AT %IRG3ResourceBus.200.0.$5;
var G3R_Gear_CH0_6_r: 	double AT %IRG3ResourceBus.200.0.$6;
var G3R_Gear_CH0_7_r: 	double AT %IRG3ResourceBus.200.0.$7;

// Channel 1 - Col.0 - 8 Axis - read
var G3R_Gear_CH1_0_r: 	double AT %IRG3ResourceBus.200.1.$0;
var G3R_Gear_CH1_1_r: 	double AT %IRG3ResourceBus.200.1.$1;
var G3R_Gear_CH1_2_r: 	double AT %IRG3ResourceBus.200.1.$2;
var G3R_Gear_CH1_3_r: 	double AT %IRG3ResourceBus.200.1.$3;
var G3R_Gear_CH1_4_r: 	double AT %IRG3ResourceBus.200.1.$4;
var G3R_Gear_CH1_5_r: 	double AT %IRG3ResourceBus.200.1.$5;
var G3R_Gear_CH1_6_r: 	double AT %IRG3ResourceBus.200.1.$6;
var G3R_Gear_CH1_7_r: 	double AT %IRG3ResourceBus.200.1.$7;

// Channel 2 - Col.0 - 8 Axis - read
var G3R_Gear_CH2_0_r: 	double AT %IRG3ResourceBus.200.2.$0;
var G3R_Gear_CH2_1_r: 	double AT %IRG3ResourceBus.200.2.$1;
var G3R_Gear_CH2_2_r: 	double AT %IRG3ResourceBus.200.2.$2;
var G3R_Gear_CH2_3_r: 	double AT %IRG3ResourceBus.200.2.$3;
var G3R_Gear_CH2_4_r: 	double AT %IRG3ResourceBus.200.2.$4;
var G3R_Gear_CH2_5_r: 	double AT %IRG3ResourceBus.200.2.$5;
var G3R_Gear_CH2_6_r: 	double AT %IRG3ResourceBus.200.2.$6;
var G3R_Gear_CH2_7_r: 	double AT %IRG3ResourceBus.200.2.$7;

// Channel 3 - Col.0 - 8 Axis - read
var G3R_Gear_CH3_0_r: 	double AT %IRG3ResourceBus.200.3.$0;
var G3R_Gear_CH3_1_r: 	double AT %IRG3ResourceBus.200.3.$1;
var G3R_Gear_CH3_2_r: 	double AT %IRG3ResourceBus.200.3.$2;
var G3R_Gear_CH3_3_r: 	double AT %IRG3ResourceBus.200.3.$3;
var G3R_Gear_CH3_4_r: 	double AT %IRG3ResourceBus.200.3.$4;
var G3R_Gear_CH3_5_r: 	double AT %IRG3ResourceBus.200.3.$5;
var G3R_Gear_CH3_6_r: 	double AT %IRG3ResourceBus.200.3.$6;
var G3R_Gear_CH3_7_r: 	double AT %IRG3ResourceBus.200.3.$7;

// Channel 4 - Col.0 - 8 Axis - read
var G3R_Gear_CH4_0_r: 	double AT %IRG3ResourceBus.200.4.$0;
var G3R_Gear_CH4_1_r: 	double AT %IRG3ResourceBus.200.4.$1;
var G3R_Gear_CH4_2_r: 	double AT %IRG3ResourceBus.200.4.$2;
var G3R_Gear_CH4_3_r: 	double AT %IRG3ResourceBus.200.4.$3;
var G3R_Gear_CH4_4_r: 	double AT %IRG3ResourceBus.200.4.$4;
var G3R_Gear_CH4_5_r: 	double AT %IRG3ResourceBus.200.4.$5;
var G3R_Gear_CH4_6_r: 	double AT %IRG3ResourceBus.200.4.$6;
var G3R_Gear_CH4_7_r: 	double AT %IRG3ResourceBus.200.4.$7;

// Channel 5 - Col.0 - 8 Axis - read
var G3R_Gear_CH5_0_r: 	double AT %IRG3ResourceBus.200.5.$0;
var G3R_Gear_CH5_1_r: 	double AT %IRG3ResourceBus.200.5.$1;
var G3R_Gear_CH5_2_r: 	double AT %IRG3ResourceBus.200.5.$2;
var G3R_Gear_CH5_3_r: 	double AT %IRG3ResourceBus.200.5.$3;
var G3R_Gear_CH5_4_r: 	double AT %IRG3ResourceBus.200.5.$4;
var G3R_Gear_CH5_5_r: 	double AT %IRG3ResourceBus.200.5.$5;
var G3R_Gear_CH5_6_r: 	double AT %IRG3ResourceBus.200.5.$6;
var G3R_Gear_CH5_7_r: 	double AT %IRG3ResourceBus.200.5.$7;

// Channel 6 - Col.0 - 8 Axis - read
var G3R_Gear_CH6_0_r: 	double AT %IRG3ResourceBus.200.6.$0;
var G3R_Gear_CH6_1_r: 	double AT %IRG3ResourceBus.200.6.$1;
var G3R_Gear_CH6_2_r: 	double AT %IRG3ResourceBus.200.6.$2;
var G3R_Gear_CH6_3_r: 	double AT %IRG3ResourceBus.200.6.$3;
var G3R_Gear_CH6_4_r: 	double AT %IRG3ResourceBus.200.6.$4;
var G3R_Gear_CH6_5_r: 	double AT %IRG3ResourceBus.200.6.$5;
var G3R_Gear_CH6_6_r: 	double AT %IRG3ResourceBus.200.6.$6;
var G3R_Gear_CH6_7_r: 	double AT %IRG3ResourceBus.200.6.$7;

// Channel 7 - Col.0 - 8 Axis - read
var G3R_Gear_CH7_0_r: 	double AT %IRG3ResourceBus.200.7.$0;
var G3R_Gear_CH7_1_r: 	double AT %IRG3ResourceBus.200.7.$1;
var G3R_Gear_CH7_2_r: 	double AT %IRG3ResourceBus.200.7.$2;
var G3R_Gear_CH7_3_r: 	double AT %IRG3ResourceBus.200.7.$3;
var G3R_Gear_CH7_4_r: 	double AT %IRG3ResourceBus.200.7.$4;
var G3R_Gear_CH7_5_r: 	double AT %IRG3ResourceBus.200.7.$5;
var G3R_Gear_CH7_6_r: 	double AT %IRG3ResourceBus.200.7.$6;
var G3R_Gear_CH7_7_r: 	double AT %IRG3ResourceBus.200.7.$7;

// Resource: dv (desired velocity)
var G3R_dv_A1_r: 	double AT %IRG3ResourceBus.9.0.$0;	
var G3R_dv_A2_r: 	double AT %IRG3ResourceBus.9.1.$0;	
var G3R_dv_A3_r: 	double AT %IRG3ResourceBus.9.2.$0;	

// Resource: rv (real velocity)
var G3R_rv_A1_r: 	double AT %IRG3ResourceBus.10.0.$0;	
var G3R_rv_A2_r: 	double AT %IRG3ResourceBus.10.1.$0;	
var G3R_rv_A3_r: 	double AT %IRG3ResourceBus.10.2.$0;	

// Resource: aux (auxiliary register)
var G3R_aux_A1_r: 	double AT %IRG3ResourceBus.11.0.$0;	
var G3R_aux_A2_r: 	double AT %IRG3ResourceBus.11.1.$0;	
var G3R_aux_A3_r: 	double AT %IRG3ResourceBus.11.2.$0;	

// Resource: CI (Common-Integer-Variables) read / write
// Variable Index in Index (here 0)
var G3R_CI000_r: 		integer AT %IDG3ResourceBus.12.0.$0;	
var G3R_CI000_w: 		integer AT %QDG3ResourceBus.12.0.$0;	

// Resource: CD (Common-Double-Variables) read / write
// Variable Index in Index (here 0)
var G3R_CD000_r: 		double  AT %IRG3ResourceBus.13.0.$0;	
var G3R_CD000_w: 		double  AT %QRG3ResourceBus.13.0.$0;

// Resources for SyncMode Read
var G3R_A1SYNC_MODE_r: 	integer AT %IDG3ResourceBus.FuncSyncMode.1.0;	
var G3R_A2SYNC_MODE_r: 	integer AT %IDG3ResourceBus.FuncSyncMode.1.1;	
var G3R_A3SYNC_MODE_r: 	integer AT %IDG3ResourceBus.FuncSyncMode.1.2;	

var G3R_A1SYNC_MASTER_r: integer AT %IDG3ResourceBus.FuncSyncMode.2.0;	
var G3R_A2SYNC_MASTER_r: integer AT %IDG3ResourceBus.FuncSyncMode.2.1;	
var G3R_A3SYNC_MASTER_r: integer AT %IDG3ResourceBus.FuncSyncMode.2.2;	

var G3R_A1SYNC_DV_r: 	double AT %IRG3ResourceBus.FuncSyncMode.6.0;	
var G3R_A2SYNC_DV_r: 	double AT %IRG3ResourceBus.FuncSyncMode.6.1;	
var G3R_A3SYNC_DV_r: 	double AT %IRG3ResourceBus.FuncSyncMode.6.2;	

// Resources for SyncMode Write
var G3R_A1SYNC_MODE_w: 	integer AT %QDG3ResourceBus.FuncSyncMode.1.0;	
var G3R_A2SYNC_MODE_w: 	integer AT %QDG3ResourceBus.FuncSyncMode.1.1;	
var G3R_A3SYNC_MODE_w: 	integer AT %QDG3ResourceBus.FuncSyncMode.1.2;	

var G3R_A1SYNC_MASTER_w: integer AT %QDG3ResourceBus.FuncSyncMode.2.0;	
var G3R_A2SYNC_MASTER_w: integer AT %QDG3ResourceBus.FuncSyncMode.2.1;	
var G3R_A3SYNC_MASTER_w: integer AT %QDG3ResourceBus.FuncSyncMode.2.2;	

var G3R_A1SYNC_SOURCE_w: integer AT %QDG3ResourceBus.FuncSyncMode.3.0;	
var G3R_A2SYNC_SOURCE_w: integer AT %QDG3ResourceBus.FuncSyncMode.3.1;	
var G3R_A3SYNC_SOURCE_w: integer AT %QDG3ResourceBus.FuncSyncMode.3.2;	

var G3R_A1SYNC_STARTPOS_w: 	double AT %QRG3ResourceBus.FuncSyncMode.4.0;	
var G3R_A2SYNC_STARTPOS_w: 	double AT %QRG3ResourceBus.FuncSyncMode.4.1;	
var G3R_A3SYNC_STARTPOS_w: 	double AT %QRG3ResourceBus.FuncSyncMode.4.2;	

var G3R_A1SYNC_OFFSET_w: 	double AT %QRG3ResourceBus.FuncSyncMode.5.0;	
var G3R_A2SYNC_OFFSET_w: 	double AT %QRG3ResourceBus.FuncSyncMode.5.1;	
var G3R_A3SYNC_OFFSET_w: 	double AT %QRG3ResourceBus.FuncSyncMode.5.2;	

var G3R_A1SYNC_DV_w: 	double AT %QRG3ResourceBus.FuncSyncMode.6.0;	
var G3R_A2SYNC_DV_w: 	double AT %QRG3ResourceBus.FuncSyncMode.6.1;	
var G3R_A3SYNC_DV_w: 	double AT %QRG3ResourceBus.FuncSyncMode.6.2;	

var G3R_A1SYNC_GEAR_w: 	double AT %QRG3ResourceBus.FuncSyncMode.7.0;	
var G3R_A2SYNC_GEAR_w: 	double AT %QRG3ResourceBus.FuncSyncMode.7.1;	
var G3R_A3SYNC_GEAR_w: 	double AT %QRG3ResourceBus.FuncSyncMode.7.2;	
	
// Resource: HostMemoryAccess (only with optionPCI)
var G3R_HostMemPhysAdr_w: 	integer AT %QDG3ResourceBus.300.0.$0;

// Remember: offsets must can be defined in index element (in bytes)
var G3R_HostMemByte_r: 	integer AT %IBG3ResourceBus.301.0.0;	
var G3R_HostMemByte_w: 	integer AT %QBG3ResourceBus.301.0.0;	
var G3R_HostMemWord_r: 	integer AT %IWG3ResourceBus.302.0.0;	
var G3R_HostMemWord_w: 	integer AT %QWG3ResourceBus.302.0.0;	
var G3R_HostMemInt_r: 	integer AT %IDG3ResourceBus.304.0.0;	
var G3R_HostMemInt_w: 	integer AT %QDG3ResourceBus.304.0.0;	
var G3R_HostMemDbl_r: 	double AT %IRG3ResourceBus.308.0.0;	
var G3R_HostMemDbl_w: 	double AT %QRG3ResourceBus.308.0.0;	

// Resource: ZeroOffsetTables
var G3R_ZoTable0A1_r:	double AT %IRG3ResourceBus.16.0.0;
var G3R_ZoTable1A1_r:	double AT %IRG3ResourceBus.16.0.1;
var G3R_ZoTable2A1_r:	double AT %IRG3ResourceBus.16.0.2;
var G3R_ZoTable3A1_r:	double AT %IRG3ResourceBus.16.0.3;
var G3R_ZoTable4A1_r:	double AT %IRG3ResourceBus.16.0.4;
var G3R_ZoTable5A1_r:	double AT %IRG3ResourceBus.16.0.5;
var G3R_ZoTable0A2_r:	double AT %IRG3ResourceBus.16.1.0;
var G3R_ZoTable1A2_r:	double AT %IRG3ResourceBus.16.1.1;
var G3R_ZoTable2A2_r:	double AT %IRG3ResourceBus.16.1.2;
var G3R_ZoTable3A2_r:	double AT %IRG3ResourceBus.16.1.3;
var G3R_ZoTable4A2_r:	double AT %IRG3ResourceBus.16.1.4;
var G3R_ZoTable5A2_r:	double AT %IRG3ResourceBus.16.1.5;
var G3R_ZoTable0A3_r:	double AT %IRG3ResourceBus.16.2.0;
var G3R_ZoTable1A3_r:	double AT %IRG3ResourceBus.16.2.1;
var G3R_ZoTable2A3_r:	double AT %IRG3ResourceBus.16.2.2;
var G3R_ZoTable3A3_r:	double AT %IRG3ResourceBus.16.2.3;
var G3R_ZoTable4A3_r:	double AT %IRG3ResourceBus.16.2.4;
var G3R_ZoTable5A3_r:	double AT %IRG3ResourceBus.16.2.5;

var G3R_ZoTable0A1_w:	double AT %QRG3ResourceBus.16.0.0;
var G3R_ZoTable1A1_w:	double AT %QRG3ResourceBus.16.0.1;
var G3R_ZoTable2A1_w:	double AT %QRG3ResourceBus.16.0.2;
var G3R_ZoTable3A1_w:	double AT %QRG3ResourceBus.16.0.3;
var G3R_ZoTable4A1_w:	double AT %QRG3ResourceBus.16.0.4;
var G3R_ZoTable5A1_w:	double AT %QRG3ResourceBus.16.0.5;
var G3R_ZoTable0A2_w:	double AT %QRG3ResourceBus.16.1.0;
var G3R_ZoTable1A2_w:	double AT %QRG3ResourceBus.16.1.1;
var G3R_ZoTable2A2_w:	double AT %QRG3ResourceBus.16.1.2;
var G3R_ZoTable3A2_w:	double AT %QRG3ResourceBus.16.1.3;
var G3R_ZoTable4A2_w:	double AT %QRG3ResourceBus.16.1.4;
var G3R_ZoTable5A2_w:	double AT %QRG3ResourceBus.16.1.5;
var G3R_ZoTable0A3_w:	double AT %QRG3ResourceBus.16.2.0;
var G3R_ZoTable1A3_w:	double AT %QRG3ResourceBus.16.2.1;
var G3R_ZoTable2A3_w:	double AT %QRG3ResourceBus.16.2.2;
var G3R_ZoTable3A3_w:	double AT %QRG3ResourceBus.16.2.3;
var G3R_ZoTable4A3_w:	double AT %QRG3ResourceBus.16.2.4;
var G3R_ZoTable5A3_w:	double AT %QRG3ResourceBus.16.2.5;

// Resource: Mirror (axis Mirror flag)
var G3R_Mirror_A1_r: 	integer AT %IDG3ResourceBus.17.0.$0;	
var G3R_Mirror_A2_r: 	integer AT %IDG3ResourceBus.17.1.$0;	
var G3R_Mirror_A3_r: 	integer AT %IDG3ResourceBus.17.2.$0;	
var G3R_Mirror_A4_r: 	integer AT %IDG3ResourceBus.17.3.$0;	
var G3R_Mirror_A5_r: 	integer AT %IDG3ResourceBus.17.4.$0;	
var G3R_Mirror_A6_r: 	integer AT %IDG3ResourceBus.17.5.$0;	
var G3R_Mirror_A7_r: 	integer AT %IDG3ResourceBus.17.6.$0;	
var G3R_Mirror_A8_r: 	integer AT %IDG3ResourceBus.17.7.$0;	

var G3R_Mirror_A1_w: 	integer AT %QDG3ResourceBus.17.0.$0;	
var G3R_Mirror_A2_w: 	integer AT %QDG3ResourceBus.17.1.$0;	
var G3R_Mirror_A3_w: 	integer AT %QDG3ResourceBus.17.2.$0;	
var G3R_Mirror_A4_w: 	integer AT %QDG3ResourceBus.17.3.$0;	
var G3R_Mirror_A5_w: 	integer AT %QDG3ResourceBus.17.4.$0;	
var G3R_Mirror_A6_w: 	integer AT %QDG3ResourceBus.17.5.$0;	
var G3R_Mirror_A7_w: 	integer AT %QDG3ResourceBus.17.6.$0;	
var G3R_Mirror_A8_w: 	integer AT %QDG3ResourceBus.17.7.$0;	

// Hardware Input Inversion bitcoded 
var G3R_inv_digi_A1_r: 	integer AT %IDG3ResourceBus.79.0.$0;	
var G3R_inv_digi_A2_r: 	integer AT %IDG3ResourceBus.79.1.$0;	
var G3R_inv_digi_A3_r: 	integer AT %IDG3ResourceBus.79.2.$0;
var G3R_inv_digi_A4_r: 	integer AT %IDG3ResourceBus.79.3.$0;
var G3R_inv_digi_A5_r: 	integer AT %IDG3ResourceBus.79.4.$0;
var G3R_inv_digi_A6_r: 	integer AT %IDG3ResourceBus.79.5.$0;
var G3R_inv_digi_A7_r: 	integer AT %IDG3ResourceBus.79.6.$0;
var G3R_inv_digi_A8_r: 	integer AT %IDG3ResourceBus.79.7.$0;

// Resource: PosFactor (PositionFactor for Mirroring)
var G3R_PosFactor_A1_r: 	double AT %IRG3ResourceBus.18.0.$0;	
var G3R_PosFactor_A2_r: 	double AT %IRG3ResourceBus.18.1.$0;	
var G3R_PosFactor_A3_r: 	double AT %IRG3ResourceBus.18.2.$0;	
var G3R_PosFactor_A4_r: 	double AT %IRG3ResourceBus.18.3.$0;	
var G3R_PosFactor_A5_r: 	double AT %IRG3ResourceBus.18.4.$0;	
var G3R_PosFactor_A6_r: 	double AT %IRG3ResourceBus.18.5.$0;	
var G3R_PosFactor_A7_r: 	double AT %IRG3ResourceBus.18.6.$0;	
var G3R_PosFactor_A8_r: 	double AT %IRG3ResourceBus.18.7.$0;	

var G3R_PosFactor_A1_w: 	double AT %QRG3ResourceBus.18.0.$0;	
var G3R_PosFactor_A2_w: 	double AT %QRG3ResourceBus.18.1.$0;	
var G3R_PosFactor_A3_w: 	double AT %QRG3ResourceBus.18.2.$0;	
var G3R_PosFactor_A4_w: 	double AT %QRG3ResourceBus.18.3.$0;	
var G3R_PosFactor_A5_w: 	double AT %QRG3ResourceBus.18.4.$0;	
var G3R_PosFactor_A6_w: 	double AT %QRG3ResourceBus.18.5.$0;	
var G3R_PosFactor_A7_w: 	double AT %QRG3ResourceBus.18.6.$0;	
var G3R_PosFactor_A8_w: 	double AT %QRG3ResourceBus.18.7.$0;	

var G3R_Backlash_A1_w: 	double AT %QRG3ResourceBus.27.0.$0;	
var G3R_Backlash_A2_w: 	double AT %QRG3ResourceBus.27.1.$0;	
var G3R_Backlash_A3_w: 	double AT %QRG3ResourceBus.27.2.$0;	
var G3R_Backlash_A4_w: 	double AT %QRG3ResourceBus.27.3.$0;	
var G3R_Backlash_A5_w: 	double AT %QRG3ResourceBus.27.4.$0;	
var G3R_Backlash_A6_w: 	double AT %QRG3ResourceBus.27.5.$0;	
var G3R_Backlash_A7_w: 	double AT %QRG3ResourceBus.27.6.$0;	
var G3R_Backlash_A8_w: 	double AT %QRG3ResourceBus.27.7.$0;	

var G3R_Backlash_A1_r: 	double AT %IRG3ResourceBus.27.0.$0;	
var G3R_Backlash_A2_r: 	double AT %IRG3ResourceBus.27.1.$0;	
var G3R_Backlash_A3_r: 	double AT %IRG3ResourceBus.27.2.$0;	
var G3R_Backlash_A4_r: 	double AT %IRG3ResourceBus.27.3.$0;	
var G3R_Backlash_A5_r: 	double AT %IRG3ResourceBus.27.4.$0;	
var G3R_Backlash_A6_r: 	double AT %IRG3ResourceBus.27.5.$0;	
var G3R_Backlash_A7_r: 	double AT %IRG3ResourceBus.27.6.$0;	
var G3R_Backlash_A8_r: 	double AT %IRG3ResourceBus.27.7.$0;	

// Motor Command Port Maximum Value (digits)
var G3R_MCPMAX_CH0_w: 	single AT %QSG3ResourceBus.28.0.$0;
var G3R_MCPMAX_CH1_w: 	single AT %QSG3ResourceBus.28.1.$0;
var G3R_MCPMAX_CH2_w: 	single AT %QSG3ResourceBus.28.2.$0;
var G3R_MCPMAX_CH3_w: 	single AT %QSG3ResourceBus.28.3.$0;
var G3R_MCPMAX_CH4_w: 	single AT %QSG3ResourceBus.28.4.$0;
var G3R_MCPMAX_CH5_w: 	single AT %QSG3ResourceBus.28.5.$0;
var G3R_MCPMAX_CH6_w: 	single AT %QSG3ResourceBus.28.6.$0;
var G3R_MCPMAX_CH7_w: 	single AT %QSG3ResourceBus.28.7.$0;

var G3R_MCPMAX_CH0_r: 	single AT %ISG3ResourceBus.28.0.$0;
var G3R_MCPMAX_CH1_r: 	single AT %ISG3ResourceBus.28.1.$0;
var G3R_MCPMAX_CH2_r: 	single AT %ISG3ResourceBus.28.2.$0;
var G3R_MCPMAX_CH3_r: 	single AT %ISG3ResourceBus.28.3.$0;
var G3R_MCPMAX_CH4_r: 	single AT %ISG3ResourceBus.28.4.$0;
var G3R_MCPMAX_CH5_r: 	single AT %ISG3ResourceBus.28.5.$0;
var G3R_MCPMAX_CH6_r: 	single AT %ISG3ResourceBus.28.6.$0;
var G3R_MCPMAX_CH7_r: 	single AT %ISG3ResourceBus.28.7.$0;

// Motor Command Port Minimum Value (digits)
var G3R_MCPMIN_CH0_w: 	single AT %QSG3ResourceBus.29.0.$0;
var G3R_MCPMIN_CH1_w: 	single AT %QSG3ResourceBus.29.1.$0;
var G3R_MCPMIN_CH2_w: 	single AT %QSG3ResourceBus.29.2.$0;
var G3R_MCPMIN_CH3_w: 	single AT %QSG3ResourceBus.29.3.$0;
var G3R_MCPMIN_CH4_w: 	single AT %QSG3ResourceBus.29.4.$0;
var G3R_MCPMIN_CH5_w: 	single AT %QSG3ResourceBus.29.5.$0;
var G3R_MCPMIN_CH6_w: 	single AT %QSG3ResourceBus.29.6.$0;
var G3R_MCPMIN_CH7_w: 	single AT %QSG3ResourceBus.29.7.$0;

// Distance Summation Index
var G3R_DISTSUMINDEX_A1_w: 	integer AT %QDG3ResourceBus.91.0.$0;
var G3R_DISTSUMINDEX_A2_w: 	integer AT %QDG3ResourceBus.91.1.$0;
var G3R_DISTSUMINDEX_A3_w: 	integer AT %QDG3ResourceBus.91.2.$0;
var G3R_DISTSUMINDEX_A4_w: 	integer AT %QDG3ResourceBus.91.3.$0;
var G3R_DISTSUMINDEX_A5_w: 	integer AT %QDG3ResourceBus.91.4.$0;
var G3R_DISTSUMINDEX_A6_w: 	integer AT %QDG3ResourceBus.91.5.$0;
var G3R_DISTSUMINDEX_A7_w: 	integer AT %QDG3ResourceBus.91.6.$0;
var G3R_DISTSUMINDEX_A8_w: 	integer AT %QDG3ResourceBus.91.7.$0;

var G3R_MCPMIN_CH0_r: 	single AT %ISG3ResourceBus.29.0.$0;
var G3R_MCPMIN_CH1_r: 	single AT %ISG3ResourceBus.29.1.$0;
var G3R_MCPMIN_CH2_r: 	single AT %ISG3ResourceBus.29.2.$0;
var G3R_MCPMIN_CH3_r: 	single AT %ISG3ResourceBus.29.3.$0;
var G3R_MCPMIN_CH4_r: 	single AT %ISG3ResourceBus.29.4.$0;
var G3R_MCPMIN_CH5_r: 	single AT %ISG3ResourceBus.29.5.$0;
var G3R_MCPMIN_CH6_r: 	single AT %ISG3ResourceBus.29.6.$0;
var G3R_MCPMIN_CH7_r: 	single AT %ISG3ResourceBus.29.7.$0;

var G3R_ActualBacklash_A1_r: 	double AT %IRG3ResourceBus.30.0.$0;	
var G3R_ActualBacklash_A2_r: 	double AT %IRG3ResourceBus.30.1.$0;	
var G3R_ActualBacklash_A3_r: 	double AT %IRG3ResourceBus.30.2.$0;	
var G3R_ActualBacklash_A4_r: 	double AT %IRG3ResourceBus.30.3.$0;	
var G3R_ActualBacklash_A5_r: 	double AT %IRG3ResourceBus.30.4.$0;	
var G3R_ActualBacklash_A6_r: 	double AT %IRG3ResourceBus.30.5.$0;	
var G3R_ActualBacklash_A7_r: 	double AT %IRG3ResourceBus.30.6.$0;	
var G3R_ActualBacklash_A8_r: 	double AT %IRG3ResourceBus.30.7.$0;	

var G3R_PcapSpoolerIndex_A1_r: 	integer AT %IDG3ResourceBus.32.0.$0;	
var G3R_PcapSpoolerIndex_A2_r: 	integer AT %IDG3ResourceBus.32.1.$0;	
var G3R_PcapSpoolerIndex_A3_r: 	integer AT %IDG3ResourceBus.32.2.$0;	
var G3R_PcapSpoolerIndex_A4_r: 	integer AT %IDG3ResourceBus.32.3.$0;	
var G3R_PcapSpoolerIndex_A5_r: 	integer AT %IDG3ResourceBus.32.4.$0;	
var G3R_PcapSpoolerIndex_A6_r: 	integer AT %IDG3ResourceBus.32.5.$0;	
var G3R_PcapSpoolerIndex_A7_r: 	integer AT %IDG3ResourceBus.32.6.$0;	
var G3R_PcapSpoolerIndex_A8_r: 	integer AT %IDG3ResourceBus.32.7.$0;

// Mpe_HP_Timeout - High Priority MPE Handling for fast OL in case of MPE
var G3R_Mpe_HP_Timeout_A1_r: 	integer AT %IDG3ResourceBus.95.0.$0;	{ read }	
var G3R_Mpe_HP_Timeout_A2_r: 	integer AT %IDG3ResourceBus.95.1.$0;	
var G3R_Mpe_HP_Timeout_A3_r: 	integer AT %IDG3ResourceBus.95.2.$0;	
var G3R_Mpe_HP_Timeout_A4_r: 	integer AT %IDG3ResourceBus.95.3.$0;	
var G3R_Mpe_HP_Timeout_A5_r: 	integer AT %IDG3ResourceBus.95.4.$0;	
var G3R_Mpe_HP_Timeout_A6_r: 	integer AT %IDG3ResourceBus.95.5.$0;	
var G3R_Mpe_HP_Timeout_A7_r: 	integer AT %IDG3ResourceBus.95.6.$0;	
var G3R_Mpe_HP_Timeout_A8_r: 	integer AT %IDG3ResourceBus.95.7.$0;	
var G3R_Mpe_HP_Timeout_A1_w: 	integer AT %QDG3ResourceBus.95.0.$0;	{ write }	
var G3R_Mpe_HP_Timeout_A2_w: 	integer AT %QDG3ResourceBus.95.1.$0;	
var G3R_Mpe_HP_Timeout_A3_w: 	integer AT %QDG3ResourceBus.95.2.$0;	
var G3R_Mpe_HP_Timeout_A4_w: 	integer AT %QDG3ResourceBus.95.3.$0;	
var G3R_Mpe_HP_Timeout_A5_w: 	integer AT %QDG3ResourceBus.95.4.$0;	
var G3R_Mpe_HP_Timeout_A6_w: 	integer AT %QDG3ResourceBus.95.5.$0;	
var G3R_Mpe_HP_Timeout_A7_w: 	integer AT %QDG3ResourceBus.95.6.$0;	
var G3R_Mpe_HP_Timeout_A8_w: 	integer AT %QDG3ResourceBus.95.7.$0;	

// Edge Bending Error (in Interpolation Position Unit PU)
var G3R_EBE_A1_r: 	double  AT %IRG3ResourceBus.96.0.$0; 
var G3R_EBE_A2_r: 	double  AT %IRG3ResourceBus.96.1.$0; 
var G3R_EBE_A3_r: 	double  AT %IRG3ResourceBus.96.2.$0; 
var G3R_EBE_A4_r: 	double  AT %IRG3ResourceBus.96.3.$0; 
var G3R_EBE_A5_r: 	double  AT %IRG3ResourceBus.96.4.$0; 
var G3R_EBE_A6_r: 	double  AT %IRG3ResourceBus.96.5.$0; 
var G3R_EBE_A7_r: 	double  AT %IRG3ResourceBus.96.6.$0; 
var G3R_EBE_A8_r: 	double  AT %IRG3ResourceBus.96.7.$0; 
var G3R_EBE_A1_w: 	double  AT %QRG3ResourceBus.96.0.$0; 
var G3R_EBE_A2_w: 	double  AT %QRG3ResourceBus.96.1.$0; 
var G3R_EBE_A3_w: 	double  AT %QRG3ResourceBus.96.2.$0; 
var G3R_EBE_A4_w: 	double  AT %QRG3ResourceBus.96.3.$0; 
var G3R_EBE_A5_w: 	double  AT %QRG3ResourceBus.96.4.$0; 
var G3R_EBE_A6_w: 	double  AT %QRG3ResourceBus.96.5.$0; 
var G3R_EBE_A7_w: 	double  AT %QRG3ResourceBus.96.6.$0; 
var G3R_EBE_A8_w: 	double  AT %QRG3ResourceBus.96.7.$0; 

// Definition of GEOADD Axis (MT 14)
var G3R_GEOADD_A1_w: 	integer  AT %QDG3ResourceBus.89.0.$0; 
var G3R_GEOADD_A2_w: 	integer  AT %QDG3ResourceBus.89.1.$0; 
var G3R_GEOADD_A3_w: 	integer  AT %QDG3ResourceBus.89.2.$0; 
var G3R_GEOADD_A4_w: 	integer  AT %QDG3ResourceBus.89.3.$0; 
var G3R_GEOADD_A5_w: 	integer  AT %QDG3ResourceBus.89.4.$0; 
var G3R_GEOADD_A6_w: 	integer  AT %QDG3ResourceBus.89.5.$0; 
var G3R_GEOADD_A7_w: 	integer  AT %QDG3ResourceBus.89.6.$0; 
var G3R_GEOADD_A8_w: 	integer  AT %QDG3ResourceBus.89.7.$0; 
var G3R_GEOADD_UNOA_A1_r: 	integer  AT %IDG3ResourceBus.88.0.$0; 
var G3R_GEOADD_UNOA_A2_r: 	integer  AT %IDG3ResourceBus.88.1.$0; 
var G3R_GEOADD_UNOA_A3_r: 	integer  AT %IDG3ResourceBus.88.2.$0; 
var G3R_GEOADD_UNOA_A4_r: 	integer  AT %IDG3ResourceBus.88.3.$0; 
var G3R_GEOADD_UNOA_A5_r: 	integer  AT %IDG3ResourceBus.88.4.$0; 
var G3R_GEOADD_UNOA_A6_r: 	integer  AT %IDG3ResourceBus.88.5.$0; 
var G3R_GEOADD_UNOA_A7_r: 	integer  AT %IDG3ResourceBus.88.6.$0; 
var G3R_GEOADD_UNOA_A8_r: 	integer  AT %IDG3ResourceBus.88.7.$0; 
	   
// Anaog-Out Tabellen-Aktivierung (schreiben) / berprfung (lesen)
var G3R_AOTABLE_A1_w: 	integer  AT %QDG3ResourceBus.108.0.$0; 
var G3R_AOTABLE_A2_w: 	integer  AT %QDG3ResourceBus.108.1.$0; 
var G3R_AOTABLE_A3_w: 	integer  AT %QDG3ResourceBus.108.2.$0; 
var G3R_AOTABLE_A4_w: 	integer  AT %QDG3ResourceBus.108.3.$0; 
var G3R_AOTABLE_A5_w: 	integer  AT %QDG3ResourceBus.108.4.$0; 
var G3R_AOTABLE_A6_w: 	integer  AT %QDG3ResourceBus.108.5.$0; 
var G3R_AOTABLE_A7_w: 	integer  AT %QDG3ResourceBus.108.6.$0; 
var G3R_AOTABLE_A8_w: 	integer  AT %QDG3ResourceBus.108.7.$0;
 
var G3R_AOTABLE_A1_r: 	integer  AT %IDG3ResourceBus.108.0.$0; 
var G3R_AOTABLE_A2_r: 	integer  AT %IDG3ResourceBus.108.1.$0; 
var G3R_AOTABLE_A3_r: 	integer  AT %IDG3ResourceBus.108.2.$0; 
var G3R_AOTABLE_A4_r: 	integer  AT %IDG3ResourceBus.108.3.$0; 
var G3R_AOTABLE_A5_r: 	integer  AT %IDG3ResourceBus.108.4.$0; 
var G3R_AOTABLE_A6_r: 	integer  AT %IDG3ResourceBus.108.5.$0; 
var G3R_AOTABLE_A7_r: 	integer  AT %IDG3ResourceBus.108.6.$0; 
var G3R_AOTABLE_A8_r: 	integer  AT %IDG3ResourceBus.108.7.$0; 

// MaxMoveCommandsInSpooler
var G3R_MMCiS_r: 	integer AT %IDG3ResourceBus.19.0.$0;	
var G3R_MMCiS_w: 	integer AT %QDG3ResourceBus.19.0.$0;	

// Spline Support
var G3R_SplineBlockSize_r:	integer AT %IDG3ResourceBus.60.0.$0;	
var G3R_SplineBlockSize_w: 	integer AT %QDG3ResourceBus.60.0.$0;

// SampleTime-Expanding (not in all Versions)
var G3R_SampleTimeExpand_r:	integer AT %IDG3ResourceBus.61.0.$0;	
var G3R_SampleTimeExpand_w: 	integer AT %QDG3ResourceBus.61.0.$0;

// G-Code Profile Information
var G3R_DTV0_r: 	double  AT %IRG3ResourceBus.20.0.$0; 
var G3R_DTV1_r: 	double  AT %IRG3ResourceBus.21.0.$0; 
var G3R_PIR_r: 	        integer AT %IDG3ResourceBus.22.0.$0; 
var G3R_PTP_A1_r: 	double  AT %IRG3ResourceBus.23.0.$0; 
var G3R_PTP_A2_r: 	double  AT %IRG3ResourceBus.23.1.$0; 
var G3R_PTP_A3_r: 	double  AT %IRG3ResourceBus.23.2.$0; 

// CNC-Task-Line 
var G3R_TASKLINE_T0_r: 	integer AT %IDG3ResourceBus.24.0.$0; 
var G3R_TASKLINE_T1_r: 	integer AT %IDG3ResourceBus.24.1.$0; 
var G3R_TASKLINE_T2_r: 	integer AT %IDG3ResourceBus.24.2.$0; 
var G3R_TASKLINE_T3_r: 	integer AT %IDG3ResourceBus.24.3.$0; 
// CNC-Task-Status
var G3R_TASKSTATUS0_r: 	integer AT %IDG3ResourceBus.70.0.$0; 
var G3R_TASKSTATUS1_r: 	integer AT %IDG3ResourceBus.70.1.$0; 
var G3R_TASKSTATUS2_r: 	integer AT %IDG3ResourceBus.70.2.$0; 
var G3R_TASKSTATUS3_r: 	integer AT %IDG3ResourceBus.70.3.$0; 
	
var G3R_IpolMode_r: 	integer AT %IDG3ResourceBus.92.0.$0;

// Resource: PosFactor (PositionFactor for Mirroring)
// release old MCU-G3 Resource handles
var FResourceClean_w: 	integer AT %QDG3ResourceBus.ResourceFunction.$1.$0;	

// ENDAT specific commands
const ENDAT_TPV			= 3000;	// ENDAT transmit position value (read command)
const ENDAT_SMA			= 3001;	// ENDAT selection of memory area (write command)
const ENDAT_TP			= 3002;	// ENDAT transmit parameter (read command)
const ENDAT_RP			= 3003;	// ENDAT receive parameter (write command)
const ENDAT_RR			= 3004;	// ENDAT receive reset (write command)
const ENDAT_RA			= 3010;	// ENDAT read alarm bit (read command)
const ENDAT_CRCERRS		= 3011;	// ENDAT read crc errors (read / write command)
const ENDAT_TOERRS		= 3012;	// ENDAT read timeout errors (read / write command)
const ENDAT_BUSERR		= 3013;	// ENDAT gobal buserror register (read / write command)
const ENDAT_TPVWAI		= 3020;	// ENDAT transmit position value with additional information (read command)
const ENDAT_TPVRR			= 3021;	// ENDAT transmit position value receive reset (read command)
// ENDAT MRS codes
const ENDAT_MRSCODE_MAN_0 	= $A1;	// ENDAT Manufacturer, Address range 4 .. 15 (r)
const ENDAT_MRSCODE_MAN_1 	= $A3;	// ENDAT Manufacturer, Address range 0 .. 15 (r)
const ENDAT_MRSCODE_MAN_2 	= $A5;	// ENDAT Manufacturer, Address range 0 .. 15 (r)
const ENDAT_MRSCODE_OP    	= $A7;	// Operating parameter, Address range 0 .. 15 (r/w)
const ENDAT_MRSCODE_OM	  	= $B9;	// Operation Mode, Address range 0 .. 3	(r/w)

// Resources for Hardware Info
var G3R_EPMREVSDICH0_r: 	integer AT %IDG3ResourceBus.62.0.0;	
var G3R_EPMREVSDICH1_r: 	integer AT %IDG3ResourceBus.63.0.0;	


// Resources for APCI320
var APCI3120_CARDNR_w: 		integer AT %QDG3ResourceBus.APCI3120RO.1.0;	
var APCI3120_OM_w: 		integer AT %QDG3ResourceBus.APCI3120RO.2.0;	
var APCI3120_EOCTO_w: 		integer AT %QDG3ResourceBus.APCI3120RO.3.0;	
var APCI3120_STATUS_w: 		integer AT %QDG3ResourceBus.APCI3120RO.4.0;	
var APCI3120_CIOFFSET_w: 	integer AT %QDG3ResourceBus.APCI3120RO.5.0;	
var APCI3120_CARDNR_r: 		integer AT %IDG3ResourceBus.APCI3120RO.1.0;	
var APCI3120_OM_r: 		integer AT %IDG3ResourceBus.APCI3120RO.2.0;	
var APCI3120_EOCTO_r: 		integer AT %IDG3ResourceBus.APCI3120RO.3.0;	
var APCI3120_Dev0_STATUS_r: 		integer AT %IDG3ResourceBus.APCI3120RO.4.0;	
var APCI3120_CIOFFSET_r: 	integer AT %IDG3ResourceBus.APCI3120RO.5.0;

// Resources for PA3110
var PA3110_CARDNR_w: 		integer AT %QDG3ResourceBus.PA3110RO.1.0;	
var PA3110_OM_w: 		integer AT %QDG3ResourceBus.PA3110RO.2.0;	
var PA3110_EOCTO_w: 		integer AT %QDG3ResourceBus.PA3110RO.3.0;	
var PA3110_STATUS_w: 		integer AT %QDG3ResourceBus.PA3110RO.4.0;	
var PA3110_CIOFFSET_w: 	        integer AT %QDG3ResourceBus.PA3110RO.5.0;	
var PA3110_ISABASEADDRESS_w: 	integer AT %QDG3ResourceBus.PA3110RO.6.0;	
var PA3110_CARDNR_r: 		integer AT %IDG3ResourceBus.PA3110RO.1.0;	
var PA3110_OM_r: 		integer AT %IDG3ResourceBus.PA3110RO.2.0;	
var PA3110_EOCTO_r: 		integer AT %IDG3ResourceBus.PA3110RO.3.0;	
var PA3110_STATUS_r: 		integer AT %IDG3ResourceBus.PA3110RO.4.0;	
var PA3110_CIOFFSET_r: 	        integer AT %IDG3ResourceBus.PA3110RO.5.0;
var PA3110_ISABASEADDRESS_r: 	integer AT %IDG3ResourceBus.PA3110RO.6.0;

// Resources for APCI3701
var APCI3701_CARDNR_w: 		integer AT %QDG3ResourceBus.APCI3701RO.1.0;	
var APCI3701_OM_w: 		integer AT %QDG3ResourceBus.APCI3701RO.2.0;	
var APCI3701_STATUS_w: 		integer AT %QDG3ResourceBus.APCI3701RO.3.0;	
var APCI3701_CIOFFSET_w: 	integer AT %QDG3ResourceBus.APCI3701RO.4.0;	
var APCI3701_CARDNR_r: 		integer AT %IDG3ResourceBus.APCI3701RO.1.0;	
var APCI3701_OM_r: 		integer AT %IDG3ResourceBus.APCI3701RO.2.0;	
var APCI3701_STATUS_r: 		integer AT %IDG3ResourceBus.APCI3701RO.3.0;	
var APCI3701_CIOFFSET_r: 	integer AT %IDG3ResourceBus.APCI3701RO.4.0;

// Resources for APCI3702
var APCI3702_CARDNR_w: 		integer AT %QDG3ResourceBus.APCI3702RO.1.0;	
var APCI3702_OM_w: 		integer AT %QDG3ResourceBus.APCI3702RO.2.0;	
var APCI3702_STATUS_w: 		integer AT %QDG3ResourceBus.APCI3702RO.3.0;	
var APCI3702_CIOFFSET_w: 	integer AT %QDG3ResourceBus.APCI3702RO.4.0;	
var APCI3702_CARDNR_r: 		integer AT %IDG3ResourceBus.APCI3702RO.1.0;	
var APCI3702_OM_r: 		integer AT %IDG3ResourceBus.APCI3702RO.2.0;	
var APCI3702_STATUS_r: 		integer AT %IDG3ResourceBus.APCI3702RO.3.0;	
var APCI3702_CIOFFSET_r: 	integer AT %IDG3ResourceBus.APCI3702RO.4.0;

// Resources for OsTRACE
var OsTRACE_StatusWord_w: 	integer AT %QDG3ResourceBus.9000.0.0;	
var OsTRACE_StatusWord_r: 	integer AT %IDG3ResourceBus.9000.0.0;	
var OsTRACE_TraceOffline_w: 	integer AT %QDG3ResourceBus.9001.0.0;	
var OsTRACE_TraceOffline_r: 	integer AT %IDG3ResourceBus.9001.0.0;	
var OsTRACE_TraceStop_w: 	integer AT %QDG3ResourceBus.9002.0.0;	
var OsTRACE_TraceStop_r: 	integer AT %IDG3ResourceBus.9002.0.0;	
var OsTRACE_TraceStopOnMsg_w: integer AT %QDG3ResourceBus.9003.0.0;	
var OsTRACE_TraceStopOnMsg_r: integer AT %IDG3ResourceBus.9003.0.0;	
var OsTRACE_TracePtrIn_r: 	integer AT %IDG3ResourceBus.9010.0.0;	
var OsTRACE_TracePtrOut_r: 	integer AT %IDG3ResourceBus.9011.0.0;	
var OsTRACE_TracePtrBufStart_r: 	integer AT %IDG3ResourceBus.9012.0.0;	
var OsTRACE_TracePtrBufEnd_r: 	integer AT %IDG3ResourceBus.9013.0.0;	

// only for MCU-3100
// 4. Analog Output at Base Board (X2)
var G3R_AOUT03_w: integer AT %QDG3ResourceBus.83.0.0;	

// Analog Outputs by AOut Number (not axis number)
var G3R_AOut0_w: 	integer AT %QDG3ResourceBus.87.0.$0; 
var G3R_AOut1_w: 	integer AT %QDG3ResourceBus.87.1.$0; 
var G3R_AOut2_w: 	integer AT %QDG3ResourceBus.87.2.$0; 
var G3R_AOut3_w: 	integer AT %QDG3ResourceBus.87.3.$0; { 4. Analog Output }


// RTCP Set 1
var RTCP_CLEAN_01w: 		integer AT %QDRtcpBUS.0.0.$0; 

var RTCP_STATUS_01r: 		integer AT %IDRtcpBUS.1.1.$0; 
var RTCP_STATUS_01w: 		integer AT %QDRtcpBUS.1.1.$0; 
var RTCP_TYPE_01r: 		integer AT %IDRtcpBUS.2.1.$0; 
var RTCP_TYPE_01w: 		integer AT %QDRtcpBUS.2.1.$0; 
var RTCP_RUN_01w: 		integer AT %QDRtcpBUS.3.1.$0; 
var RTCP_X_AXIS_01r: 		integer AT %IDRtcpBUS.11.1.$0; 
var RTCP_X_AXIS_01w: 		integer AT %QDRtcpBUS.11.1.$0; 
var RTCP_Y_AXIS_01r: 		integer AT %IDRtcpBUS.12.1.$0; 
var RTCP_Y_AXIS_01w: 		integer AT %QDRtcpBUS.12.1.$0; 
var RTCP_Z_AXIS_01r: 		integer AT %IDRtcpBUS.13.1.$0; 
var RTCP_Z_AXIS_01w: 		integer AT %QDRtcpBUS.13.1.$0; 
var RTCP_ROTATE_X_AXIS_01r: 	integer AT %IDRtcpBUS.14.1.$0; 
var RTCP_ROTATE_X_AXIS_01w: 	integer AT %QDRtcpBUS.14.1.$0; 
var RTCP_ROTATE_Y_AXIS_01r: 	integer AT %IDRtcpBUS.15.1.$0; 
var RTCP_ROTATE_Y_AXIS_01w: 	integer AT %QDRtcpBUS.15.1.$0; 
var RTCP_ROTATE_Z_AXIS_01r: 	integer AT %IDRtcpBUS.16.1.$0; 
var RTCP_ROTATE_Z_AXIS_01w: 	integer AT %QDRtcpBUS.16.1.$0; 
var RTCP_INVERT_X_01r: 		integer AT %IDRtcpBUS.17.1.$0; 
var RTCP_INVERT_X_01w: 		integer AT %QDRtcpBUS.17.1.$0; 
var RTCP_INVERT_Y_01r: 		integer AT %IDRtcpBUS.18.1.$0; 
var RTCP_INVERT_Y_01w: 		integer AT %QDRtcpBUS.18.1.$0; 
var RTCP_INVERT_Z_01r: 		integer AT %IDRtcpBUS.19.1.$0; 
var RTCP_INVERT_Z_01w: 		integer AT %QDRtcpBUS.19.1.$0; 

var RTCP_ToolLength_01r: 	double AT %IRRtcpBUS.10.1.$0; 
var RTCP_ToolLength_01w: 	double AT %QRRtcpBUS.10.1.$0;

// Resource: write digo (Grafik Display Desired) 0 = dp (default) / 3 = w_yk
var G3R_gdd_A1_w: 	integer AT %QDG3ResourceBus.107.0.$0;	
var G3R_gdd_A2_w: 	integer AT %QDG3ResourceBus.107.1.$0;	
var G3R_gdd_A3_w: 	integer AT %QDG3ResourceBus.107.2.$0;	
var G3R_gdd_A4_w: 	integer AT %QDG3ResourceBus.107.3.$0;	
var G3R_gdd_A5_w: 	integer AT %QDG3ResourceBus.107.4.$0;	
var G3R_gdd_A6_w: 	integer AT %QDG3ResourceBus.107.5.$0;	
var G3R_gdd_A7_w: 	integer AT %QDG3ResourceBus.107.6.$0;	
var G3R_gdd_A8_w: 	integer AT %QDG3ResourceBus.107.7.$0;	

