{
  +-----------------------------------------------------------------------+
  | (C) Roesch & Walter Industrie-Elektronik GmbH                         |
  | Woertelweg 2 b/c             D-77963 Schwanau                         |
  +-------------------------------+---------------------------------------+
  | Tel : +49 (0) 7824/6628-0     | email    : support@rw-gmbh.de         |
  | Fax : +49 (0) 7824/6628-29    | Internet : http://www.rw-gmbh.de      |
  +-------------------------------+---------------------------------------+
  | Project     : MCUG3 TOOLSET   | Compiler : BORLAND Delphi >= 2.0      |
  |                               |                                       |
  | Module name : mcug3.pas       | Operating System:                     |
  |                               |            - Windows 95/98/Me         |
  |                               |            - Windows NT 4.0           |
  |                               |            - Windows NT Embedded 4.0  |
  |                               |            - Windows 2000             |
  |                               |            - Windows XP               |
  +-------------------------------+---------------------------------------+
  | Author : Roesch R.               Date :21/08/2002                     |
  |          Walter M.                                                    |
  +-----------------------------------------------------------------------+
  | Description   : Driver Interface for                                  |
  |                 High-Performance Motion-Control Family Generation 3   |
  |                                                                       |
  |                 Currently supported G3-Controllers:                   |
  |                         MCU-3000, APCI-8001, MCU-6000 and APCI-8401   |
  |                                                                       |
  |                                                                       |
  +-----------------------------------------------------------------------+


	Revision History:
	-----------------
	30.08.2018 	V2-53-119 mw new functions rdSysVarInt, rdSysVarDbl, wrSysVarInt, wrSysVarDbl,
	                                       rdAxVarInt, rdAxVarDbl, wrAxVarInt, wrAxVarDbl
	30.08.2018	V2-53-119 mw new functions rdPcapIndex
	25.07.2016	V253-112 mw new procedures: sstvl, spda, spdr
	17.03.2016	V253-111 mw new functions: rdShortProfile, wrShortProfile
							threshold Profile length for NoTriangle (default 5.0)
	18.02.2016  V253-110 mw new functions: rdVBError, wrVBError for Velocity-Blending
							rdpeaux, InitMcuSystem4, 
							CleanServiceData, SendReqScannerBuffer - requires rwmos min. V2.5.3.123
	22.04.2015 	V253-108 mw new function: wrtrac, wrtrvl, wrtrtvl, rdtrac, rdtrvl, rdtrtvl
	01.04.2014	V253-106 mw	procedures wrControllerFlags and rdControllerFlags added
	01.07.2013	V2-53-90 mw handling of Macros for char declarations 
						    because different Delphi Versions 
	03.04.2012  V2-53-82 mw new functions: wrdvoffset, rddvoffset
	27.01.2012	V2-53-79 mw Data Type char replace with AnsiChar because
							size has been changed in Delphi2010
	26.01.2012	V2-53-79 mw	using of CONDITIONALEXPRESSIONS because
							Delphi 2010 and newer
  	28.03.2011  V2-53-79 mw Do not use Wide char since Delphi 2009
                          see Definition of CppString
	15.03.2011	V2-53-79 mw	new function RPtoDP
	20.05.2009	V2-53-71 mw	new procedure ClearCI99
	04.01.2008	V2-53-57 mw	new functions rdgfaux and wrgfaux
	12.12.2007	V2-53.56 mw	rdifs now returns zero, if function sucessfully has been executed
							up to now rdifs has been a procedure without any return value
	10.12.2007	V2-53.56 mw New Functions wrtrovrst, rdrtrovrst added
									for handling of trovr settling time
	03.05.2007	V2-53-47 mw	prototypes for allocPhysMem and freePhysMem new
	23.03.2007	V2-53-46 mw parameter changed at functions
							rdrv, getcnctsrclinenr, getmsgstr, getcnctfh,
							burnaplpar, gettimers, cm

							Attention: incompatibillity is possible
							
	12.02.2007	V2-53-43 mw new functions: wrElCamTable32 and wrElCamTable64
							for direct loading ElCAM-Tables
	14/12/2006	V2-53-42 mw	new function: ssfn - Definition of axis per AS-record
	03/11/2006	V2-53-41 mw	new functions: wrGCR, rdGCR
	19/10/2005	V2-53-34 mw	new function: rdptp, rdpir, rddtv
	13/10/2005	V2-53-33 mw	new functions: rdtrjerk, wrtrjerk
	07/10/2005	V2-53-33 mw	new function: rdZeroOffset
	27/07/2005  V2-52-30 mw new functions: wrdpoffset, rddpoffset
!!!	22/06/2005	V2-53-26 mw	declaration of gettskstr changed
	21/06/2005	V2-53-26 mw	interrupt handling functions added
	13/06/2005	V2-53-26 mw	new functions gettskinfo(), gettskstr() + CardSelect()
	01/04/2005  V2-53-25 mw new function getEnvStr()
	30/03/2005	V2-53-25 mw	new function accstop()
	09/02/2005	V2-53    mw	functions added: wrMaxAcc, rdMaxAcc
	03/01/2005	V2-53-23 mw	functions rdslsp() and wrslsp() added
	30/09/2004	V2-53	mw	function rdOsVersion added
	11/08/2004	V2-53	mw	syntax error in wrnfrax removed
	01/06/2004	V2-53	mw	functions rdnfrax(), wrnfrax() added
	30/01/2004	V2-53   mw  new functions: rdrv, clv
	30/10/2003	V2-53   mw  new functions: wrErrorReg, rdErrorReg
	22/09/2003  V2-52   mw  new functions: wrJerk, rdJerk
	08/09/2003  V2-52   mw  new functions: wrEffRadius, rdEffRadius
							for rotatoric Axis
	16/07/2003	V2-52	mw	function rdPE renamed to rdPosErr
	10/03/2003	V2-52	mw	New function: MsgToScreen - possibility to supress
							Screen-Messages (Message Boxes)
	18/02/2003	V2-52	mw	- new functions wrMaxVel and rdMaxVel added
	04/12/2002  V2-52   mw  - commands and records for 3D-Circular-Moves added
	07/10/2002	V2-52	mw	- szpa and szpr new (set zero Position absolut / relativ)
    21/08/2002	V2-52	rr	- $A- compiler directive added (switch off alignement)
                              packed statement for TSRP obsolete now
	25/04/2002	V2-51	mw	- new functions: rdPE, rdMCiS
							  to read Position-Error and Move-Commands-in-Spooler added
	11/04/2002	V2-51	mw	- new functions for ModeReg and MDVel added
							  for LookAhead and velocity-skip-termination
	08/03/2002	V2-51	mw	- ELCAM Interface new
	12/02/2002  V2-51   rr  - ATAccessType and ATDataType added
	10/01/2002  V2-51   mw  - Parameter value in function ssf changed from integer to double
	11/12/2001	V2-51	rr	- wrOption(), rdOption()
							  renamed to wrOptionInt(), rdOptionInt()
							- wrOptionDbl(), rdOptionDbl() added
	03/12/2001	V2-51	rr	- struct OptionDescriptorObject,
							  wrOption(), rdOption() and freeOptionHandle() added
							- Scanner functions:
								rdScannerBufferSize(), rdScannerStatus(),
								rdScannerLsm() and rdScannerBuffer() added
    31/08/2001	V2-50	mw	Spline functions
    						LdSSplineA, LdSSplineR, ExeSSpline added
    02/07/2001	V2-50	rr	removed stepcnct2
    26/03/2001  V2-50   rr  jr(), ja(), jhi() TSRP parameter to TSRPSETS changed
                            record TSRP 'packed' attribute added
    09/03/2001	V2-50	rr	BootErrorReport() added
    07/03/2001	V2-50	rr	created from mcusrvr.pas und specfunc.pas
                            updated according "C-Source" mcug3.h
 	23/03/2007	V2-53-46 mw parameter changed at functions
							rdrv, getcnctsrclinenr, getmsgstr, getcnctfh, burnaplpar, gettimers, cm
							Attention: incompatibillity is possible


}

{$N+}			{ IEE-754 data formats required }
{$A-}			{ switch off alignement in records }

unit mcug3;     { name of this unit }

interface

const
    DLLDRIVER       = 'MCUG3.DLL';
                                { This is the interface driver for this unit, all functions are external in MCUG3.DLL }
	MAXAXIS			= 18;	    { currently maximum supplied number of axis, do not change !!! }
	SIZE_STRREV		= 40;       { String-Size definition }
	SIZE_CIBUF		= 1000;     { Number of elements in common integer buffer }
	SIZE_CDBUF		= 1000;     { Number of elements in common double buffer }
    BSIZE			= 1024;     { Size of System File Header and CNC File Header }
    SIZE_FILENAMES	= 256;		{ Max. (char) Size for Filenames }
    SIZE_TIME		= 32;		{ Size (char) of System time information }
    SCPSZ_R	        = 15;		{ row size for CTRLRPARAMS }
    SCPSZ_C 	    = 15;		{ colomn size for CTRLRPARAMS }
    SPD2D_S			= 10;		{ size of SPD2D datas }
	SIZE_POSBUF	    = 1000;		{ Number of Position datas to read in }

	{ Bit-Locations for Status-und Error-Flags in axst }
	BITLOC_to		= $00001;	{ Bit 0:  MCU-6000, APCI-8401 only, MCU-3000 / APCI-8001 = 0 }
	BITLOC_eo		= $00002;   { Bit 1:  Emergency out }
	BITLOC_dnr		= $00004;   { Bit 2:  Drive not ready }
	BITLOC_lslh		= $00008;   { Bit 3:  Limit switch left hardware }
	BITLOC_lsrh		= $00010;   { Bit 4:  Limit switch right hardware }
	BITLOC_lsls		= $00020;   { Bit 5:  Limit switch left software }
	BITLOC_lsrs		= $00040;   { Bit 6:  Limit switch right software }
	BITLOC_mpe		= $00080;   { Bit 7:  Maximum Position Error }
	BITLOC_dhef		= $00100;   { Bit 8:  data handling error flag }
	BITLOC_cef		= $00200;   { Bit 9:  configuration error flag }
                                { Bit 10..11: currently not used }
	BITLOC_pe		= $01000;   { Bit 12: Profile end }
	BITLOC_cl		= $02000;   { Bit 13: Closed loop }
	BITLOC_ip		= $04000;   { Bit 14: In Position }
	BITLOC_ui		= $08000;   { Bit 15: user input }
	BITLOC_lpsf		= $10000;   { Bit 16: latched position synchronous flag }
                                { Bit 17..29: currently not used }
                                { Bit 30..31: for internal use only }

    { Constants for MCU-G3 Board Types }
   	UNKNOWNBOARD = $0;          { unknown board type }
    MCU3000 	 = $4;          { G3-Controller MCU-3000 }
    APCI8001	 = $4;          { G3-Controller APCI-8001 }
    MCU6000 	 = $8;          { G3-Controller MCU-6000 }
    APCI8401 	 = $8;          { G3-Controller APCI-8401 }


type
  { Macros for handling of strings for different Delphi Versions }
  {$IFDEF CONDITIONALEXPRESSIONS} 			{ CompilerVersion is only defined since Delphi 6}
  	{ IF - IFEND is only available since Delphi 6}
  	{$IF (CompilerVersion < 20)}	{ CompilerVersion 19 = Delphi 2008}
  		CppString = PChar;
      CppChar = Char;
  	{$IFEND}
  	{$IF (CompilerVersion >= 20)} 	{CompilerVersion 20 = Delphi 2009 }
  		CppString = PAnsiChar;
      CppChar = AnsiChar;
  	{$IFEND}
  {$ELSE}
     CppString = PChar;
     CppChar = Char;
  {$ENDIF}

    { Enumeration for Position units }
	PUS = (
		MM, INCH, M, REV, DEG, RAD, COUNTS, STEPS
	);

    { Enumeration for Time units }
	TUS = (
		SEC, MIN, TSAMPLE
	);


	TSRP = record
		{ Common-Data for DLL-interface-driver MCUG3.DLL and PC-Application-Program(s) }
		an:	    integer;  { Axis-Number }
		kp:	    double;	  { PIDF filter parameter kp }
		ki:	    double;	  { PIDF filter parameter ki }
		kd:	    double;	  { PIDF filter parameter kd }
		kpl:	double;	  { PIDF filter parameter kpl }
		kfca:	double;	  { PIDF forward compensation acceleration }
		kfcv:	double;	  { PIDF forward compensation velocity }
		jac:	double;	  { jog acceleration }
		jvl:	double;	  { jog velocity }
		jtvl:	double;	  { target velocity }
		jovr:	double;	  { jog override }
		hac:	double;	  { home acceleration }
		hvl:	double;	  { home velocity }
		rp:	    double;	  { real position }
		dp:	    double;	  { desired position }
		tp:	    double;	  { target position }
		dv:	    double;	  { desired velocity }
		lp:	    double;	  { latched position }
		aux:	double;	  { auxiliary value }
		sll:	double;	  { software limit left }
		slr:	double;	  { software limit right }
		ipw:	double;	  { in position window }
		mpe:	double;	  { maximum position error }
		sdec:	double;	  { stop deceleration }
		gf:	    double;	  { gear factor }
		mcp:	integer;  { motor command port }
		axst:	integer;  { axis status  }
		lsm:	integer;  { left spool memory }

		epc:	integer;  { eeprom programming cycle }
		digi:   integer;  { dig. inputs = asmi (MCU-6000, APCI-8401) }
		digo:	integer;  { dig. outputs =  asmo (MCU-6000, APCI-8401) }
		ifs:	integer;  { interface status = asms (MCU-6000, APCI-8401) }

		scratch: array[0..3] of integer;
                          { reserved space don't delete!! }
	end;

	AS_ = record
		{ Axis-Selection }
		unoa:	integer;  { Number of used axis }
		san:	array [0..MAXAXIS-1] of integer;
                          { Axis Numbers }
	end;

	TRU = record
		{ Trajectory Units }
		pu:	    integer;   { position unit, see type definition PUS above }
		tu:	    integer;   { time unit, see type definition TUS above }
	end;

	LMP = record
		{ Linear Motion Profile parameters }
		ac:	    double;	   { trajectory acceleration  }
		vl:	    double;	   { trajectory velocity }
		tvl:	double;	   { trajectory target velocity }
		dtm:	array [0..MAXAXIS-1] of double;
                           { distance to move }
	end;

	CMP = record
		{ Circular Motion Profile parameters }
		ac:	    double;	   { trajectory acceleration  }
		vl:	    double;	   { trajectory velocity }
		tvl:	double;	   { trajectory target velocity }
		phi:	double;	   { angel phi }
		dtca1:	double;	   { center point of axis 1 }
		dtca2:	double;	   { center point of axis 2 }
	end;

	HMP = record
		{ Helical Motion Profile parameters }
		ac:	    double;	   { trajectory acceleration  }
		vl:	    double;	   { trajectory velocity }
		tvl:	double;	   { trajectory target velocity }
		phi:	double;	   { angel phi }
		dtca1:	double;	   { center point of axis 1 }
		dtca2:	double;	   { center point of axis 2 }
		dtm:    array [0..MAXAXIS-1] of double;
						   { distance to move axis 3..n }
	end;

	HMP3D = record
		{ 3D Helical Motion Profile parameters }
		ac:	    double;	   { trajectory acceleration  }
		vl:	    double;	   { trajectory velocity }
		tvl:	double;	   { trajectory target velocity }
		phi:	double;	   { angel phi }
		dtca1:	double;	   { center point of axis 1 }
		dtca2:	double;	   { center point of axis 2 }
		dtca3:	double;	   { center point of axis 3 }
		pn1:	double;	   { area perpendicular of axis 1 (Flchen-Normale A1) }
		pn2:	double;	   { area perpendicular of axis 2 (Flchen-Normale A2) }
		pn3:	double;	   { area perpendicular of axis 3 (Flchen-Normale A3) }
		dtm:    array [0..MAXAXIS-1] of double;
						   { distance to move axis 3..n }
	end;

	CNCTS = record
        { CNC-Task Status variables }
		errnum:	  integer;  { error number }
		errline:  integer;	{ error line }
		stackfree:integer;	{ stack bytes free }
		running:  integer;	{ nc task running status }
		csrcline: integer;	{ current (processed) source line number }
	end;

	ROSI = record
		{ RISC Operating System Informations }
		revision:	    array[0..SIZE_STRREV-1] of CppChar;
                            { software-revision-string }
		number_axis:	integer;
                            { number of supplied axis }
		sysfile_loaded:	integer;
                            { status flag for sysfile already loaded }
	end;

	CIBUF = record
        { Buffer definition for common integer variables }
		civals:	array[0..SIZE_CIBUF-1] of integer;
	end;

	CDBUF = record
    	{ Buffer definition for common double variables }
		cdvals:	array[0..SIZE_CDBUF-1] of double;
	end;

	CBCNCT = record
        { Common CNC-Task buffer }
		TaskNr:  integer;	{ Task Number 0..3 }
		size:    integer;	{ size of Buffer [bytes] }
		BuffPtr: pointer;	{ pointer to user allocated buffer }
	end;

	SPDBUF = record
        { position data to spool }
		dtm:     double;	{ distance to move }
	end;

	SPVTDBUF = record
    	{ position, velocity, time datas to spool }
		dtm: 	double;	    { distance to move }
		vl:	    double;	    { velocity }
		t:	    double;	    { time }
	end;

    CTRLRPARAMS = record
    	{ Controller specific data fields (application specicfic) }
       	val:    array[0..SCPSZ_R-1, 0..SCPSZ_C-1] of double;
    end;

    SPD2DPARAMS = record
    	size:   integer;
                            { size }
        san:    array[0..1] of integer;
                            { selected axis numbers }
	    dtma1:  array[0..SPD2D_S-1] of double;
                            { distance to move axis 1 }
	    dtma2:  array[0..SPD2D_S-1] of double;
                            { distance to move axis 2 }
    end;
	LATCH_INFOS = record
        { parameter set for latching position datas }
   		san:	integer;	{ selected axis number }
		lst:	double;		{ latch start time }
		let:	double;		{ latch end time }
		pu:	    integer;	{ position unit }
		tu:	    integer;	{ time unit }
	end;

    OLSR_INFOS = record
    	{ parameter set for open loop system response }
		san:    integer;	{ selected axis number }
	    delay:  double;		{ delay [s] }
	    mcp:    double;		{ motor command value [V] }
    end;

    FILEHEADER = record
    { CNC Task File Header Information }
    TaskNr:         integer;
         					{ NC-File runs in task 'TaskNr' 0..3 }
		SrcFileName:    array[0..SIZE_FILENAMES-1] of CppChar;
                            { CNC Source File Name }
    CncFileName:    array[0..SIZE_FILENAMES-1] of CppChar;
                            { CNC pseudo code file name }
		RevNr:          array[0..SIZE_STRREV-1] of CppChar;
                            { revision number }
		DateTimearray:  array[0..SIZE_TIME-1] of CppChar;
                            { build date and time information }
    end;

    ATAccessType            = (ATAccessNone, ATAccessInput, ATAccessOutput, ATAccessInputOutput);
    ATDataType              = (ATDataNone, ATDataByte, ATDataWord, ATDataDoubleWord, ATDataReal, ATDataSingle);

    OptionDescriptorObject = record
		Handle:       integer;         { do not change that! }
		AccessType:   integer;         { Read, Write, Flag }
        DataType:     integer;         { Byte, Word, Double Word, Real, ... }
        BusNumber:    integer;         { Interbus, Canbus, G3-Resourcebus, Scannerbus ... }
        DeviceNumber: integer;         { depends on Bus Type }
        Index:        integer;         { depends on Bus Type }
        SubIndex:     integer;         { depends on Bus Type }
    end;

    { Delphi only specific declarations ... }

	POSBUF = record
		pos:	array[0..SIZE_POSBUF-1] of double; { position values }
	end;

	TSRPSETS = array[0..MAXAXIS-1] of TSRP;
{
  +-----------------------------------------------------------------------+
  | Prototypes standard functions,                                        |
  | functions are described in MCU-G3 Programming Manual                  |
  +-----------------------------------------------------------------------+
}

procedure	uf	    (var tsrp:TSRP); far; stdcall; 				{ update filter }
procedure	ctru	(var tru:TRU); far; stdcall;                { change trajectory parameters }
procedure	wrjac	(var tsrp:TSRP); far; stdcall; 				{ write jog acceleration }
procedure	wrjvl	(var tsrp:TSRP); far; stdcall; 				{ write jog velocity }
procedure	wrjtvl	(var tsrp:TSRP); far; stdcall; 				{ write jog target velocity }
procedure	wrhac	(var tsrp:TSRP); far; stdcall; 				{ write home acceleration }
procedure	wrhvl	(var tsrp:TSRP); far; stdcall; 				{ write home velocity }
procedure	wrrp	(var tsrp:TSRP); far; stdcall; 				{ write real position }
procedure	wrdp	(var tsrp:TSRP); far; stdcall; 				{ write desired position }
procedure	wrlp	(var tsrp:TSRP); far; stdcall; 				{ write latched position }
procedure	wraux	(var tsrp:TSRP); far; stdcall; 				{ write auxiliary value }
procedure	shp	    (var tsrp:TSRP); far; stdcall; 				{ set home position }
procedure	wrdigo	(var tsrp:TSRP); far; stdcall; 				{ MCU-3000, APCI-8001 only: write digital outputs }
procedure	wrdigob	(an:integer; bitnr:integer; value:integer); far; stdcall;
                                                                { MCU-3000, APCI-8001 only: write digital output bit }
procedure	wrasmo	(var tsrp:TSRP); far; stdcall; 				{ MCU-6000, APCI-8401 only: write ASM digital outputs }
procedure	wrasmob	(an:integer; bitnr:integer; value:integer); far; stdcall;
                                                                { MCU-6000, APCI-8401 only: write ASM digital output bit }
procedure	rdrp	(var tsrp:TSRP); far; stdcall; 				{ read real position }
procedure	rddp	(var tsrp:TSRP); far; stdcall; 				{ read desired position }
procedure	rdtp	(var tsrp:TSRP); far; stdcall; 				{ read target position }
procedure	rddv	(var tsrp:TSRP); far; stdcall; 				{ read desired velocity }
procedure	rdlp	(var tsrp:TSRP); far; stdcall; 				{ read latched position }
procedure	rdaux	(var tsrp:TSRP); far; stdcall; 				{ read auxiliary value }
procedure	rddigi	(var tsrp:TSRP); far; stdcall; 				{ MCU-3000, APCI-8001 only: read digital inputs }
function		rddigib	(an:integer; bitnr:integer):integer; far; stdcall;
                                                                { MCU-3000, APCI-8001 only: read digital input bit }
function 	rdifs	(var tsrp:TSRP):integer; far; stdcall; 				{ MCU-3000, APCI-8001 only: read interface status }
function		rdifsb	(an:integer; bitnr:integer):integer; far; stdcall;
                                                                { MCU-3000, APCI-8001 only: read interface status bit }
procedure	rddigo	(var tsrp:TSRP); far; stdcall; 				{ MCU-3000, APCI-8001 only: read digital outputs }
function	rddigob	(an:integer; bitnr:integer):integer; far; stdcall;
                                                                { MCU-3000, APCI-8001 only: read digital output bit }
procedure	rdasmi	(var tsrp:TSRP); far; stdcall; 				{ MCU-6000, APCI-8401 only: read ASM digital inputs }
function	rdasmib	(an:integer; bitnr:integer):integer; far; stdcall;
                                                                { MCU-6000, APCI-8401 only: read ASM digital input bit }
procedure	rdasms	(var tsrp:TSRP); far; stdcall; 				{ MCU-6000, APCI-8401 only: read ASM status }
function	rdasmsb	(an:integer; bitnr:integer):integer; far; stdcall;
                                                                { MCU-6000, APCI-8401 only: read ASM status bit }
procedure	rdepc   (var tsrp:TSRP); far; stdcall; 				{ MCU-6000, APCI-8401 only: read eeprom programming cycle }
procedure	rdasmepc(var tsrp:TSRP); far; stdcall; 				{ MCU-6000, APCI-8401 only: read ASM eeprom programming cycle }
procedure	rdasmo	(var tsrp:TSRP); far; stdcall; 				{ MCU-6000, APCI-8401 only: read ASM digital outputs }
function	rdasmob	(an:integer; bitnr:integer):integer; far; stdcall;
                                                                { MCU-6000, APCI-8401 only: read ASM digital output bit }
procedure	rdlsm	(var tsrp:TSRP); far; stdcall; 				{ read left spool memory }
procedure	rdaxst	(var tsrp:TSRP); far; stdcall; 				{ read axis status }
function	rdaxstb	(an:integer; bitnr:integer):integer; far; stdcall;
                                                                { read axis status bit }
procedure	rdjac	(var tsrp:TSRP); far; stdcall; 				{ read jog acceleration }
procedure	rdjvl	(var tsrp:TSRP); far; stdcall; 				{ read jog velocity }
procedure	rdjtvl	(var tsrp:TSRP); far; stdcall; 				{ read jog target velocity }
procedure	rdhac	(var tsrp:TSRP); far; stdcall; 				{ read home acceleration }
procedure	rdhvl	(var tsrp:TSRP); far; stdcall; 				{ read home velocity }
procedure	cl	    (var as_:AS_); far; stdcall; 				{ close loop }
procedure	clv	    (var as_:AS_); far; stdcall; 				{ close loop velocity}
procedure	ol	    (var as_:AS_); far; stdcall; 				{ open loop }
procedure	ra	    (var as_:AS_); far; stdcall; 				{ reset axis }
procedure	rifs	(var tsrp:TSRP); far; stdcall; 				{ MCU-3000, APCI-8001 only: reset interface status flags }
procedure	rasms	(var tsrp:TSRP); far; stdcall; 				{ MCU-6000, APCI-8401 only: reset ASM status flags }
procedure	rs;     far; stdcall; 				                { reset system }
procedure	azo	    (set_:integer); far; stdcall; 				{ activate zero offset }
procedure	jr	    (var as_:AS_; var tsrp:TSRPSETS); far; stdcall;
                                                                { jog relative }
procedure	ja	    (var as_:AS_; var tsrp:TSRPSETS); far; stdcall;
                                                                { jog absolute }
procedure	jhl	    (var as_:AS_); far; stdcall; 				{ jog home left }
procedure	jhr	    (var as_:AS_); far; stdcall; 				{ jog home right }
procedure	jhi	    (var as_:AS_; var tsrp:TSRPSETS); far; stdcall;
                                                                { jog relative (to) index }
procedure	mlr	    (var as_:AS_; var lmp:LMP); far; stdcall;  	{ move linear relative }
procedure	mla	    (var as_:AS_; var lmp:LMP); far; stdcall;  	{ move linear absolute }
procedure	mcr	    (var as_:AS_; var cmp:CMP); far; stdcall;  	{ move circular relative }
procedure	mca	    (var as_:AS_; var cmp:CMP); far; stdcall;  	{ move circular absolute }
procedure	mhr	    (var as_:AS_; var hmp:HMP); far; stdcall;  	{ move helix relative }
procedure	mha	    (var as_:AS_; var hmp:HMP); far; stdcall;  	{ move helix absolute }
procedure	mca3d   (var as_:AS_; var hmp3d:HMP3D); far; stdcall; { move 3D circular absolute }
procedure	mcr3d   (var as_:AS_; var hmp3d:HMP3D); far; stdcall; { move 3D circular absolute }
procedure	smlr	(var as_:AS_; var lmp:LMP); far; stdcall;  	{ spool motion linear relative }
procedure	smla	(var as_:AS_; var lmp:LMP); far; stdcall;  	{ spool motion linear absolute }
procedure	smcr	(var as_:AS_; var cmp:CMP); far; stdcall;  	{ spool motion circular relative }
procedure	smca	(var as_:AS_; var cmp:CMP); far; stdcall;  	{ spool motion circular absolute }
procedure	smhr	(var as_:AS_; var hmp:HMP); far; stdcall;  	{ spool motion helix relative }
procedure	smha	(var as_:AS_; var hmp:HMP); far; stdcall;  	{ spool motion helix absolute }
procedure	smca3d  (var as_:AS_; var hmp3d:HMP3D); far; stdcall; { spool move 3D circular absolute }
procedure	smcr3d  (var as_:AS_; var hmp3d:HMP3D); far; stdcall; { spool move 3D circular absolute }
procedure	ssms	(var as_:AS_); far; stdcall; 				{ start spooled motions synchronous }
procedure	sstps	(var as_:AS_); far; stdcall; 				{ stop spooled motions synchronous }
procedure	sdels	(var as_:AS_); far; stdcall; 				{ delete spooled motions synchronous }
function	txbf	(filename:CppString):integer; far; stdcall;     { transmit binary file }
function	txbf2	(filename:CppString):integer; far; stdcall;     { transmit binary file, 2nd method }
procedure	startcnct(TaskNr:integer); far; stdcall; 		   	{ start nc task }
procedure	stopcnct(TaskNr:integer); far; stdcall; 			{ stop nc task }
procedure	contcnct(TaskNr:integer); far; stdcall; 			{ continue nc task }
procedure	stepcnct(TaskNr:integer); far; stdcall; 			{ step nc task }
procedure	rdcncts	(TaskNr:integer; var cncts:CNCTS); far; stdcall;
                                                            	{ read cnc task status }
function	rdcbcnct(var cbcnct:CBCNCT):integer; far; stdcall; 	{ read cnc task spec. common buffer }
function	wrcbcnct(var cbcnct:CBCNCT):integer; far; stdcall; 	{ write cnc task spec. common buffer }
procedure	rdci	(ndx:integer; var cibuf:CIBUF); far; stdcall;
                                                                { read common integer }
procedure	rdcd	(ndx:integer; var cdbuf:CDBUF); far; stdcall;
                                                                { read common double }
procedure	wrci	(ndx:integer; var cibuf:CIBUF); far; stdcall;
                                                                { write common integer variables }
procedure	wrcd	(ndx:integer; var cdbuf:CDBUF); far; stdcall;
                                                                { write common double variables }
procedure	rdmcp	(var tsrp:TSRP); far; stdcall; 				{ read motor command port }
procedure	wrmcp	(var tsrp:TSRP); far; stdcall; 				{ write motor command port }
procedure	wrledrd	(value:integer); far; stdcall; 				{ write led red }
procedure	wrledyl	(value:integer); far; stdcall; 				{ write led yellow }
procedure	wrledgn	(value:integer); far; stdcall; 				{ write led green }
function	rdledrd	:integer; far; stdcall; 			        { read led red }
function	rdledyl	:integer; far; stdcall; 			        { read led yellow }
function	rdledgn	:integer; far; stdcall; 			        { read led green }
function	rdirqpc	:integer; far; stdcall; 			        { read irq pc }
procedure	mcuinit	(var rosi:ROSI); far; stdcall; 				{ MCU-G3 initialisition }
procedure	mcuinit2(var rosi:ROSI; TpuBaseAddress: integer); far; stdcall;
                                                                { MCU-G3 initialisition, 2nd method }
procedure	wrjovr	(var tsrp:TSRP); far; stdcall; 				{ write jog override }
procedure	rdjovr	(var tsrp:TSRP); far; stdcall; 				{ read jog override }
procedure	wrtrovr	(var value:double); far; stdcall; 			{ write trajectory override }
procedure	rdtrovr	(var value:double); far; stdcall; 			{ read trajectory override }
function	wrtrovrst	(var value:double): integer; far; stdcall; 		{ write trajectory override settling time }
function  	rdtrovrst	(var value:double): integer; far; stdcall; 		{ read trajectory override settling time }
function	wrShortProfile (var value:double): integer; far; stdcall; 	{ write System Var ShortProfile - threshold profile length for NoTriangle }
function  	rdShortProfile (var value:double): integer; far; stdcall; 	{ read System Var ShortProfile - threshold profile length for NoTriangle }
procedure	utrovr	(var as_:AS_); far; stdcall; 				{ update trajectory override }
procedure	rdf	    (var tsrp:TSRP); far; stdcall; 				{ read filter *}
procedure	rdap	(var tsrp:TSRP); far; stdcall; 				{ read axis parameters *}
procedure	rdsll	(var tsrp:TSRP); far; stdcall; 				{ read software limit left *}
procedure	wrsll	(var tsrp:TSRP); far; stdcall; 				{ write software limit left *}
procedure	rdslr	(var tsrp:TSRP); far; stdcall; 				{ read software limit right *}
procedure	wrslr	(var tsrp:TSRP); far; stdcall; 				{ write software limit right *}
procedure	rdipw	(var tsrp:TSRP); far; stdcall; 				{ read in position window *}
procedure	wripw	(var tsrp:TSRP); far; stdcall; 				{ write in position window *}
procedure	rdmpe	(var tsrp:TSRP); far; stdcall; 				{ read maximum position error *}
procedure	wrmpe	(var tsrp:TSRP); far; stdcall; 				{ write maximum position error *}
procedure	rdsdec	(var tsrp:TSRP); far; stdcall; 				{ read stop deceleration }
procedure	wrsdec	(var tsrp:TSRP); far; stdcall; 				{ write stop deceleration }
procedure	spd	    (an:integer; size:integer; var spdbuf:SPDBUF); far; stdcall;	{ spool position data }
procedure	spda	(an:integer; size:integer; var spdbuf:SPDBUF; PcapIndex: integer); far; stdcall;	{ spool position data absolute indicated }
procedure	spdr	(an:integer; size:integer; var spdbuf:SPDBUF; PcapIndex: integer); far; stdcall;	{ spool position data relative indicated}
procedure	sstvl	(var as_:AS_; tvl: double); far; stdcall; 				{ spooler set target velocity }

procedure	wrgf	(var tsrp:TSRP); far; stdcall; 				{ write gear factor *}
procedure	rdgf	(var tsrp:TSRP); far; stdcall; 				{ read gear factor *}
procedure	spvtd	(an:integer; size:integer; var spvtdbuf:SPVTDBUF); far; stdcall;
                                                                { spool position, velocity, time data }
procedure	ms	    (var as_:AS_); far; stdcall; 				{ motion stop }
procedure	js	    (var as_:AS_); far; stdcall; 				{ jog stop }
procedure	lps	    (an:integer; mst:integer); far; stdcall; 	{ latch position synchronous }
procedure	rdigi	(var tsrp:TSRP); far; stdcall; 			    { MCU-3000, APCI-8001 only: reset digital inputs }
procedure	rdlpndx	(var tsrp:TSRP); far; stdcall; 			    { MCU-3000, APCI-8001 only: read latched position index }
procedure	wrlpndx	(var tsrp:TSRP); far; stdcall; 			    { MCU-3000, APCI-8001 only: write latched position index }
procedure	ssf     (an: integer; command: integer; value: double); far; stdcall;
																{ Spooler-Special-Function-Command }
procedure	ssfn    (var as_:AS_; command: integer; value: double); far; stdcall;
																{ Spooler-Special-Function-Command for more than one axis}

function	InitMcuSystem(var tsrp:TSRPSETS):integer; far; stdcall;
                                                                { initialisation function first method, (you should not use this function, instead use InitMcuSystem2() or even better InitMcuSystem3()) }
function	InitMcuSystem2(var tsrp:TSRPSETS; TpuBaseAddress:integer; filename: CppString):integer; far; stdcall;
																{ initialisation function, 2nd method }
function	InitMcuSystem3(var tsrp:TSRPSETS; var rosi:ROSI; TpuBaseAddress:integer; filename: CppString; var BoardType: integer):integer; far; stdcall;
																{ initialisation function, 3rd method }
function	InitMcuSystem4(var tsrp:TSRPSETS; var rosi:ROSI; TpuBaseAddress:integer; filename: CppString; var BoardType: integer; var NrCards: integer):integer; far; stdcall;
																{ initialisation function, 4th method (method 3 with additional number of cards result) }
procedure	InitMcuErrorReport(error:integer); far; stdcall; 	{ detailed initialisation error report function }
procedure	txbfErrorReport(filename:CppString; error:integer); far; stdcall;
																{ detailed load error report function }
procedure	BootErrorReport(filename:CppString; error:integer); far; stdcall;
																{ detailed boot error report function }
procedure   McuClose; far; stdcall;                             { close driver function, must be called at end of program ! }
function    BootFile       (filename:CppString; TpuBaseAddress:integer):integer; far; stdcall;  { Send Bootfile (i.e. rwmos.elf) to controller board }
procedure	LdSSplineA	   (var as_:AS_; var lmp:LMP); far; stdcall;
																{ Load Spool Spline Data Absolut }
procedure	LdSSplineR	   (var as_:AS_; var lmp:LMP); far; stdcall;
                                                                { Load Spool Spline Data Relativ }
procedure	ExeSSpline	   (var as_:AS_; var lmp:LMP); far; stdcall;
                                                                { Execute Spool Spline }

function    wrOptionInt	   (var odesc: OptionDescriptorObject; var val: integer): integer; far; stdcall;
																{ Option Object write integer function }
function    rdOptionInt    (var odesc: OptionDescriptorObject; var val: integer): integer; far; stdcall;
																{ Option Object read integer function }
function    wrOptionDbl	   (var odesc: OptionDescriptorObject; var val: double): integer; far; stdcall;
																{ Option Object write double function }
function    rdOptionDbl    (var odesc: OptionDescriptorObject; var val: double): integer; far; stdcall;
																{ Option Object read double function }
function    freeOptionHandle(var odesc: OptionDescriptorObject): integer; far; stdcall;
																{ Option Object free handle }

function    rdScannerBufferSize	: integer; far; stdcall;  		{ Read size of scan buffer }
function    rdScannerStatus	: integer; far; stdcall;        	{ read scanner status register }
function    rdScannerLsm	: integer; far; stdcall;           	{ read scanner left spool memory }
function    rdScannerBuffer	(buffer: CppString; size: integer): integer; far; stdcall; 				{ read scanner buffer }
function    SendReqScannerBuffer (buffer: CppString; size: integer): integer; far; stdcall; 		{ read scanner buffer per Send Request }
procedure	CleanServiceData; far; stdcall;															{ freeing PhysMem in rwPhysMemService (optional) }

function    wrElCamTable32	(buffer: CppString; size: integer; ElCamTableNr: integer): integer; far; stdcall;
																{ write ElCAM Table 32bit floating Point }
function    wrElCamTable64	(buffer: CppString; size: integer; ElCamTableNr: integer): integer; far; stdcall;
																{ write ElCAM Table 64bit floating Point }


procedure	wrModeReg  (var value: integer); far; stdcall;		{ write Mode Register }
procedure	rdModeReg  (var value: integer); far; stdcall;		{ read Mode Register }
procedure	wrnfrax    (var value: integer); far; stdcall;		{ write No-Feed-Rate-Axis }
procedure	rdnfrax    (var value: integer); far; stdcall;		{ read No-Feed-Rate-Axis }
procedure	wrErrorReg (var value: integer); far; stdcall;		{ write Error Register }
procedure	rdErrorReg (var value: integer); far; stdcall;		{ read Error Register }
procedure	wrMDVel    (an: integer; var value: double); far; stdcall;
																{write Maximum Delta Velocity at axis}
procedure	rdMDVel    (an: integer; var value: double); far; stdcall;
																{read Maximum Delta Velocity from axis}
procedure	wrMaxVel   (an: integer; var value: double); far; stdcall;
																{write Maximum Axis Velocity at axis}
procedure	rdMaxVel   (an: integer; var value: double); far; stdcall;
																{read Maximum axis Velocity from axis}
procedure	wrMaxAcc   (an: integer; var value: double); far; stdcall;
																{write Maximum Axis Acceleration at axis}
procedure	rdMaxAcc   (an: integer; var value: double); far; stdcall;
																{read Maximum axis Acceleration from axis}
procedure	wrEffRadius(an: integer; var value: double); far; stdcall;
																{write Effective Radius for rotatoric Axis}
procedure	rdEffRadius(an: integer; var value: double); far; stdcall;
																{read Effective Radius for rotatoric Axis}
procedure	rdPosErr   (an: integer; var value: double); far; stdcall;
																{read Position Error}
procedure	rdMCiS     (an: integer; var value: integer); far; stdcall;
																{read Motion-Commands-in-Spooler}
procedure	wrJerkRel     (an: integer; var value: double); far; stdcall;
																{write Jerk-Factor 0..1}
procedure	rdJerkRel     (an: integer; var value: double); far; stdcall;
																{read Jerk-Factor 0..1}
procedure	wrJerk     (an: integer; var value: double); far; stdcall;
																{write Jerk-Value in UU / (TU*TU*TU)}
procedure	rdJerk     (an: integer; var value: double); far; stdcall;
																{read Jerk-Value in UU / (TU*TU*TU) }
procedure	wrslsp     (an: integer; var value: double); far; stdcall;
																{write slsp}
function	rdslsp     (an: integer; var value: double): integer; far; stdcall;
																{read slsp}
function	accstop	    (var as_: AS_): integer; far; stdcall;  { acceleration stop in JOG-S-Profiles }
function	getEnvStr	(EnvStr: CppString): integer; far; stdcall; { get Environment String }
function	gettskinfo	(TaskNr: integer; var tskinfo: integer): integer; far; stdcall;
																{ get Task Information }
function	gettskstr	(TaskNr: integer; buffer: CppString; szbuffer: integer): integer; far; stdcall;
																{ get TaskMessage String }
function	CardSelect  (CardNum: integer): integer; far; stdcall;
																{Selection with more than one cards in PC}
procedure	MsgToScreen (Enable: integer); far; stdcall;		{ enable / disable screen messages }
procedure	rdOsVersion	(var OsVersion: integer); far; stdcall; { read Version of RWMOS-Operating System }
procedure	ClearCI99   (); far; stdcall; 						{ CI99 := 0 }
procedure	RPtoDP	    (var as_:AS_); far; stdcall; 			{ Real Position to Desired Position }

{
  +---------------------------------------------------------------------------------+
  |    Prototypes for client and application specific functions,                    |
  |    do not use when you have no information about the individual functions !!!   |
  |    (normaly you should not need that functions)                                 |
  +---------------------------------------------------------------------------------+
}

procedure	wrBlk   (buffer: CppString); far; stdcall;              { Common Write Command without return value (internal function) }
function	rdBlk   (buffer: CppString):integer; far; stdcall;      { Common read command }
procedure	wrtp    (var tsrp: TSRP); far; stdcall;             { write target position }
procedure	rdrpd   (var tsrp: TSRP); far; stdcall;             { read real position display }
procedure	rddpd   (var tsrp: TSRP); far; stdcall;             { read desired position display }
procedure	rdtpd   (var tsrp: TSRP); far; stdcall;             { read target position display }
procedure	scp     (an: integer; var ctrlrparams: CTRLRPARAMS); far; stdcall;
																{ set controller parameters }
procedure	rdrv    (an: integer; var value: double); far; stdcall;
																{ read command velocity }
procedure	cm      (an: integer; var value: integer); far; stdcall;
																{ change mode }
procedure	spd2d   (var spd2params: SPD2DPARAMS); far; stdcall;{ spool position datas 2D }
procedure	rdlrpr  (var latch_infos: LATCH_INFOS; var buffer: POSBUF); far; stdcall;
																{ read latched real pos. registers }
procedure	rdldpr  (var latch_infos: LATCH_INFOS; var buffer: POSBUF); far; stdcall;
                                                                { read latched desired pos. registers }
procedure	getcnctsrclinenr (TaskNr: integer; var LineNr: integer); far; stdcall;
                                                                { read in current linenumber beeing processed of selected cnc task }
function	getmsgstr(an: integer; result: CppString):integer; far; stdcall;
                                                                { read in internal MCU-G3 debug-string }
procedure	getcnctfh(TaskNr: integer; var fh: FILEHEADER); far; stdcall;
                                                                { read in CNC-task-fileheader of selected cnc task }
procedure	burnaplpar(an: integer); far; stdcall;          { burn appliance parameters }
procedure	gettimers(var tsrp: TSRP; an: integer); far; stdcall;
                                                                { read in several debug-timers of high-prior task }
procedure	lpr      (var latch_infos: LATCH_INFOS); far; stdcall;
																{ latch position registers }
procedure	lprs     (var as_: AS_; var latch_infos: LATCH_INFOS); far; stdcall;
                                                                { latch position registers synchronous on several axis }
procedure	olsr     (var olsr: OLSR_INFOS); far; stdcall;      { open loop system response }
procedure	rdasmecs (var tsrp: TSRP; var an: integer); far; stdcall;
                                                                { MCU-6000, APCI-8401 only: read in ASM eprom checksum of firmware }
procedure	ReadLinkStatus (var fae: integer; var ba: integer); far; stdcall;
																{ read current link stati }
function	rdAin    (an: integer; channel: integer):integer; far; stdcall;
																{ MCU-3000, APCI-8001 only: read Analog Inputs from OPMF-3001 }
procedure	szpa      (an: integer; Position: double); far; stdcall;
																{ Set Zero Position absolut}
procedure	szpr      (an: integer; Position: double); far; stdcall;
																{ Set Zero Position relativ}
procedure	rdMcuStatus(buffer: CppString; size: integer); far; stdcall;
                                                                { read in MCU G3 status registers }
procedure	rdAsmSecureParams(an: integer; buffer: CppString); far; stdcall;
                                                                { MCU-6000, APCI-8401 only: read ASM-EEPROM parameters (firmware data) }
procedure	wrAsmSecureParams(an: integer; buffer: CppString); far; stdcall;
																{ MCU-6000, APCI-8401 only: write ASM-EEPROM parameters (firmware data) }

function 	MCUG3_SetBoardIntRoutine (func : pointer) : integer; far; stdcall;
																{ install an interrupt handler }
function 	MCUG3_ResetBoardIntRoutine () : integer; far; stdcall;
																{ uninstall the interrupt handler }
function	wrdpoffset (an: integer; var value: double) : integer; far; stdcall;
																{ write dpoffset in UU }
function	rddpoffset (an: integer; var value: double) : integer; far; stdcall;
																{ read dpoffset in UU }
function	wrdvoffset (an: integer; var value: double) : integer; far; stdcall;
																{ write dvoffset in UU }
function	rddvoffset (an: integer; var value: double) : integer; far; stdcall;
																{ read dvoffset in UU }
function	rdZeroOffset (an: integer; var value: double) : integer; far; stdcall;
																{ read  absolute Value of actual set Zero Offset }
function	wrtrjerk	(var value: double) : integer; far; stdcall;	{ write trajectory jerk }
function	rdtrjerk	(var value: double) : integer; far; stdcall;	{ read trajectory jerk }
function	wrtrac		(var value: double) : integer; far; stdcall;	{ write trajectory acceleration }
function	rdtrac		(var value: double) : integer; far; stdcall;	{ read trajectory acceleration }
function	wrtrvl		(var value: double) : integer; far; stdcall;	{ write trajectory velocity }
function	rdtrvl		(var value: double) : integer; far; stdcall;	{ read trajectory velocity }
function	wrtrtvl		(var value: double) : integer; far; stdcall;	{ write trajectory target-velocity }
function	rdtrtvl		(var value: double) : integer; far; stdcall;	{ read trajectory target-velocity }
function	rdptp 		(an: integer; var value: double) : integer; far; stdcall;
																		{ read profile target position }
function	rdpir    	(var value: integer) : integer; far; stdcall;	{ read Profile Information Register }
function	rddtv	    (var value: array of double)  : integer; far; stdcall; 	{ read  desired trajectory velocity }

procedure	wrGCR    (an: integer; var value: integer); far; stdcall;	{write Gear-Configuration-Register}
procedure	rdGCR    (an: integer; var value: integer); far; stdcall; 	{read Gear-Configuration-Register}

function	allocPhysMem (var VirtualAdr: Pointer; var PhysAdr: integer; size : integer): integer; far; stdcall; {allocate Phys.Memory}
function	freePhysMem  (VirtualAdr: Pointer): integer; far; stdcall; {freeing Phys.Memory}

function	wrgfaux (an: integer; var value: double) : integer; far; stdcall;
																{ write Auxiliary Gear Factor }
function	rdgfaux (an: integer; var value: double) : integer; far; stdcall;
																{ read Auxiliary Gear Factor }
procedure	wrControllerFlags    (an: integer; var value: integer); far; stdcall;	{write Controller-Flag-Register}
procedure	rdControllerFlags    (an: integer; var value: integer); far; stdcall; 	{read Controller-Flag-Register}
function	rdpeaux		(an: integer; var value: double) : integer; far; stdcall;	{ read difference rp - aux in [UU] }
function	wrVBError	(an: integer; var value: double) : integer; far; stdcall;	{ write Velocity-Blending-Error }
function	rdVBError	(an: integer; var value: double) : integer; far; stdcall;	{ read  Velocity-Blending-Error }

function	rdPcapIndex	(an: integer; var value: integer) : integer; far; stdcall;	{ Read PcapIndex }

function	rdSysVarInt	(cmd: integer; var value: integer) : integer; far; stdcall;	{ read Access to integer Sys-Vars special commands }
function	rdSysVarDbl	(cmd: integer; var value: double)  : integer; far; stdcall;	{ read Access to double Sys-Vars special commands }
function	wrSysVarInt	(cmd: integer; var value: integer) : integer; far; stdcall;	{ write Access to integer Sys-Vars special commands }
function	wrSysVarDbl	(cmd: integer; var value: double)  : integer; far; stdcall;	{ write Access to double Sys-Vars special commands }
function	rdAxVarInt	(cmd: integer; axndx: integer; var value: integer) : integer; far; stdcall;	{ read Access to integer Axis-Vars special commands }
function	rdAxVarDbl	(cmd: integer; axndx: integer; var value: double)  : integer; far; stdcall;	{ read Access to double Axis-Vars special commands }
function	wrAxVarInt	(cmd: integer; axndx: integer; var value: integer) : integer; far; stdcall;	{ write Access to integer Axis-Vars special commands }
function	wrAxVarDbl	(cmd: integer; axndx: integer; var value: double)  : integer; far; stdcall;	{ write Access to double Axis-Vars special commands }

implementation

{ All Functions below are implemented external in DLL-Library DLLDRIVER }

procedure	uf	    (var tsrp:TSRP); external DLLDRIVER;
procedure	ctru	(var tru:TRU); external DLLDRIVER;
procedure	wrjac	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrjvl	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrjtvl	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrhac	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrhvl	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrrp	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrdp	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrlp	(var tsrp:TSRP); external DLLDRIVER;
procedure	wraux	(var tsrp:TSRP); external DLLDRIVER;
procedure	shp	    (var tsrp:TSRP); external DLLDRIVER;
procedure	wrdigo	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrasmo	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrdigob	(an:integer; bitnr:integer; value:integer); external DLLDRIVER;
procedure	wrasmob	(an:integer; bitnr:integer; value:integer); external DLLDRIVER;
procedure	rdrp	(var tsrp:TSRP); external DLLDRIVER;
procedure	rddp	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdtp	(var tsrp:TSRP); external DLLDRIVER;
procedure	rddv	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdlp	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdaux	(var tsrp:TSRP); external DLLDRIVER;
procedure	rddigi	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdasmi	(var tsrp:TSRP); external DLLDRIVER;
function	rddigib	(an:integer; bitnr:integer):integer; external DLLDRIVER;
function	rdasmib	(an:integer; bitnr:integer):integer; external DLLDRIVER;
function	rdifs	(var tsrp:TSRP):integer; external DLLDRIVER;
procedure	rdasms	(var tsrp:TSRP); external DLLDRIVER;
function	rdifsb	(an:integer; bitnr:integer):integer; external DLLDRIVER;
function	rdasmsb	(an:integer; bitnr:integer):integer; external DLLDRIVER;
procedure	rdepc   (var tsrp:TSRP); external DLLDRIVER;
procedure	rdasmepc(var tsrp:TSRP); external DLLDRIVER;
procedure	rddigo	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdasmo	(var tsrp:TSRP); external DLLDRIVER;
function	rddigob	(an:integer; bitnr:integer):integer; external DLLDRIVER;
function	rdasmob	(an:integer; bitnr:integer):integer; external DLLDRIVER;
procedure	rdlsm	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdaxst	(var tsrp:TSRP); external DLLDRIVER;
function	rdaxstb	(an:integer; bitnr:integer):integer; external DLLDRIVER;
procedure	rdjac	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdjvl	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdjtvl	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdhac	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdhvl	(var tsrp:TSRP); external DLLDRIVER;
procedure	cl	    (var as_:AS_); external DLLDRIVER;
procedure	clv	    (var as_:AS_); external DLLDRIVER;
procedure	ol	    (var as_:AS_); external DLLDRIVER;
procedure	ra	    (var as_:AS_); external DLLDRIVER;
procedure	rifs	(var tsrp:TSRP); external DLLDRIVER;
procedure	rasms	(var tsrp:TSRP); external DLLDRIVER;         
procedure	rs;     external DLLDRIVER;
procedure	azo	    (set_:integer); external DLLDRIVER;
procedure	jr	    (var as_:AS_; var tsrp:TSRPSETS); external DLLDRIVER;
procedure	ja	    (var as_:AS_; var tsrp:TSRPSETS); external DLLDRIVER;
procedure	jhl	    (var as_:AS_); external DLLDRIVER;
procedure	jhr	    (var as_:AS_); external DLLDRIVER;
procedure	jhi	    (var as_:AS_; var tsrp:TSRPSETS); external DLLDRIVER;
procedure	mlr	    (var as_:AS_; var lmp:LMP); external DLLDRIVER;
procedure	mla	    (var as_:AS_; var lmp:LMP); external DLLDRIVER;
procedure	mcr	    (var as_:AS_; var cmp:CMP); external DLLDRIVER;
procedure	mca	    (var as_:AS_; var cmp:CMP); external DLLDRIVER;
procedure	mhr	    (var as_:AS_; var hmp:HMP); external DLLDRIVER;
procedure	mha	    (var as_:AS_; var hmp:HMP); external DLLDRIVER;
procedure	mca3d   (var as_:AS_; var hmp3d:HMP3D); external DLLDRIVER;
procedure	mcr3d   (var as_:AS_; var hmp3d:HMP3D); external DLLDRIVER;
procedure	smlr	(var as_:AS_; var lmp:LMP); external DLLDRIVER;
procedure	smla	(var as_:AS_; var lmp:LMP); external DLLDRIVER;
procedure	smcr	(var as_:AS_; var cmp:CMP); external DLLDRIVER;
procedure	smca	(var as_:AS_; var cmp:CMP); external DLLDRIVER;
procedure	smhr	(var as_:AS_; var hmp:HMP); external DLLDRIVER;
procedure	smha	(var as_:AS_; var hmp:HMP); external DLLDRIVER;
procedure	smca3d  (var as_:AS_; var hmp3d:HMP3D); external DLLDRIVER;
procedure	smcr3d  (var as_:AS_; var hmp3d:HMP3D); external DLLDRIVER;
procedure	ssms	(var as_:AS_); external DLLDRIVER;
procedure	sstps	(var as_:AS_); external DLLDRIVER;
procedure	sdels	(var as_:AS_); external DLLDRIVER;
function	txbf	(filename:CppString):integer; external DLLDRIVER;
function	txbf2	(filename:CppString):integer; external DLLDRIVER;
procedure	startcnct(TaskNr:integer); external DLLDRIVER;
procedure	stopcnct(TaskNr:integer); external DLLDRIVER;
procedure	contcnct(TaskNr:integer); external DLLDRIVER;
procedure	stepcnct(TaskNr:integer); external DLLDRIVER;
procedure	rdcncts	(TaskNr:integer; var cncts:CNCTS); external DLLDRIVER;
function	rdcbcnct(var cbcnct:CBCNCT):integer; external DLLDRIVER;
function	wrcbcnct(var cbcnct:CBCNCT):integer; external DLLDRIVER;
procedure	rdci	(ndx:integer; var cibuf:CIBUF); external DLLDRIVER;
procedure	rdcd	(ndx:integer; var cdbuf:CDBUF); external DLLDRIVER;
procedure	wrci	(ndx:integer; var cibuf:CIBUF); external DLLDRIVER;
procedure	wrcd	(ndx:integer; var cdbuf:CDBUF); external DLLDRIVER;
procedure	rdmcp	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrmcp	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrledrd	(value:integer); external DLLDRIVER;
procedure	wrledyl	(value:integer); external DLLDRIVER;
procedure	wrledgn	(value:integer); external DLLDRIVER;
function	rdledrd	:integer; external DLLDRIVER;
function	rdledyl	:integer; external DLLDRIVER;
function	rdledgn	:integer; external DLLDRIVER;
function	rdirqpc	:integer; external DLLDRIVER;
procedure	mcuinit	(var rosi:ROSI); external DLLDRIVER;
procedure	mcuinit2(var rosi:ROSI; TpuBaseAddress: integer); external DLLDRIVER;
procedure	wrjovr	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdjovr	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrtrovr	(var value:double); external DLLDRIVER;
procedure	rdtrovr	(var value:double); external DLLDRIVER;
function	wrtrovrst(var value:double): integer; external DLLDRIVER;
function	rdtrovrst(var value:double): integer; external DLLDRIVER;
function	wrShortProfile(var value:double): integer; external DLLDRIVER;
function	rdShortProfile(var value:double): integer; external DLLDRIVER;
procedure	utrovr	(var as_:AS_); external DLLDRIVER;
procedure	rdf	    (var tsrp:TSRP); external DLLDRIVER;
procedure	rdap	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdsll	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrsll	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdslr	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrslr	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdipw	(var tsrp:TSRP); external DLLDRIVER;
procedure	wripw	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdmpe	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrmpe	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdsdec	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrsdec	(var tsrp:TSRP); external DLLDRIVER;
procedure	spd	    (an:integer; size:integer; var spdbuf:SPDBUF); external DLLDRIVER;
procedure	spda	(an:integer; size:integer; var spdbuf:SPDBUF; PcapIndex: integer); external DLLDRIVER;
procedure	spdr	(an:integer; size:integer; var spdbuf:SPDBUF; PcapIndex: integer); external DLLDRIVER;
procedure	sstvl	(var as_:AS_; tvl: double); external DLLDRIVER;
procedure	wrgf	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdgf	(var tsrp:TSRP); external DLLDRIVER;
procedure	spvtd	(an:integer; size:integer; var spvtdbuf:SPVTDBUF); external DLLDRIVER;
procedure	ms	    (var as_:AS_); external DLLDRIVER;
procedure	js	    (var as_:AS_); external DLLDRIVER;
procedure	lps	    (an:integer; mst:integer); external DLLDRIVER;
procedure	rdigi	(var tsrp:TSRP); external DLLDRIVER;
procedure	rdlpndx	(var tsrp:TSRP); external DLLDRIVER;
procedure	wrlpndx	(var tsrp:TSRP); external DLLDRIVER;

function	InitMcuSystem(var tsrp:TSRPSETS):integer; external DLLDRIVER;
function	InitMcuSystem2(var tsrp:TSRPSETS; TpuBaseAddress:integer; filename: CppString):integer; external DLLDRIVER;
function	InitMcuSystem3(var tsrp:TSRPSETS; var rosi:ROSI; TpuBaseAddress:integer; filename: CppString; var BoardType:integer):integer; external DLLDRIVER;
function	InitMcuSystem4(var tsrp:TSRPSETS; var rosi:ROSI; TpuBaseAddress:integer; filename: CppString; var BoardType:integer; var NrCards:integer):integer; external DLLDRIVER;
procedure	InitMcuErrorReport(error:integer); external DLLDRIVER;
procedure	txbfErrorReport(filename:CppString; error:integer); external DLLDRIVER;
procedure	BootErrorReport(filename:CppString; error:integer); external DLLDRIVER;

procedure	McuClose; external DLLDRIVER;
function	BootFile(filename:CppString; TpuBaseAddress:integer):integer; external DLLDRIVER;
procedure	wrBlk   (buffer:CppString); external DLLDRIVER;
function	rdBlk   (buffer:CppString):integer; external DLLDRIVER;

procedure	wrtp    (var tsrp:TSRP); external DLLDRIVER;
procedure	rdrpd   (var tsrp:TSRP); external DLLDRIVER;
procedure	rddpd   (var tsrp:TSRP); external DLLDRIVER;
procedure	rdtpd   (var tsrp:TSRP); external DLLDRIVER;
procedure	scp     (an: integer; var ctrlrparams: CTRLRPARAMS); external DLLDRIVER;
procedure	rdrv    (an: integer; var value: double); external DLLDRIVER;
procedure	cm      (an: integer; var value: integer); external DLLDRIVER;
procedure	spd2d   (var spd2params: SPD2DPARAMS); external DLLDRIVER;
procedure	rdlrpr  (var latch_infos: LATCH_INFOS; var buffer: POSBUF); external DLLDRIVER;
procedure	rdldpr  (var latch_infos: LATCH_INFOS; var buffer: POSBUF); external DLLDRIVER;
procedure	getcnctsrclinenr (TaskNr: integer; var LineNr: integer); external DLLDRIVER;
function	getmsgstr(an: integer; result: CppString):integer; external DLLDRIVER;
procedure	getcnctfh(TaskNr: integer; var fh: FILEHEADER); external DLLDRIVER;
procedure	burnaplpar(an: integer); external DLLDRIVER;
procedure	gettimers(var tsrp: TSRP; an: integer); external DLLDRIVER;
procedure	lpr     (var latch_infos: LATCH_INFOS); external DLLDRIVER;
procedure	lprs    (var as_: AS_; var latch_infos: LATCH_INFOS); external DLLDRIVER;
procedure	olsr    (var olsr: OLSR_INFOS); external DLLDRIVER;
procedure	rdasmecs(var tsrp: TSRP; var an: integer); external DLLDRIVER;
procedure	ReadLinkStatus (var fae: integer; var ba: integer); external DLLDRIVER;
function	rdAin   (an: integer; channel: integer):integer; external DLLDRIVER;
procedure	ssf     (an: integer; command: integer; value: double); external DLLDRIVER;
procedure	ssfn    (var as_:AS_; command: integer; value: double); external DLLDRIVER;
procedure	szpa    (an: integer; Position: double); external DLLDRIVER;
procedure	szpr    (an: integer; Position: double); external DLLDRIVER;
procedure	rdMcuStatus(buffer: CppString; size: integer); external DLLDRIVER;
procedure	rdAsmSecureParams(an: integer; buffer: CppString); external DLLDRIVER;
procedure	wrAsmSecureParams(an: integer; buffer: CppString); external DLLDRIVER;
procedure	LdSSplineA (var as_:AS_; var lmp:LMP); external DLLDRIVER;
procedure	LdSSplineR (var as_:AS_; var lmp:LMP); external DLLDRIVER;
procedure	ExeSSpline (var as_:AS_; var lmp:LMP); external DLLDRIVER;

function    wrOptionInt(var odesc: OptionDescriptorObject; var val: integer): integer; external DLLDRIVER;
function    rdOptionInt(var odesc: OptionDescriptorObject; var val: integer): integer; external DLLDRIVER;
function    wrOptionDbl(var odesc: OptionDescriptorObject; var val: double): integer; external DLLDRIVER;
function    rdOptionDbl(var odesc: OptionDescriptorObject; var val: double): integer; external DLLDRIVER;
function    freeOptionHandle(var odesc: OptionDescriptorObject): integer; external DLLDRIVER;

function    rdScannerBufferSize: integer; external DLLDRIVER;
function    rdScannerStatus: integer; external DLLDRIVER;
function    rdScannerLsm: integer; external DLLDRIVER;
function    rdScannerBuffer	(buffer: CppString; size: integer): integer; external DLLDRIVER;
function    SendReqScannerBuffer	(buffer: CppString; size: integer): integer; external DLLDRIVER;
procedure	CleanServiceData; external DLLDRIVER;

function    wrElCamTable32	(buffer: CppString; size: integer; ElCamTableNr: integer): integer; external DLLDRIVER;
function    wrElCamTable64	(buffer: CppString; size: integer; ElCamTableNr: integer): integer; external DLLDRIVER;

procedure	wrModeReg  (var value: integer); external DLLDRIVER;
procedure	rdModeReg  (var value: integer); external DLLDRIVER;
procedure	wrnfrax    (var value: integer); external DLLDRIVER;
procedure	rdnfrax    (var value: integer); external DLLDRIVER;
procedure	wrErrorReg (var value: integer); external DLLDRIVER;
procedure	rdErrorReg (var value: integer); external DLLDRIVER;
procedure	wrMDVel    (an: integer; var value: double); external DLLDRIVER;
procedure	rdMDVel    (an: integer; var value: double); external DLLDRIVER;
procedure	wrMaxVel   (an: integer; var value: double); external DLLDRIVER;
procedure	rdMaxVel   (an: integer; var value: double); external DLLDRIVER;
procedure	wrMaxAcc   (an: integer; var value: double); external DLLDRIVER;
procedure	rdMaxAcc   (an: integer; var value: double); external DLLDRIVER;
procedure	wrEffRadius(an: integer; var value: double); external DLLDRIVER;
procedure	rdEffRadius(an: integer; var value: double); external DLLDRIVER;
procedure	rdPosErr   (an: integer; var value: double); external DLLDRIVER;
procedure	rdMCiS     (an: integer; var value: integer); external DLLDRIVER;
procedure	MsgToScreen (Enable: integer); external DLLDRIVER;
procedure	wrJerkRel   (an: integer; var value: double); external DLLDRIVER;
procedure	rdJerkRel   (an: integer; var value: double); external DLLDRIVER;
procedure	wrJerk      (an: integer; var value: double); external DLLDRIVER;
procedure	rdJerk      (an: integer; var value: double); external DLLDRIVER;
procedure	rdOsVersion	(var OsVersion : integer); external DLLDRIVER;
procedure	wrslsp      (an: integer; var value: double); external DLLDRIVER;
function	rdslsp      (an: integer; var value: double): integer; external DLLDRIVER;
function	accstop	    (var as_: AS_): integer; external DLLDRIVER;
function	getEnvStr   (EnvStr: CppString): integer; external DLLDRIVER;
function	gettskinfo	(TaskNr: integer; var tskinfo: integer): integer; external DLLDRIVER;
function	gettskstr	(TaskNr: integer; buffer: CppString; szbuffer: integer): integer; external DLLDRIVER;
function	CardSelect  (CardNum: integer): integer; external DLLDRIVER;
function 	MCUG3_SetBoardIntRoutine (func : Pointer): integer; external DLLDRIVER;
function 	MCUG3_ResetBoardIntRoutine (): integer; external DLLDRIVER;
function	wrdpoffset (an: integer; var value: double): integer; external DLLDRIVER;
function	rddpoffset (an: integer; var value: double): integer; external DLLDRIVER;
function	wrdvoffset (an: integer; var value: double): integer; external DLLDRIVER;
function	rddvoffset (an: integer; var value: double): integer; external DLLDRIVER;
function	rdZeroOffset (an: integer; var value: double) : integer; external DLLDRIVER;
function	wrtrjerk	(var value:double) : integer; external DLLDRIVER;
function	rdtrjerk	(var value:double) : integer; external DLLDRIVER;
function	wrtrac		(var value:double) : integer; external DLLDRIVER;
function	rdtrac		(var value:double) : integer; external DLLDRIVER;
function	wrtrvl		(var value:double) : integer; external DLLDRIVER;
function	rdtrvl		(var value:double) : integer; external DLLDRIVER;
function	wrtrtvl		(var value:double) : integer; external DLLDRIVER;
function	rdtrtvl		(var value:double) : integer; external DLLDRIVER;
function	rdptp 		(an: integer; var value: double) : integer; external DLLDRIVER;
function	rdpir       (var value: integer) : integer; external DLLDRIVER;
function	rddtv       (var value: array of double) : integer; external DLLDRIVER;
procedure	wrGCR	   	(an: integer; var value: integer); external DLLDRIVER;
procedure	rdGCR    	(an: integer; var value: integer); external DLLDRIVER;
function	allocPhysMem (var VirtualAdr: Pointer; var PhysAdr: integer; size : integer): integer; external DLLDRIVER;
function	freePhysMem (VirtualAdr: Pointer): integer; external DLLDRIVER;
function	wrgfaux 	(an: integer; var value: double): integer; external DLLDRIVER;
function	rdgfaux 	(an: integer; var value: double): integer; external DLLDRIVER;
procedure	ClearCI99	(); external DLLDRIVER;
procedure	RPtoDP	    (var as_:AS_); external DLLDRIVER;
procedure	wrControllerFlags(an: integer; var value: integer); external DLLDRIVER;
procedure	rdControllerFlags(an: integer; var value: integer); external DLLDRIVER;
function	rdpeaux		(an: integer; var value: double) : integer; external DLLDRIVER;
function	wrVBError	(an: integer; var value: double) : integer; external DLLDRIVER;
function	rdVBError	(an: integer; var value: double) : integer; external DLLDRIVER;
function	rdPcapIndex	(an: integer; var value: integer) : integer; external DLLDRIVER;
function	rdSysVarInt	(cmd: integer; var value: integer) : integer; external DLLDRIVER;
function	rdSysVarDbl	(cmd: integer; var value: double)  : integer; external DLLDRIVER;
function	wrSysVarInt	(cmd: integer; var value: integer) : integer; external DLLDRIVER;
function	wrSysVarDbl	(cmd: integer; var value: double)  : integer; far; external DLLDRIVER;
function	rdAxVarInt	(cmd: integer; axndx: integer; var value: integer) : integer; external DLLDRIVER;
function	rdAxVarDbl	(cmd: integer; axndx: integer; var value: double)  : integer; external DLLDRIVER;
function	wrAxVarInt	(cmd: integer; axndx: integer; var value: integer) : integer; external DLLDRIVER;
function	wrAxVarDbl	(cmd: integer; axndx: integer; var value: double)  : integer; external DLLDRIVER;
end.


