/*

  +-----------------------------------------------------------------------+
  | (C) Roesch & Walter Industrie-Elektronik GmbH                         |
  | Im Heidenwinkel 5            D-77963 Schwanau                         |
  +-------------------------------+---------------------------------------+
  | Tel : +49 (0) 7824/6628-0     | email    : support@rw-gmbh.de         |
  | Fax : +49 (0) 7824/6628-29    | Internet : http://www.rw-gmbh.de      |
  +-------------------------------+---------------------------------------+
  | Project     : MCUG3 TOOLSET   | Compiler : BORLAND C++ Builder        |
  |                               |            MICROSOFT Visual C++       |
  | Module name : sample01.cpp    | Operating System:                     |
  |                               |            - Windows 95/98/Me         |
  |                               |            - Windows NT 4.0           |
  |                               |            - Windows NT Embedded 4.0  |
  |                               |            - Windows 2000             |
  +-------------------------------+---------------------------------------+
  | Author : Roesch R.               Date :06/04/2001                     |
  |          Walter M.                                                    |
  +-----------------------------------------------------------------------+
  | Description   : Sample Program File for the                           |
  |                 High-Performance Motion-Control Family Generation 3   |
  |                                                                       |
  |                 Currently supported G3-Controllers:                   |
  |                         MCU-3000, APCI-8001, MCU-6000 and APCI-8401   |
  |                                                                       |
  |                                                                       |
  +-----------------------------------------------------------------------+
	
	Revision History:
	-----------------
    13/04/2001	V2-50	rr	Bootfile() after InitMcuSytem2() and using rwmos.elf
	06/04/2001	V2-50	rr	Imported from move sample program

*/


#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "mcug3.h"


#define A1			0
#define	A2			1
#define	TRUE		1
#define	FALSE		0


char			Flicks[]="|/-\\|/-\\";
int 			Flick=0;
struct	TSRP		tsrp[MAXAXIS];
const	MSKERRFLAGS	= 0xFFF;	/* Mask for error flags in axst register */

void axst_Report(int axis, union AXST axst)
{
	printf ("\nAxis: %i\n", axis+1);
	printf ("\naxst: %li\n", axst.status_word);
	if (axst.bit.eo) 	printf ("Emergency Out!\n");
	if (axst.bit.dnr)	printf ("Drive not Ready!\n");
	if (axst.bit.lslh)	printf ("Limit switch left hardware!\n");
	if (axst.bit.lsrh)	printf ("Limit switch right hardware!\n");
	if (axst.bit.lsls)	printf ("Limit switch left software!\n");
	if (axst.bit.lsrs)	printf ("Limit switch right software!\n");
	if (axst.bit.mpe)	printf ("Maximum position error!\n");
	if (!axst.bit.cl)	printf ("Loop not closed in axis: %i!\n", axis+1);
}

long chkfpe(int axis)
{

/*
	return:	0  if pe found
		-1 if pe not found
		axst if error occured
*/
	long	result;

	rdaxst(&tsrp[axis]);
	if (tsrp[axis].axst.status_word & MSKERRFLAGS) {
		result = tsrp[axis].axst.status_word;
		axst_Report(axis, tsrp[axis].axst);
	} else if (!tsrp[axis].axst.bit.cl) {
		result = tsrp[axis].axst.status_word;
		axst_Report(axis, tsrp[axis].axst);
	} else if (tsrp[axis].axst.bit.pe) {
		result = 0;
	} else {
		result = -1;
	}
	return (result);
}

long weop (struct AS *as)
{
	const char	funcst[] ="WEOP ";
	int		i, sl;
	long		result;
	union AXST	axst;
	struct AS	done;

	done.unoa = as->unoa;
	for (i = 0; i < done.unoa; i++) done.san[i] = 0;
	result = 0;
	printf("%s", funcst);

	while (done.unoa > 0) {
		for (i = 0; i < as->unoa; i++) { 
			printf("%c\b", Flicks[Flick]); fflush(stdout);
			if ( ++Flick == 8 ) Flick -= 8;
			axst.status_word = chkfpe((int) as->san[i]);
			if (!axst.status_word) {
				if (!done.san[i]) {
					done.unoa--;
					done.san[i] = 1;
				}
			} else if (axst.status_word == -1) {
				Sleep(1);
			} else {
				result = axst.status_word;
				done.unoa   = 0;
			}
		}
	}

	sl = strlen(funcst) + 1;
	for (i = 0; i < sl; i++) printf("\b");
	for (i = 0; i < sl; i++) printf("%c", ' ');
	for (i = 0; i < sl; i++) printf("\b");
	fflush(stdout);

	return (result);
}

int jog_home(int axis)
{
	const char	funcst[]= "JGHM: ";
	const long	BITLOC_lslh = 0x0008,
			BITLOC_lsrh = 0x0010,
			BITLOC_lsls = 0x0020,
			BITLOC_lsrs = 0x0040;
	int		i, done, error, srchndx, sl;		
	long		chkmsk;
	double		hvl;
	struct AS	las;

	/* goto reference position axis */
	las.unoa		= 1;
	las.san[0]	= axis;

	done    = FALSE;	
	error   = FALSE;
	srchndx = 0;

	/* initiate homing by jogging in left search direction */
	jhl(&las);

	while (!done) {

		printf("%c\b", Flicks[Flick]); fflush(stdout);
		if ( ++Flick == 8 ) Flick -= 8;

		/* wait for end of profile from 'axis' */
		rdaxst(&tsrp[axis]);

		/* Check for error flags in axst */
		if (tsrp[axis].axst.status_word & MSKERRFLAGS) {
			/* check error flags ignore hard-and software limit switches */
			chkmsk = ~ (BITLOC_lslh | BITLOC_lsrh | BITLOC_lsls | BITLOC_lsrs);
			if (tsrp[axis].axst.status_word & chkmsk & MSKERRFLAGS) {
				/* an unallowed error occured */
				axst_Report(axis, tsrp[axis].axst);
				error = TRUE; done = TRUE;
			} else {
				/* check for hardware limit switch: error allowed here */
				if (tsrp[axis].axst.bit.lslh) {
					/* left limit switch -> jog to right side */
					if (srchndx > 0) {
						printf ("Axis: %i\n", axis+1);
						printf ("Limit switch left hardware when waiting for index!");
						error = TRUE; done = TRUE;
					} else jhr(&las);
				} else if (tsrp[axis].axst.bit.lsrh) {
					/* right limit switch -> jog to left side */
					if (srchndx > 0) {
						printf ("Axis: %i\n", axis+1);
						printf ("Limit switch right hardware when waiting for index!");
						error = TRUE; done = TRUE;
					} else jhl(&las);
				}
			}
		/* check for close loop status flag */
		} else if (!tsrp[axis].axst.bit.cl) {
			axst_Report(axis, tsrp[axis].axst);
			error = TRUE; done = TRUE;
		/* check for profile end status flag */
		} else if (tsrp[axis].axst.bit.pe) {
			switch (srchndx++) {
				case 0:
					/* search index pulse in positive direction
					   end searching after maximum 1.5mm */
					tsrp[axis].tp = 1.5;	/* assuming [MM] for axis specific unit */
					jhi(&las, tsrp);
					break;
				case 1:
					/* search index pulse in negative direction
					   end searching after maximum 0.5mm */

					/* save current home velocity */
					hvl = tsrp[axis].hvl;
					/* select a new (slower) home velocity */
					tsrp[axis].hvl = 0.1;
					wrhvl(&tsrp[axis]);
					tsrp[axis].tp = -0.5;	/* assuming [MM] for axis specific unit */
					jhi(&las, tsrp);
					/* restore old home velocity */
					tsrp[axis].hvl = hvl;
					wrhvl(&tsrp[axis]);
					break;
				case 2:
					/* search index pulse in positive direction
					   end searching after maximum 0.5mm */

					/* save current home velocity */
					hvl = tsrp[axis].hvl;
					/* select a new (slower slower) home velocity */
					tsrp[axis].hvl = 0.01;
					wrhvl(&tsrp[axis]);
					tsrp[axis].tp = +0.5;	/* assuming [MM] for axis specific unit */
					jhi(&las, tsrp);
					/* restore old home velocity */
					tsrp[axis].hvl = hvl;
					wrhvl(&tsrp[axis]);
					break;
				case 3:
					/* Indexing complete */
					/* set home position for desired axis to desired value = 0.0 */
					tsrp[axis].tp = 100.0;
					shp(&tsrp[axis]);
					error = FALSE; done = TRUE;
					break;
			}
		} else {
			Sleep (1);
		}
	}

	if (!error) {
		sl = strlen(funcst) + 1;
		for (i = 0; i < sl; i++) printf("\b");
		for (i = 0; i < sl; i++) printf("%c", ' ');
		for (i = 0; i < sl; i++) printf("\b");
		fflush(stdout);
	}

	return(error);
}

/* Reset axis A1 and A2, halt program */
void stop(void)
{
	struct AS	las;

	las.unoa 	= 2;		/* select 2 axis */
	las.san[0]	= A1;		/* first axis is A1 */
	las.san[1]	= A2;		/* second axis is A2 */
	ra (&las);			/* reset axis */
	McuClose ();
	exit(1);			/* stop this program */
}


/* Please change SystemFileName and BootFileName according your file and directory setup */

char SystemFileName[]	= "l:\\mcug3\\rwmos\\mcfg\\system mcu3000 schrank.dat";
char BootFileName[]		= "l:\\mcug3\\rwmos\\mcu3000\\rwmos.elf";

int main(int argc, char *argv[ ], char *envp[ ]) { 
	int			error;
	struct AS		as;
	struct LMP		lmp;
	struct CMP		cmp;
	struct TRU		tru;


	/* Call Initialise system at the very beginning, before calling any other MCUG3-function */
	if ((error = InitMcuSystem2(tsrp, 0x0, SystemFileName)) != 0) {
		/* if not successfull try to boot MCU-G3 */
		if ((error = BootFile (BootFileName, 0x0)) != 0) {
			BootErrorReport(BootFileName, error);
			McuClose ();
			exit (error);
		};

		/* try again to initialise */
		if ((error = InitMcuSystem2(tsrp, 0x0, SystemFileName)) != 0) {
			/* make detailed error report */
			InitMcuErrorReport(error);
			McuClose ();
			exit(error);
		}
	}

	/* reset system */
	rs();						/* Reset MCU-G3 controller */ 

	as.unoa 		= 2;		/* 2 axis interpolation */
	as.san[0]	 	= A1;		/* first interpol. axis is A1 */
	as.san[1]	 	= A2;		/* second interpol. axis is A2 */

	//	ra (&as);

	tsrp[A2].digo = 0xC0;			/* set output 7 and 8 */
	wrdigo(&tsrp[A2]);	

	/* select Position and Time Units for interpolation commands */
	tru.pu			= 0;		/* select milimeters for position units */
	tru.tu			= 0;		/* select seconds for time units */
	ctru(&tru);			/* change trajectory units */

	/* close loop axis A1 and A2 */
	cl (&as);

	/* homing A2 */
	if (jog_home(A2)) stop();

	/* setup linear trajectory parameters */
	lmp.ac 		= 500.0;	/* acceleration [MM/SEC] */
	lmp.vl		= 50.0;		/* velocity [MM/SEC] */
	lmp.tvl		= 0.0;		/* target velocity [MM/SEC] */
	lmp.dtm[A1]	= 1.0e2;	/* distance to move A1 [MM] */
	lmp.dtm[A2]	= 1.0e2;	/* distance to move A2 [MM] */

	/* setup circular trajectory parameters */
	cmp.ac 		= 250.0;	/* acceleration [MM/SEC] */
	cmp.vl		= 50.0;		/* velocity [MM/SEC] */
	cmp.tvl		= 0.0;		/* target velocity [MM/SEC] */
	cmp.phi		= 360;		/* angle [degrees] */
	cmp.dtca1	= 50;		/* distance to center A1 [MM] */
	cmp.dtca2	= 0.0;		/* distance to center A2 [MM] */

	/* make relative linear move */
	mlr (&as, &lmp);
	/* wait for end of profile from axis A1 and A2 */
	if (weop(&as)) stop();

	/* make relative circular move */
	mcr (&as, &cmp);
	/* wait for end of profile from axis A1 and A2 */
	if (weop(&as)) stop();


	/* make simple jog absolute with axis A2 */
	as.unoa		= 1;
	as.san[0]	= A2;
	tsrp[A2].tp	= 800.0;	/* assuming [MM] for axis specific position unit */
	ja(&as, tsrp);		/* jog absolute */
	/* wait for end of profile from axis A2 */
	if (weop(&as)) stop();

	/* Display some axis specific datas */
	rdrp(&tsrp[A2]);		/* read real position of A2 */
	rddp(&tsrp[A2]);		/* read desired position of A2 */
	rdtp(&tsrp[A2]);		/* read target position of A2 */
	printf("Real position    : %20.17le\n", tsrp[A2].rp);
	printf("Desired position : %20.17le\n", tsrp[A2].dp);
	printf("Target position  : %20.17le\n", tsrp[A2].tp);
	McuClose ();
	
	return(0);
}

